#define HONEYDANBER /* means use ASCII pids in lock files */
#if defined(SHARE_DEBUG)
#define LOG_LOCKS
#endif
/*+-----------------------------------------------------------------------
	eculock.c -- lock file management
	wht@n4hgf.Mt-Park.GA.US

  Defined functions:
	create_lock_file(name)
	lock_tty(line)
	unlock_tty(line)

Lock files under SCO are supposed to use the direct line name
(lower-case last letter); we create only the lower-case case, but
check for both.  I have most definitely seen somebody create an
upper-case lock file (somebody named getty).  But that was on a middle-
aged XENIX revision.
------------------------------------------------------------------------*/
/*+:EDITS:*/
/*:09-10-1992-13:58-wht@n4hgf-ECU release 3.20 */
/*:08-22-1992-15:38-wht@n4hgf-ECU release 3.20 BETA */
/*:07-19-1992-22:09-wht@n4hgf-rename check_utmp to reserve_line and move it */
/*:07-19-1992-21:54-wht@n4hgf-lock_tty does not effect ungetty_get anymore */
/*:08-25-1991-14:39-wht@n4hgf-SVR4 port thanks to aega84!lh */
/*:08-10-1991-17:39-wht@n4hgf-US_WEGOTIT handling */
/*:08-09-1991-11:07-wht@n4hgf-configurable lock directory */
/*:07-25-1991-12:56-wht@n4hgf-ECU release 3.10 */
/*:10-16-1990-20:43-wht@n4hgf-add SHARE_DEBUG */
/*:09-19-1990-19:36-wht@n4hgf-ecu_log_event now gets pid for log from caller */
/*:08-14-1990-20:40-wht@n4hgf-ecu3.00-flush old edit history */

#include "ecu.h"

extern int errno;
extern char ungetty_ttyname[];
extern char lopen_err_str[];

/*+-------------------------------------------------------------------------
	create_lock_file(name)
--------------------------------------------------------------------------*/
int
create_lock_file(name)
char *name;
{
	register fd;
	int pid = getpid();
	char LTMP_fname[64];
#if defined(HONEYDANBER)
	char pid10str[12];
#endif

	errno = 0;
	sprintf(LTMP_fname,"%s/LTMP.%05d",lock_dir_name,pid);
	if((fd = creat(LTMP_fname,0444)) < 0)
	{
		if(errno == EACCES)
		{
			strcpy(lopen_err_str,"lock error - try chmod 0777 ");
			strcat(lopen_err_str,lock_dir_name);
		}
		unlink(LTMP_fname);
		return(-1);
	}
#if defined(HONEYDANBER)
	sprintf(pid10str,"%10d\n",getpid());
	write(fd,pid10str,11);
#else
	write(fd,(char *)&pid,sizeof(int));
#endif

	chmod(LTMP_fname,0444);	/* some programs seem to think writable
							 * lock file is game for killing
							 */
	close(fd);

	fd = link(LTMP_fname,name);		/* use 'fd' for link return code */
	unlink(LTMP_fname);
	chmod(name,0444);

#if defined(LOG_LOCKS)
	{
		char s128[128];
		extern char *errno_text();
		sprintf(s128,"CRLOCK %s status=%d errno=%s",name,fd,errno_text(errno));
		ecu_log_event(getpid(),s128);
	}
#endif

	return(fd);
}	/* end of create_lock_file */

/*+-------------------------------------------------------------------------
	lock_tty(line) - create lock files for tty line in 'line'

return 0 if locked else LINST_... error
--------------------------------------------------------------------------*/
int
lock_tty(line)
char *line;
{
	register linst = 0;
	char lockname[128];

	lockname[0] = 0;
	errno = 0;

	if(linst = make_lock_name(line,lockname))
		goto RETURN;


	if(create_lock_file(lockname))
	{
		if(linst = is_active_lock(lockname))
		{
			if(linst == LINST_WEGOTIT)
			{
				linst = 0;
				goto RETURN;
			}
			ungetty_return_line(line);
			errno = EACCES; /* for termecu() */
			goto RETURN;
		}
		if(create_lock_file(lockname))
		{
			ungetty_return_line(line);
			errno = EACCES; /* for termecu() */
			{
				linst = LINST_LCKERR;
				goto RETURN;
			}
		}
	}

RETURN: ;

#if defined(LOG_LOCKS)
	{
		extern char *errno_text();
		char s128[128];
		sprintf(s128,"LOCKTTY %s status %d errno=%s",line,
			linst,errno_text(errno));
		ecu_log_event(getpid(),s128);
	}
#endif

	return(linst);

}	/* end of lock_tty */

/*+-----------------------------------------------------------------------
	void unlock_tty(line)
------------------------------------------------------------------------*/
void
unlock_tty(line)
char *line;
{
	char lockname[128];

	if(make_lock_name(line,lockname))
	{
		ff(se,"unlock_tty cannot build lock file for %s\r\n",line);
		termecu(TERMECU_LOGIC_ERROR);
	}

	ungetty_return_line(line);
	unlink(lockname);

}	/* end of unlock_tty */

/* end of eculock.c */
/* vi: set tabstop=4 shiftwidth=4: */
