/*+-----------------------------------------------------------------------
	ecuicmd.c - ECU interactive command handler
	wht@n4hgf.Mt-Park.GA.US

  Defined functions:
	icmd(icmd_cmd)
	icmd_do_proc(ndoarg,doarg)
	search_cmd_list(cmd_list,cmd)

------------------------------------------------------------------------*/
/*+:EDITS:*/
/*:10-18-1992-14:26-wht@n4hgf-add conxon */
/*:10-08-1992-01:12-wht@n4hgf-no more obsolete Metro Link PTS */
/*:09-17-1992-06:27-wht@n4hgf-add <7-bit kbd> to stat */
/*:09-13-1992-12:52-wht@n4hgf-show tty_is_scoterm during stat */
/*:09-10-1992-13:58-wht@n4hgf-ECU release 3.20 */
/*:08-30-1992-23:15-wht@n4hgf-add fkmap */
/*:08-22-1992-15:38-wht@n4hgf-ECU release 3.20 BETA */
/*:04-17-1992-18:22-wht@n4hgf-fkey command has -r reset switch */
/*:12-13-1991-17:14-wht@n4hgf-formalize bell notify */
/*:11-30-1991-13:46-wht@n4hgf-smap conditional compilation reorg */
/*:10-04-1991-17:23-wht@n4hgf-reset proc_interrupt before interactive pcmd */
/*:08-25-1991-14:39-wht@n4hgf-SVR4 port thanks to aega84!lh */
/*:08-17-1991-18:29-wht@n4hgf-add kbdtest command */
/*:07-29-1991-20:56-wht@n4hgf-turn off memstat after frustrating evening */
/*:07-29-1991-17:57-wht@n4hgf-add memstat */
/*:07-25-1991-12:56-wht@n4hgf-ECU release 3.10 */
/*:05-21-1991-18:22-wht@n4hgf-add pushd/popd commands */
/*:05-21-1991-00:46-wht@n4hgf-added -3 error code to keyset_read */
/*:03-20-1991-05:25-root@n4hgf-experimental eto command */
/*:03-20-1991-04:55-root@n4hgf-Metro Link support + stat cmd changes */
/*:02-04-1991-19:03-wht@n4hgf-add multiscreen tag to stat */
/*:01-09-1991-22:31-wht@n4hgf-ISC port */
/*:12-24-1990-04:31-wht@n4hgf-experimental fasi driver command */
/*:08-14-1990-20:40-wht@n4hgf-ecu3.00-flush old edit history */

#include "ecu.h"
#include "esd.h"
#include "ecufkey.h"

#define NEED_P_CMD
#include "ecucmd.h"

#if defined(FASI)
# include <local/fas.h>
#endif

#if defined(SVR4)
# include <sys/termiox.h>
extern int hx_flag;
#endif

char *bell_notify_text();

extern char kbd_is_7bit;	/* keyboard has parity */
extern KDE keyset_table[];
extern char *makedate;
extern char curr_dir[CURR_DIRSIZ];
extern char hello_str[];
extern char keyset_name[];
extern char rcvr_log_file[];	/* if rcvr_log!= 0,log filename */
extern int current_ttymode;
extern long tty_escape_timeout;		/* timeout on waiting for char after ESC */
extern int tcap_COLS;
extern int tcap_LINES;
extern int errno;
extern int proc_interrupt;
extern int proctrace;
extern int rcvr_log;			/* rcvr log active if != 0 */
extern int rcvr_log_append;	/* if true, append, else scratch */
extern int rcvr_log_raw;		/* if true, log all, else filter ctl chrs */
extern ulong colors_current;
extern FILE *plog_fp;
extern ESD  *plog_name;
extern char screen_dump_file_name[];

int protocol_log_packets = 0;

/*+-------------------------------------------------------------------------
	search_cmd_list(cmd_list,cmd)
returns -1 if cmd not found or insufficient chars for match
else token value for command
proc-only commands have 'min_ch' values 0
--------------------------------------------------------------------------*/
search_cmd_list(cmd_list,cmd)
register P_CMD *cmd_list;
register char *cmd;
{
	while(cmd_list->token != -1)
	{
		if(cmd_list->min_ch && minunique(cmd_list->cmd,cmd,cmd_list->min_ch))
			return(cmd_list->token);
		cmd_list++;
	}
	return(-1);

}	/* end of search_cmd_list */

/*+-------------------------------------------------------------------------
	icmd_do_proc(ndoarg,doarg)
--------------------------------------------------------------------------*/
icmd_do_proc(ndoarg,doarg)
int ndoarg;
char **doarg;
{
register erc;
ulong colors_at_entry = colors_current;

	kill_rcvr_process(SIGUSR1);
	ttymode(2);
	erc = do_proc(ndoarg,doarg);
	proc_file_reset();
	ttymode(1);
	sigint = 0;
	setcolor(colors_notify);
	ff(se,"[procedure finished]");
	setcolor(colors_at_entry);
	ff(se,"\r\n");
	start_rcvr_process(0);
	return(erc);
}	/* end of icmd_do_proc */

/*+-----------------------------------------------------------------------
	icmd(cmd)
 This function implements the built in commands
 It returns non-zero if program should terminate
------------------------------------------------------------------------*/
int
icmd(icmd_cmd)
register char *icmd_cmd;
{
#define ARG_MAX_QUAN 40
	char *arg[ARG_MAX_QUAN];
	char *cptr = "???";
	char cmd[128];
	int itmp,itmp2,itmp3;
	int token;
	int narg = 0;
	ESD *tesd;
	char s80[80];
	char *epoch_secs_to_str();
	long atol();
	char *find_procedure();
	char *xon_status();
	char *console_xon_status();
#ifdef sun
	int modem_lines;
#endif

	icmd_history_add(icmd_cmd);		/* add to history list */
	strcpy(cmd,icmd_cmd);			/* get local copy of cmd string */
	switch(cmd[0]) 
	{
		case '.':
			strcpy(cmd,"exit");
			break;
		case '!':
		case '$':
		case '>':
			ff(se,"\r\n");
			shell(cmd);
			return(0);
		case '-':
			ff(se,"\r\n");
			exec_cmd(&cmd[1]);
			return(0);
		case '^':
			ff(se,"\r\n");
			phrase_help();
			return(0);
		case '?':
			icmd_help(0,(char **)0);
			return(0);
		default:
			break;
	}

/* not single character argument */
	build_arg_array(cmd,arg,ARG_MAX_QUAN,&narg);

/* handle phrases */
	if(isdigit(*arg[0]))
	{
		phrases(narg,arg);
		return(0);
	}

/* search command list */
	if((token = search_cmd_list(icmd_cmds,arg[0])) < 0)
	{
		ff(se,"\r\n");
		if(find_procedure(arg[0]))
		{
			icmd_do_proc(narg,arg);
			return(0);
		}
		ff(se,"no such command or procedure ... HOME ? for help\r\n");
		return(0);
	}

	switch(token)
	{					/* keep alphabetized PLEASE */
		case CTrx:
		case CTry:
		case CTrz:
		case CTrk:
		case CTrs:
		receive_files_from_remote(narg,arg);
		break;

		case CTsx:
		case CTsy:
		case CTsz:
		case CTsk:
		case CTss:
		send_files_to_remote(narg,arg);
		break;

		case CTautorz:
		if(narg > 1)
		{
			shm->autorz = yes_or_no(arg[1]);
			shm->autorz_pos = 0;
		}
		ff(se,"  automatic ZMODEM receive %s",shm->autorz ? "on" : "off");
		ff(se,"\r\n");
		break;

		case CTbaud:
		if(narg == 1)
			ff(se,"   baud rate is %u\r\n",shm->Lbaud);
		else
		{
			itmp = atoi(arg[1]);
			if(!lnew_baud_rate(itmp))
				ff(se,"   baud rate set to %u\r\n",shm->Lbaud);
			else
			{
				ff(se,"   invalid baud rate: %u\r\n",itmp);
				ff(se,"valid rates: 110,300,600,1200,2400,4800,9600,19200\r\n");
			}
		}
		break;

		case CTbreak:
		lbreak();
		ff(se,"   break sent\r\n");
		break;

		case CTcd:
		(void)change_directory(arg[1],(narg == 1) ? 0 : 1);
		break;

		case CTpushd:
		(void)push_directory(arg[1],(narg == 1) ? 0 : 1,0);
		break;

		case CTpopd:
		(void)pop_directory(arg[1],(narg == 1) ? 0 : 1,0);
		break;

		case CTclrx:
		lclear_xmtr_xoff();
		ff(se,"  output xoff cleared\r\n");
		break;

		case CTdial:
		if(narg < 2)
			phdir_manager();
		else
		{
			extern char errmsg[];
			ff(se,"\r\n");
			if(call_logical_telno(arg[1]))
			{
				ff(se,"\r\n%s",errmsg);
				ff(se,"Try 'dial' with no arguments or 'help dial'\r\n");
			}
		}
		break;

		case CTdo:
		ff(se,"\r\n");
		icmd_do_proc(narg - 1,&arg[1]);
		break;

		case CTptrace:
		if(narg > 1)
			proctrace = yes_or_no(arg[1]);
		ff(se,"  procedure trace %s",proctrace ? "on" : "off");
		if(proctrace > 1)
			ff(se," (%d)",proctrace);
		ff(se,"\r\n");
		break;

		case CTpcmd:
		itmp = strlen(arg[0]);
		if(!(tesd = esdalloc(256)))
		{
			ff(se,"  no memory?!\r\n");
			break;
		}
		strcpy(tesd->pb,icmd_cmd + itmp + 1);
		tesd->cb = strlen(tesd->pb);
		ff(se,"\r\n");
		kill_rcvr_process(SIGUSR1);
		ttymode(2);
		proc_interrupt = 0; /* in case last proc was sigint-ed */
		if(itmp = execute_esd(tesd))
		{
			proc_error(itmp);
			esdshow(tesd,"");
		}
		esdfree(tesd);
		ttymode(1);
		start_rcvr_process(0);
		break;

		case CTplog:
		fputs("  ",se);
		if(narg > 1)
		{
			if(!strcmp(arg[1],"off"))
				plog_control((char *)0);
			else
				plog_control(arg[1]);
		}
		
		if(plog_fp)
			ff(se,"procedure logging: %s\r\n",plog_name->pb);
		else
			fputs("procedure logging off\r\n",se);
		break;

		case CTduplex:
		if(narg > 1)
		{
			switch(to_lower(*arg[1]))
			{
				case 'f': shm->Lfull_duplex = 1; ff(se,"  now "); break;
				case 'h': shm->Lfull_duplex = 0; ff(se,"  now "); break;
				default: ff(se,
"\r\nfirst argument character must be F or H for full or half duplex\r\n");
					break;
			}
		}
		else		/* no argument */
			ff(se,"  currently ");

		ff(se,"%s duplex\r\n",(shm->Lfull_duplex) ? "full" : "half");
		break;

		case CTexit:
		ff(se,"  disconnecting from line %s\r\n",shm->Lline);
		return(1);

		case CTfi:
		file_insert_to_line(narg,arg);
		break;

		case CThangup:
		ff(se,"  hanging up ...\r\n");
		DCE_hangup();
#if defined(FASI)
		{
			uchar msr = fasi_msr();
			ff(se,"hangup complete ... DCD is %s\r\n",
				(msr & MS_DCD_PRESENT) ? "STILL HIGH" : "low");
		}
#else
		ff(se,"hangup complete\r\n");
#endif
		break;

		case CThelp:
		icmd_help(narg,arg);
		break;

		case CTsdname:
		if(narg > 1)
		{
		char *new_file_name;

			itmp = 0;	/* do not need to free(new_file_name) */
			if(find_shell_chars(arg[1]))
			{

				if(expand_wildcard_list(arg[1],&new_file_name))
				{
					ff(se,"  %s\r\n",new_file_name);
					break;
				}
				itmp = 1;	/* need to free(new_file_name) */
			}
			else
				new_file_name = arg[1];

			screen_dump_file_name[0] = 0;
			if(*new_file_name != '/')
			{
				strcpy(screen_dump_file_name,curr_dir);
				strcat(screen_dump_file_name,"/");
			}
			strcat(screen_dump_file_name,arg[1]);
			if(itmp)
				free(new_file_name);
		}
		ff(se,"\r\nscreen dump name: %s\r\n",screen_dump_file_name);
		break;

		case CTlog:
		case CTloff:
		case CTllp:
		icmd_log(token,narg,arg);
		break;

		case CTnl:
		case CTnlin:
		case CTnlout:
		nlin_nlout_control(token,narg,arg);
		break;

		case CTparity:
		if(narg > 1)
		{
			switch(to_lower(*arg[1]))
			{
				case 'n':
					shm->Lparity = 0; break;
				case 'e':
				case 'o':
					shm->Lparity = to_lower(*arg[1]); break;
				default:
					ff(se,"   unrecognized parity: %c\r\n",*arg[1]);
					goto PARITY_DONE;
			}
			lset_parity(1);
		}
		ff(se,"   parity set to %c\r\n",
			(shm->Lparity) ? to_upper(shm->Lparity) : 'N');
PARITY_DONE: ;
		break;

		case CTpid:
		ff(se,": xmtr %d, rcvr: %d, parent: %d, group: %d\r\n",
			xmtr_pid,rcvr_pid,shm->xmtr_ppid,shm->xmtr_pgrp);
		break;

		case CTpwd:
		ff(se," %s\r\n",curr_dir);
		break;

		case CTredial:
		(void)DCE_redial(arg,narg);
		break;

		case CTrev:
		fputs("\r\n",se);
		fputs(hello_str,se);
		fputs("\r\n",se);
		ff(se,"%s\r\n",makedate);
#if defined(MEMCHECK)
		_dump_malloc();
#endif
		break;

		case CTtime:
		get_tod(4,cmd);
		ff(se,": %s\r\n",cmd);
		break;

		case CTdcdwatch:
		if(narg > 1)
		{
			if(ldcdwatch_str(arg[1]))
				ff(se," ... argument error; remains set to ");
			else
				ff(se," ... set to ");
		}
		else
			ff(se," is ");
		cptr = "???";
		switch(shm->Ldcdwatch)
		{
			case DCDW_OFF:			cptr = "off"; break;
			case DCDW_ON:			cptr = "on"; break;
			case DCDW_TERMINATE:	cptr = "TERMINATE"; break;
		}
		ff(se,"%s\r\n",cptr);
		break;

		case CTts:
		ff(se,"\r\n");
		sprintf(s80,"TTYIN %s (ttymode=%d)",get_ttyname(),current_ttymode);
		disp_line_termio(TTYIN,s80);
		ff(se,"\r\n");
		sprintf(s80,"comm line %s",shm->Lline);
		disp_line_termio(shm->Liofd,s80);
#ifdef sun
		ioctl(shm->Liofd,TIOCMGET,(char *)&modem_lines);
		ff(se,"Current modem signals:   RTS:%c   CTS:%c   DCD:%c\r\n",
			(modem_lines & TIOCM_RTS) ? '1' : '0',
			(modem_lines & TIOCM_CTS) ? '1' : '0',
			(modem_lines & TIOCM_CD)  ? '1' : '0');
#endif
		break;

#if	defined(FASI)
		case CTfasi:
		icmd_fasi(narg,arg);
		break;
#endif
		case CTtty:
		ff(se,"   %s\r\n",get_ttyname());
		break;

		case CTda:
		case CToa:
		case CTxa:
		case CTax:
		icmd_conversion(token,narg,arg);
		break;

		case CTbn:
		if(narg < 2)
			ff(se,"  is ");
		else
		{
			if((itmp = parse_bell_notify_argument(arg[1])) < 0)
				ff(se,"\r\nbad argument (try help bn); remains set to ");
			else
			{
				shm->bell_notify_state = itmp;
				ff(se,"  set to ");
			}
		}
		ff(se,"%s\r\n",bell_notify_text(shm->bell_notify_state));
		break;

		case CTrtscts:
#if defined(HW_FLOW_CONTROL) /* see ecu.h */
		if(narg > 1)
		{
			lRTSCTS_control(yes_or_no(arg[1]));
			pputs("\nNew c");
		}
		else
			pputs("\nC");
		pputs("onfiguration:  ");
		display_hw_flow_config();
#else /* !HW_FLOW_CONTROL */
		ff(se,"\r\nhardware flow control not available\r\n");
#endif /* HW_FLOW_CONTROL */
		break;

		case CTeto:
		if(narg > 1)
		{
			itmp = atoi(arg[1]);
			if((itmp < 20) || (itmp > 1000))
			{
				ff(se," invalid\r\n");
			}
			tty_escape_timeout = (long)itmp;
			ff(se," set to");
		}
		ff(se," %ld msec\r\n",tty_escape_timeout);
		break;

		case CTnice:
		itmp = nice(0) + 20;
		if(narg > 1)
		{
			kill_rcvr_process(SIGUSR1);
			itmp2 = atoi(arg[1]);
			itmp3 = nice(-itmp + itmp2);
			ff(se," -> desired=%d, was %d, ",itmp2,itmp);
			if(itmp3 < 0)
				ff(se,"nice failed: %s\r\n",errno_text(errno));
			else
				ff(se,"set to %d\r\n",itmp3);
			start_rcvr_process(0);
		}
		else
			ff(se," is %d\r\n",itmp);
		break;

		case CTfkey:
		if(narg < 2)
			keyset_display();
		else if(!strcmp(arg[1],"-r"))
		{
			keyset_init();
			keyset_read("default");
			ff(se,"  keyboard reset done ...\r\n");
		}
		else
		{
			switch(keyset_read(arg[1]))
			{
				case  0: keyset_display(); break;
				case -1: ff(se," cannot find ~/.ecu/keys\r\n"); break;
				case -2: ff(se," not found in ~/.ecu/keys\r\n"); break;
				case -3: ff(se," syntax error ... default restored\r\n");
				default:
					keyset_init();
					keyset_read("default");
					break; 
			}
		}
		break;

		case CTfkmap:
		ff(se,"\r\n");
		fkmap_command(narg,arg);
		break;

		case CTstat:
		get_tod(4,s80);
		ff(se,"\r\nDate: %s\r\n",s80);

		ff(se,"Communications line: %s %u-%c-1  ",
			shm->Lline, shm->Lbaud,
			(shm->Lparity) ? to_upper(shm->Lparity) : 'N');

		lget_xon_xoff(&itmp2,&itmp3);
		ff(se,"XON/XOFF input %s output %s\r\n",
			(itmp2) ? "on" : "off",		/* IXON */
			(itmp3) ? "on" : "off");	/* IXOFF */
		
#if defined(HW_FLOW_CONTROL) /* see ecu.h */
		ff(se,"Hardware flow control configuration: ");
		display_hw_flow_config();
#else
		ff(se,"no hardware flow control available\r\n");
#endif

		if(!shm->Lconnected)
			ff(se,"Not connected to a remote\r\n");
		else
		{
			ff(se,"Connected to %s: %s (%s)\r\n",
				shm->Lrname,shm->Ldescr,shm->Ltelno);
			ff(se,"at %s (elapsed %s)\r\n",
				epoch_secs_to_str(shm->Loff_hook_time,1,s80),
				get_elapsed_time(time((long *)0) - shm->Loff_hook_time));
		}

		ff(se,"Duplex: %s  ",(shm->Lfull_duplex) ? "full" : "half");
		cptr = "???";
		switch(shm->Ldcdwatch)
		{
			case DCDW_OFF:			cptr = "off"; break;
			case DCDW_ON:			cptr = "on"; break;
			case DCDW_TERMINATE:	cptr = "TERMINATE"; break;
		}
		ff(se,"DCD watcher: %s\r\n",cptr);

		ff(se,"Console: %s %dx%d ",get_ttyname(),tcap_COLS,tcap_LINES);
		if(tty_is_multiscreen)
			ff(se,"<multiscreen> ");
		if(tty_is_scoterm)
			ff(se,"<scoterm> ");
		if(tty_is_pty)
			ff(se,"<pty> ");
		if(kbd_is_7bit)
			ff(se,"<7-bit kbd> ");
		fputs(console_xon_status(),se);
		ff(se,"\r\n");

#if defined(USE_ECUUNGETTY)
		display_ungetty_list();
#endif
		ff(se,"Current directory: %s\r\n",curr_dir);
		ff(se,"Total chars transmitted: %ld",shm->xmit_chars);
		if(shm->Lconnected)
			ff(se," (since CONNECT %ld)\r\n",
				shm->xmit_chars_this_connect);
		else
			fputs("\r\n",se);
		ff(se,"Total chars received:    %ld",shm->rcvd_chars);
		if(shm->Lconnected)
			ff(se," (since CONNECT %ld)\r\n",shm->rcvd_chars_this_connect);
		else
			fputs("\r\n",se);

		if(keyset_name[0])
			ff(se,"Function key set '%s' loaded\r\n",keyset_name);
		else
			ff(se,"No function key set loaded\r\n");

		if(rcvr_log)
		{
			ff(se,"Session log open: %s (%s mode)\r\n",
				rcvr_log_file,(rcvr_log_raw) ? "raw" : "filtered");
		}
		else
			ff(se,"Session logging not active\r\n");

		ff(se,"Bell notify is %s\r\n",
			bell_notify_text(shm->bell_notify_state));

		ff(se,"CR conversion:  incoming %s  outgoing %s\r\n",
			(shm->Ladd_nl_incoming) ? "CR/LF" : "CR",
			(shm->Ladd_nl_outgoing) ? "CR/LF" : "CR");

		ff(se,"Keyboard ESC/funckey time constant = %ld msec\r\n",
			tty_escape_timeout);

		ff(se,"Pids: xmtr=%d rcvr=%d parent=%d pgrp=%d\r\n",
			xmtr_pid,
			rcvr_pid,
			shm->xmtr_pgrp,
			shm->xmtr_ppid);
		fputs("\r\n",se);
		break;

		case CTxon:
		if(narg > 1)
		{
			if(set_xon_xoff_by_arg(arg[1]))
				ff(se,"  argument error\r\n");
			else
				ff(se,"\r\n");
			break;
		}
		ff(se,"  xon/xoff flow control: %s\r\n",xon_status());
		break;

		case CTconxon:
		if(narg > 1)
		{
			if(set_console_xon_xoff_by_arg(arg[1]))
				ff(se,"  argument error\r\n");
			else
				ff(se,"\r\n");
			break;
		}
		ff(se,"\r\nconsole xon/xoff flow control: %s\r\n",console_xon_status());
		break;

		case CTsgr:
		send_get_response(narg,arg);
		break;

/*
		case CTmkdir:
		if(narg < 2)
			ff(se,"  no argument\r\n");
		if(mkdir(arg[2],0755))
		{
			ff(se,"  ");
			pperror(arg[2]);
		}
		else
			ff(se,"  made directory %s\r\n",arg[2]);
		break;
*/

		case CTmemstat:
#if defined(MALLOC_3X)
	{
		struct mallinfo minfo;
		extern char *startbrk;
		extern char *startsp;
		char *sbrk();
		minfo = mallinfo();
		pputs("\n"); /* all this casting for 16- vs 32- bit ints */
		pprintf("%10lu total space in arena\n",(ulong)minfo.arena);
		pprintf("%10lu number of ordinary blocks\n",(ulong)minfo.ordblks);
		pprintf("%10lu number of small blocks\n",(ulong)minfo.smblks);
		pprintf("%10lu number of holding blocks\n",(ulong)minfo.hblks);
		pprintf("%10lu space in holding block headers\n",(ulong)minfo.hblkhd);
		pprintf("%10lu space in small blocks in use\n",(ulong)minfo.usmblks);
		pprintf("%10lu space in free small blocks\n",(ulong)minfo.fsmblks);
		pprintf("%10lu space in ordinary blocks in use\n",
			(ulong)minfo.uordblks);
		pprintf("%10lu space in free ordinary blocks\n",(ulong)minfo.fordblks);
		pprintf("%10lu cost of enabling keep option\n",(ulong)minfo.keepcost);
		pprintf("  %08lx startbrk\n",startbrk);
		pprintf("  %08lx sbrk(0)  ",sbrk(0));
		pprintf("  (break delta %10ld)\n",sbrk(0) - startbrk);
		pprintf("  %08lx startsp\n",startsp);
		pprintf("  %08lx sp       ",&minfo);
		pprintf("  (stack size  %10ld)\n",(long)(startsp - (char *)&minfo));
	}
#else
		ff(se,"  not available\r\n");
#endif
		break;

		case CTkbdtest:
		ff(se,"\r\n");
		kbd_test();
		break;

		case 0:
		ff(se,"   procedure command not allowed in interactive mode\r\n");
		break;

		default:
		do_proc(narg,arg);
		sigint = 0;
		break;

	}
	return(0);		/* 0 == do not end program */

}	/* end of icmd */

/* end of ecuicmd.c */
/* vi: set tabstop=4 shiftwidth=4: */
