/*+-----------------------------------------------------------------------
	ecu.h -- TuckerWare Extended Calling Unit
	wht@n4hgf.Mt-Park.GA.US
------------------------------------------------------------------------*/
/*+:EDITS:*/
/*:09-13-1992-12:52-wht@n4hgf-add tty_is_scoterm */
/*:09-10-1992-13:58-wht@n4hgf-ECU release 3.20 */
/*:08-22-1992-15:38-wht@n4hgf-ECU release 3.20 BETA */
/*:08-21-1992-13:39-wht@n4hgf-rewire direct/modem device use */
/*:07-21-1992-12:09-wht@n4hgf-3.2v4 only has sys/time.h if TCPRT installed */
/*:04-17-1992-20:10-wht@gyro-default tty, baud and parity moved to config.c */
/*:03-27-1992-16:21-wht@n4hgf-re-include protection for all .h files */
/*:02-13-1992-06:35-wht@n4hgf-when port to many time() can be int/long/time_t */
/*:11-30-1991-13:46-wht@n4hgf-smap conditional compilation reorg */
/*:11-26-1991-20:17-wht@n4hgf-add shm->Ldcdwatch values */
/*:11-26-1991-19:37-wht@n4hgf-add STR_CLASSIFY */
/*:11-13-1991-16:29-wht@n4hgf-use if __STDC__ instead of defined(__STDC__) */
/*:11-11-1991-22:45-wht@n4hgf-redefinition of Ltermio's place in life */
/*:08-25-1991-14:39-wht@n4hgf-SVR4 port thanks to aega84!lh */
/*:08-13-1991-13:53-wht@n4hgf-UNIX and ISC nap() broken; XENIX still wins */
/*:08-09-1991-11:07-wht@n4hgf-configurable lock directory */
/*:07-25-1991-12:55-wht@n4hgf-ECU release 3.10 */
/*:01-25-1991-06:08-wht@n4hgf-mulltiple #define of ECULIBDIR */
/*:01-22-1991-14:33-wht@n4hgf-XENIX calloc/memmove fix */
/*:01-01-1991-21:36-wht@n4hgf-add GCC implies STDC */
/*:08-14-1990-20:39-wht@n4hgf-ecu3.00-flush old edit history */

#ifndef _ecu_h
#define _ecu_h

/*
 * damn ANSI dweebs
 */
#if defined(__sun__) && !defined(sun)
#define sun 1
#endif
#if defined(__i386__) && !defined(i386)
#define i386 1
#endif
#if defined(__SVR4__) && !defined(SVR4)
#define SVR4 1
#endif

/*
 * some gcc's don't know about i386
 */
#if (defined(M_I386) || defined(ISC) /* || defined(MYSYS) */)  && !defined(i386)
#define i386 /* needed by setjmp.h on 386 unix r3 */
#endif

#if !defined(STDIO_H_INCLUDED)
#include <stdio.h>
#endif

#include <signal.h>
#include <ctype.h>
#include <errno.h>
#include <string.h>
#include <memory.h>
#include <fcntl.h>
#include "ecu_types.h"
#include "ecu_stat.h"
#include <sys/timeb.h>

#if defined(WORKING_SELECT)
/* SCO pre 3.2v4 */
#if defined(M_XENIX) || defined(M_UNIX)
# include <sys/select.h>
#else
# include <sys/time.h>
#endif
#endif

/*
 * if building prototypes with SCO cc sometimes buggy -Zg * or using lint
 */
#if defined(BUILDING_PROTOTYPES) || defined(lint)
#define ECULIBDIR "dummy"
#define HDBLIBDIR "dummy"
#define LOCK_DIR_NAME "dummy"
#define DEFAULT_TTY "/dev/tty1"
#define DEFAULT_BAUD_RATE 2400
#define DEFAULT_PARITY 'n'
#endif

/*
 * streams tty stuff is so similar to traditional that
 * this hack worked for porting to the sun and left the tty code
 * clean .... this hack will most certainly break down one day
 */
#if !defined(OMIT_TERMIO_REFERENCES)
#if defined(sun) || defined(USE_TERMIOS)
#include <termio.h>		/* may need to be termios.h on other than sun */
#define termio termios
#undef TCGETA
#undef TCSETA
#undef TCSETAW
#define TCGETA	TCGETS
#define TCSETA	TCSETS
#define TCSETAW	TCSETSW
#else
#include <termio.h>
#endif /* sun */
#endif /* OMIT_TERMIO_REFERENCES */

/*
 * The various flavors of hardware flow control, most of them 
 * flakey or incomplete
 */
#if defined(RTSFLOW) && !defined(HW_FLOW_CONTROL)
#define HW_FLOW_CONTROL
#endif
#if defined(CRTSFL) && !defined(HW_FLOW_CONTROL)  /* 3.2v4 */
#define HW_FLOW_CONTROL
#endif
#if defined(RTSXOFF) && !defined(HW_FLOW_CONTROL) /* SVR4 */
#define HW_FLOW_CONTROL
#endif
#if defined(CRTSCTS) && !defined(HW_FLOW_CONTROL) /* sun */
#define HW_FLOW_CONTROL
#endif

#if defined(M_UNIX) && !defined(GNUC) && !defined(__GNUC__)
/* some MSC intrinsics produce bad inline code with certain usages */
#pragma intrinsic(memcpy)	/* trust these intrinsics ... */
#pragma intrinsic(memset)	/* ... because we know how we use them */
#endif

/*
 * Some ANSI pacifiers typedef time_t to int, some to long.
 * int is 'wrong', but on a 32-bit machine who cares?  On the 286
 * it matters.  The following compromise should allow time() to work
 * everywhere since only 286 we support is SCO XENIX/286.  Folks
 * on 386 with small model with 16-bit ints (like Coherent) will
 * get caught here, but I believe there will be larger snags as well.
 */
#ifdef M_I286
long time();
#endif

long Nap();

typedef int  (*PFV)();	/* pointer to function returning void */
typedef char (*PFC)();	/* pointer to function returning char */
typedef int  (*PFI)();	/* pointer to function returning integer */
typedef long (*PFL)();	/* pointer to function returning long */


/* already in ecushm.h */
/* #if !defined(ushort) */
/* #define ushort unsigned short */
/* #endif */
/* #if !defined(uchar) */
/* #define uchar unsigned char */
/* #endif */
/* #if !defined(uint) */
/* #define uint unsigned int */
/* #endif */
/* #if !defined(ulong) */
/* #define ulong unsigned long */
/* #endif */

#if __STDC__	/* sigh ... malloc and such types; SIGTYPE just a guess*/
#define VTYPE void
#define VOLATILE volatile
#ifndef SIGTYPE
#define SIGTYPE void
#endif
#else
#define VTYPE char
#define VOLATILE
#ifndef SIGTYPE
#define SIGTYPE int
#endif
#endif

#include "smap.h"
#if defined(MALLOC_3X)
#include <malloc.h>
#else
VTYPE *malloc();
VTYPE *calloc();
VTYPE *realloc();
#endif

/*
 * this must come after any system header inclusion
 */
#if defined(M_UNIX)
#undef M_XENIX		/* now can truly distinquish between SCO XENIX and UNIX */
#endif /* M_UNIX */

#include "ecushm.h"
#include "termecu.h"
#include "ttynaming.h"

/*
 * for better source line utilization, frequent use of
 * fprintf and stderr warrants the following
 */
#define pf	printf
#define ff	fprintf
#define se	stderr
#define so	stdout

/*
 * console tty information
 */
extern int tty_is_multiscreen;		/* SCO multiscreen */
extern int tty_is_scoterm;			/* SCO scoterm */
extern int tty_is_pty;				/* bursty network connection? */
extern int tty_not_char_special;	/* /dev/null not considered char special */

/*
 * useful macros
 */
#define max(a,b) ((a > b) ? a : b)
#define min(a,b) ((a < b) ? a : b)

/*
 * decide how to write to logfile
 */
#define LOGPUTC fputc	/* fputc() or putc() */

#define TTYIN	0
#define TTYOUT  1				/* ditto tty output */
#define TTYERR  2				/* ditty tty output error channel */

/*
 * xbell codes (see ecuxenix.c)
 */
enum xbell
{
	XBELL_DONE = 1,		/* octaves or morse 'd' */
	XBELL_ATTENTION,	/* morse .-.-.- ATTENTION */
	XBELL_C,			/* morse -.-. C */
	XBELL_3T				/* 3 Ts --- really 'o' */
};

/*
 * lopen() and related routines error codes
 */
enum linst
{
	LINST_INVALID = -50,	/* for invalid tty name */
	LINST_UNKPID,			/* unknown pid using line */
	LINST_LCKERR,			/* lock file open error */
	LINST_NODEV,			/* device does not exist */
	LINST_OPNFAIL,			/* could not access line */
	LINST_ALREADY,			/* line already open */
	LINST_ENABLED,			/* line enabled for login */
	LINST_ENABLED_IN_USE,	/* line in use by incoming login */
	LINST_DIALOUT_IN_USE,	/* line in use by another dial out */
	LINST_NOPTY,			/* pty not supported */
	LINST_WEGOTIT,			/* not really an error: we already
							 * own the line (used by check_utmp())
							 */
	LINST_ECUUNGETTY,		/* ecuungetty unexpected response */
	LINST_ECUUNGETTY2,		/* ecuungetty execution error */
	LINST_NOTCHR			/* not a character special */
};

/*
 * filename sizes
 */
#define CURR_DIRSIZ 256			/* current directory array size */
#define PHONEDIR_NAME_SIZE 256	/* phone directory */

/*
 * in case errno.h doesn't pick this up
 */
extern int errno;
extern char *sys_errlist[];
extern int sys_nerr;
char *errno_text();		/* see ecuutil.c */

char *getenv();

/*
 * process IDs
 */
extern PID_T rcvr_pid;
extern PID_T xmtr_pid;

/*
 * both of the following are set by xmtr_SIGINT_handler()
 * 'sigint' reset by 1st detector/processor
 * 'proc_interrupt' reset/handled by procedure monitor
 *                  (execute_esd and execute_proc)
 */
extern int sigint;
/* extern int proc_interrupt; <------ force using modules to declare it */

/*
 * procedure nesting level
 * non-zero if procedure executing (see proc.c)
 */
extern int proc_level;
extern int proctrace;

/*
 * need_rcvr_restart() - check rcvr status
 *
 * If rcvr_pid == -2, queued restart has been requested by some function
 * but we don't want to do it if a procedure is executing
 */
#define need_rcvr_restart() \
	((rcvr_pid > 0) || ((rcvr_pid == -2) && !proc_level))

/*
 * 'hz' is getenv("HZ"); that not found, the value from sys/param.h
 * 'hzmsec' is ceiling(clock period) in milliseconds
 */
extern int hz;				/* HZ from environ or sys/param.h */
extern ulong hzmsec;		/* clock period in msec rounded up */

/*
 * Communication line variables that are not in shared memory
 *
 * One special note: Ltermio points to a buffer in shared memory
 * used to hold the line's current termio structure.  The shared
 * memory buffer is defined as a simple array of longs so that
 * friend code need not include termio.h if it does not need it.
 * What's more, due to sgtty-based curses code, XENIX versions
 * cannot include termio.h in some modules.  ecushm.c has runtime
 * code to initialize Ltermio to point to shm->Ltiobuf and to
 * make sure shm->Ltiobuf is long enough. This is a hack of
 */
#if defined(DECLARE_LINEVARS_PUBLIC)
#if !defined(OMIT_TERMIO_REFERENCES)
struct termio *Ltermio;		/* attributes for the line to remote */
#endif
uchar Ldial_debug_level;
#else
#if !defined(OMIT_TERMIO_REFERENCES)
extern struct termio *Ltermio;
#endif
extern uchar Ldial_debug_level;
#endif

extern int zero_length_read_detected;	/* see lgetc_xmtr in eculine.c */

/*
 * lock file directory
 */
extern char *lock_dir_name;	/* defined in ecuLCK.c */

/*
 * setcolor variables - see setcolor()
 */
extern ulong colors_current;
extern ulong colors_normal;
extern ulong colors_success;
extern ulong colors_alert;
extern ulong colors_error;
extern ulong colors_notify;

/*
 * miscellaneuous
 */
extern char *eculibdir;		/* lib dir, i.e., "/usr/local/lib/ecu" */
extern char *ttype;			/* getenv("TERM") */

/*
 * param to lgets_timeout in eculine.c
 */
typedef struct lrwt
{
	ulong to1;		/* timeout for 1st character (granularity 20) */
	ulong to2;		/* timeout for each next char (granularity 20) */
	int raw_flag;	/* !=0, rtn full buffer, ==0, rtn filtered hayes result */
	char *buffer;	/* buffer to fill */
	int bufsize;	/* size of buffer */
	int count;		/* from proc, count rcvd */
	char *delim;	/* ending string for lgets_timeout_or_delim */
	int echo_flag;	/* echo incoming chars to screen */
}	LRWT;

/*
 * parameter structure for str_classify()
 */
typedef struct str_classify
{
	char *str;		/* string to match */
	int min_ch;		/* minimum characters required */
	int token;		/* token for match */
} STR_CLASSIFY;

/*
 * shm->Ldcdwatch values
 */
#define DCDW_OFF		0
#define DCDW_ON			1
#define DCDW_TERMINATE	2

#ifdef DEBUG_SRP
#define start_rcvr_process(flag) _start_rcvr_process(flag,__FILE__,__LINE__)
#else
#define start_rcvr_process(flag) _start_rcvr_process(flag)
#endif

/*
 * prototyes or external declarations
 *
 * "I took a silver needle [ANSI] and I put it into my arm.
 * It did some good. It did some harm.  But the nights were
 * cold and lonely and it almost kept me warm."
 * -- Leonard Cohen, _Songs from a Room_
 *
 */
#ifdef USE_PROTOS
# include "protos.h"
#endif

#ifdef XECU
# include "xecu.h"
#endif

#endif /* _ecu_h */

/* vi: set tabstop=4 shiftwidth=4: */
/* end of ecu.h */
