#ifndef H_VERSION
#define H_VERSION
/*
 * version.h
 *
 * Program version...
 * (moved from xfer.h)
 *
 * I've put it in its own file to avoid having to recompile everything
 * when changing the version name.
 */

/*
 * Editable bits
 */

#define BINK_MAJVERSION 	3					/* Major Update */
#define BINK_MINVERSION 	02					/* Minor Update */
#ifdef unix
#define BINK_RELEASE        "aPL10"				/* Bugfix Update incl. unix patchlevel */
#else
#define BINK_RELEASE        "a"					/* Bugfix Update */
#endif
#define BINK_DEBUGVERSION	"beta-6/Zdebug"		/* Beta-Test version */

#ifdef NeXT
#define _MAILER_NAME 		"BinkleyTerm-NeXT"	/* Program name */
#define _MAILER_VER 		"3.02"				/* version in ascii format */
#define _MAILER_SHORTNAME	"Bink-NeXT"			/* Short name of program */
#else
#ifdef unix
#define _MAILER_NAME 		"BinkleyTerm-Unix"	/* Program name */
#define _MAILER_VER 		"3.02"				/* version in ascii format */
#define _MAILER_SHORTNAME	"Bink-Unix"			/* Short name of program */
#else
#define _MAILER_NAME 		"BinkleyTerm-ST"	/* Program name */
#define _MAILER_VER 		"3.02"				/* version in ascii format */
#define _MAILER_SHORTNAME	"Bink-ST"			/* Short name of program */
#endif
#endif

/* 
 * Work out what kind of compiler we are using
 */

#if defined(__PUREC__)
#define COMPILER "PureC"
#elif defined(__TURBOC__)
#define COMPILER "TurboC"
#elif defined(__GCC__)
#define COMPILER "gcc"
#elif defined(unix)
#define COMPILER "cc"
#else                        
#define COMPILER "Lattice"
#endif

/*
 * Make up the Mailer serial number
 */

#ifdef DEBUG
#define _MAILER_SER BINK_RELEASE "<" BINK_DEBUGVERSION "," COMPILER ",Debug>"
#else
#define _MAILER_SER BINK_RELEASE 	/* "/" COMPILER */
#endif


#endif	/* H_VERSION */
