/*
 * com_unix.h
 *
 * unix version of com_dos.h and com_os2.h
 *
 * This emulates some of the Fossil functions
 * Refer to FSC-0015.CHT and FSC-0015.DOC
 * Also included some other functions which were missing
 */

#ifdef USG
#include <termios.h>
#else
#include <sys/ttydev.h>
#endif

#ifndef BOOLEAN
typedef int         BOOLEAN;
#endif

extern unsigned int st_lock_baud;
extern unsigned int comm_bits;
extern unsigned int parity;
extern unsigned int stop_bits;
extern int unix_line;
extern char *ttynames[];
extern char *dialupnames[];

#define BITS_7			0x20
#define BITS_8			0x00

#define STOP_1			0x08
#define STOP_2			0x18

#define ODD_PARITY		0x06
#define EVEN_PARITY 		0x04
#define NO_PARITY		0x00

#define BAUD_300		B300	/* These are the ioctl parameters */
#define BAUD_1200		B1200
#define BAUD_2400		B2400
#define BAUD_4800		B4800
#define BAUD_9600		B9600
#define BAUD_19200		EXTA
#define BAUD_38400		EXTB

#define USE_XON			0x01	/* OR these for both */
#define USE_CTS			0x02

#define BRK 			0x01
#define MDM 			0x02

/* Status return values */

#define DATA_READY		0x0100
#define OVERRUN_ERR		0x0200
#define PARITY_ERR		0x0400
#define FRAMING_ERR		0x0800
#define BREAK_INT		0x1000
#define TX_HOLD_EMPTY		0x2000
#define TX_SHIFT_EMPTY		0x4000

/* waitevent set/return values */
#define SEL_NOTHING 0
#define SEL_MODEM   1
#define SEL_CONSOLE 2
#define SEL_TIME    4

int wait_event(int, int);

#define GENERIC			/* Keep Zmodem happy with 68000 ordering */

/* The fossil routines */

 /*-----------------------------------------------*/
 /* Service 0: SET BAUD(etc)                      */
 /*-----------------------------------------------*/

void 
MDM_ENABLE(unsigned baud);

 /*-----------------------------------------------*/
 /* Service 1: SEND CHAR (wait)                   */
 /*-----------------------------------------------*/

void 
SENDBYTE(unsigned char);

 /*-----------------------------------------------*/
 /* Service 2: GET CHAR (wait)                    */
 /*-----------------------------------------------*/

int MODEM_IN(void);

 /*-----------------------------------------------*/
 /* Service 3: GET STATUS                         */
 /*-----------------------------------------------*/

long 
get_dcd(void);

#define CARRIER 		((BOOLEAN) get_dcd())
BOOLEAN CHAR_AVAIL(void);
BOOLEAN OUT_FULL(void);
BOOLEAN OUT_EMPTY(void);

 /*-----------------------------------------------*/
 /* Service 4: INIT/INSTALL                       */
 /*-----------------------------------------------*/

int 
Cominit(int);

 /*-----------------------------------------------*/
 /* Service 5: UNINSTALL                          */
 /*-----------------------------------------------*/

void 
MDM_DISABLE(void);

 /*-----------------------------------------------*/
 /* Service 6: SET DTR                            */
 /*-----------------------------------------------*/


void DTR_ON(void);
void DTR_OFF(void);

 /*-----------------------------------------------*/
 /* Service 9: NUKE OUTBOUND RING-BUFFER          */
 /*-----------------------------------------------*/

void 
CLEAR_OUTBOUND(void);

 /*-----------------------------------------------*/
 /* Service a: NUKE INBOUND RING-BUFFER           */
 /*-----------------------------------------------*/

void 
CLEAR_INBOUND(void);

 /*-----------------------------------------------*/
 /* Service b: SEND CHAR (no wait)                */
 /*-----------------------------------------------*/

BOOLEAN 
Com_Tx_NW(unsigned char);

 /*-----------------------------------------------*/
 /* Service c: GET CHAR (no wait)                 */
 /*-----------------------------------------------*/
int 
PEEKBYTE(void);

 /*-----------------------------------------------*/
 /* Service d: GET KEYBOARD STATUS                */
 /*-----------------------------------------------*/

BOOLEAN KEYPRESS(void);

 /*-----------------------------------------------*/
 /* Service e: GET KEYBOARD CHARACTER (wait)      */
 /*-----------------------------------------------*/

int 
getkey(void);

#define READKB()	getkey()
#define FOSSIL_CHAR()   getkey()


 /*-----------------------------------------------*/
 /* Service f: SET/GET FLOW CONTROL STATUS        */
 /*-----------------------------------------------*/

void XON_ENABLE(void);
void XON_DISABLE(void);
void IN_XON_ENABLE(void);

 /*-----------------------------------------------*/
 /* Service 10: SET/GET CTL-BREAK CONTROLS        */
 /* Note that the "break" here refers */
 /* to ^C and ^K rather than the      */
 /* tradition modem BREAK.            */
 /*-----------------------------------------------*/

#define _BRK_ENABLE()   ((void)0)	/* Null function */
#define _BRK_DISABLE()  ((void)0)	/* Null function */
#define RECVD_BREAK()	0

 /*-----------------------------------------------*/
 /* Service 13: WRITE LOCAL ANSI CHARACTER        */
 /*-----------------------------------------------*/

void WRITE_ANSI(int);	/* Actually its V100 */

/*
 * Other miscellaneous Comms functions
 */

void 
SENDCHARS(unsigned char *buf, size_t size, BOOLEAN carcheck);

int 
real_flush(int);		/* Flush the file */

void 
do_break(int);			/* Send break signal */

void 
BUFFER_BYTE(unsigned char);

void 
UNBUFFER_BYTES(void);

/* misc functions */

void dostime(int *hour, int *min, int *sec, int *hdths);
void dosdate(int *month, int *mday, int *year, int *weekday);
int real_flush(int f);		/* Flush the file */
size_t filelength(int handle);
int strnicmp( const char *, const char *, size_t);
int stricmp( const char *, const char *);
char *strupr(char *s);
char *strlwr(char *s);
#ifndef USG
void putenv(char *str);
#endif
#ifndef Sony /* already here */
void tzset(void);
#endif
char *strdup(const char *);
char *ultoa (unsigned long value, char * string, int radix);
int wait_event(int event, int time);
