/*
 *                            COPYRIGHT
 *
 *  PCB, interactive printed circuit board design
 *  Copyright (C) 1994,1995 Thomas Nau
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Contact addresses for paper mail and Email:
 *  Thomas Nau, Schlehenweg 15, 88471 Baustetten, Germany
 *  Thomas.Nau@rz.uni-ulm.de
 *
 */

static	char	*rcsid = "$Header$";

/* functions used to change the mirror flag of an object
 */

#include <stdlib.h>

#include "global.h"

#include "data.h"
#include "draw.h"
#include "mirror.h"
#include "search.h"
#include "select.h"
#include "set.h"

/* ---------------------------------------------------------------------------
 * some local prototypes
 */
static	void	*MirrorText(LayerTypePtr, TextTypePtr);
static	void	*MirrorElementName(ElementTypePtr);

/* ---------------------------------------------------------------------------
 * some local identifiers
 */
static	ObjectFunctionType	MirrorFunctions = {
	NULL,
	MirrorText,
	NULL,
	NULL,
	NULL,
	MirrorElementName,
	NULL,
	NULL };

/* ---------------------------------------------------------------------------
 * changes the mirror flag of a text object
 */
static void *MirrorText(LayerTypePtr Layer, TextTypePtr Text)
{
	EraseText(Text);
	MIRROR(Text);
	DrawText(Layer, Text);
	return(Text);
}

/* ---------------------------------------------------------------------------
 * changes the mirror flag of a text object
 */
static void *MirrorElementName(ElementTypePtr Element)
{
	EraseElementName(Element);
	MIRROR(&CANONICAL_TEXT(Element));
	MIRROR(&NAMEONPCB_TEXT(Element));
	DrawElementName(Element);
	return(Element);
}

/* ---------------------------------------------------------------------------
 * changes the objects mirror flag of the one at the current cursor location.
 * The passed ID can match more than one type but only one object is changed
 */
void MirrorObject(int Type, void *Ptr1, void *Ptr2)
{
	ObjectOperation(&MirrorFunctions, Type, Ptr1, Ptr2);
}
