static char *SccsId = "@(#)dmimlst.c 3.10 (TU-Delft) 04/28/93";
/**********************************************************

Name/Version      : The Design Data Management Project

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000/S500

Author(s)         : S. de Graaf
                    A. van der Hoeven
                    T.G.R. van Leuken
                    N. van der Meijs
		    T. Vogel
		    P. van der Wolf
Creation date     : 04-Dec-1986
Modified by       : S. de Graaf
Modification date : 17-Dec-1987


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1985-1987 , All rights reserved
**********************************************************/
#include "dmstd.h"

IMPCELL ** _dmImportedCelllist (dmproject, view)
DM_PROJECT * dmproject;
char   *view;
{
    register IMPCELL **iclp;
    FILE    *fp;
    IMPCELL *impcell[DM_MAXCELLS + 1];
    char    buf[3][MAXLINE];
    char    path[MAXLINE];
    int	    view_entry;
    register int i;

    if ((view_entry = _dmValidView (view)) == -1) {
	return (NULL);
    }

    if (_dmCh_project (dmproject) != 0) {
	dmError ("project key");
	return (NULL);
    }

    if ((iclp = dmproject -> impcelllist[view_entry]) != NULL) {
	/* a (possibly inconsistent) impcelllist is already present: free it */
        while (*iclp != NULL) {
	    _dmStrFree ((*iclp) -> cellname);
	    _dmStrFree ((*iclp) -> alias);
	    _dmStrFree ((*iclp) -> dmpath);
	    dmFree (*iclp++, sizeof(IMPCELL));
        }
        dmFree (dmproject -> impcelllist[view_entry], DM_UNKNOWN_SIZE);
    	dmproject -> impcelllist[view_entry] = NULL;
    }

#ifdef MSDOS
    _dmSprintf (path, "%s/%s/impclist", dmproject -> dmpath, view);
#else
    _dmSprintf (path, "%s/%s/impcelllist", dmproject -> dmpath, view);
#endif

    if (!(fp = fopen (path, "r"))) {
	dmerrno = DME_NOIMPCL;
	dmError ("_dmImportedCelllist");
	return (NULL);
    }

    i = 0;

    /* format: alias, cellname, project-path */
    while (fscanf (fp, "%s%s%s", buf[0], buf[1], buf[2]) != EOF) {
	impcell[i] = (IMPCELL *) malloc (sizeof (IMPCELL));
	impcell[i] -> alias    = _dmStrSave (buf[0]);
	impcell[i] -> cellname = _dmStrSave (buf[1]);
	impcell[i] -> dmpath   = _dmStrSave (dmSubstituteEnvironmentVars(buf[2]));
	if (++i > DM_MAXCELLS)
	    _dmFatal ("_dmImportedCelllist: too many imported cells", "", "");
    }
    impcell[i] = NULL;
    fclose (fp);

    /* The imported celllist that has been obtained must be saved. */
    if ((iclp = (IMPCELL **)
	    malloc ((unsigned)((i + 1) * sizeof (IMPCELL *)))) == NULL) {
	dmerrno = DME_CORE;
	dmError ("_dmImportedCelllist");
	return (NULL);
    }

    dmproject -> impcelllist[view_entry] = iclp;

    for (i = 0;;) {
	if ((*iclp++ = impcell[i++]) == NULL) break;
    }

#ifdef DM_DEBUG
    IFDEBUG {
	fprintf (stderr, "_dmImportedCelllist: ");
	iclp = dmproject -> impcelllist[view_entry];
	for (; *iclp != NULL; ++iclp) {
	    fprintf (stderr, "%s %s %s\n",
		(*iclp) -> alias, (*iclp) -> cellname, (*iclp) -> dmpath);
	}
    }
#endif /* DM_DEBUG */

    return (dmproject -> impcelllist[view_entry]);
}
