static char *SccsId = "@(#)prHead.c 4.4 (TU-Delft) 06/26/92";
/**********************************************************

Name/Version      : xsls/4.4

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.J. van Genderen
Creation date     : 16-Feb-1987
Modified by       : S. de Graaf
Modification date : 08-Dec-1987


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1987 , All rights reserved
**********************************************************/
#include "incl.h"

extern int out_indent;
extern int language;
extern int tog_comma;
extern int tog_pnod;
extern int tog_nnod;
extern int tog_nodnbr;

prHead (ntw, submod)
struct model_info *ntw;
int submod;
{
    struct cir_term *t;
    struct term_ref *tref;
    int currTermType = -1;
    int firstinode;
    char par[64];
    char *p;
    int prPnod;
    int prNnod;
    int outPos ();

    switch (language) {
	case SLS:
	    oprint (0, "network ");
	    break;
	case SPICE:
	    if (submod) {
		oprint (0, ".subckt ");
	    }
	    else {
		oprint (0, "* circuit ");
	    }
	    break;
	case SIMON:
	    if (submod) {
		oprint (0, "   macro");
		oprint (0, "\n");
		oprint (0, "macro ");
	    }
	    else {
		oprint (0, "   netstart ");
	    }
	    break;
	case EDIF:
	    oprint (0, "(cell ");
	    break;
    }

    oprint (0, ntw -> name);
    oprint (0, " ");

    if (language == SIMON && !submod) {
	oprint (0, "\n");
	return;
    }

    if (language == SLS) {
	if (ntw -> terms == NULL) {
	    oprint (0, "()");
	    oprint (0, "\n");
	    oprint (0, "{");
	    oprint (0, "\n");
	    return;
	}
	oprint (0, "(");
    }
    if (language == EDIF) {
	oprint (0, "(cellType GENERIC)");
	oprint (0, "(view VIEWNAMEDEFAULT ");
	oprint (0, "(viewType NETLIST)");
	oprint (0, "(interface ");
    }

    out_indent = outPos ();
    
    if (language == SLS)
	oprint (0, "terminal ");

    prPnod = tog_pnod;
    prNnod = tog_nnod;

    for (tref = ntw -> terms; tref != NULL; tref = tref -> next) {
	t = tref -> t;

	if (strcmp (t -> term_name, "pbulk") == 0)
	    prPnod = 0;
	if (strcmp (t -> term_name, "nbulk") == 0)
	    prNnod = 0;
    }

    if (prPnod || prNnod) {
	if (prPnod) {
	    if (language == EDIF) oprint (0, "(port ");
	    nmprint (0, "pbulk", 0, NULL, NULL, 0, tog_nodnbr, 1);
	    if (language == EDIF) oprint (0, ")");
	}
	if (prNnod) {
	    if (prPnod) {
		if (tog_comma) {
		    oprint (1, ",");
		}
		oprint (0, " ");
	    }
	    if (language == EDIF) oprint (0, "(port ");
	    nmprint (0, "nbulk", 0, NULL, NULL, 0, tog_nodnbr, 1);
	    if (language == EDIF) oprint (0, ")");
	}
	if (ntw -> terms != NULL) {
	    if (tog_comma) {
		oprint (1, ",");
	    }
	    oprint (0, " ");
	}
    }

    firstinode = 1;

    for (tref = ntw -> terms; tref != NULL; tref = tref -> next) {
	t = tref -> t;

	if (language == SIMON) {

	    if (tref -> type == INPUT
		|| tref -> type == INREAD) {

		if (currTermType == -1) {
		    oprint (0, "i(");
		    firstinode = 1;
		}
		currTermType = tref -> type;
	    }
	    else if (tref -> type == INOUT) {
		if (currTermType >= 0 
		    && currTermType != INOUT) {
		    oprint (0, ") ");
		}
		if (currTermType != INOUT) {
		    oprint (0, "io(");
		    firstinode = 1;
		}
		currTermType = tref -> type;
	    }
	    else if (tref -> type == OUTPUT) {
		if (currTermType >= 0 
		    && currTermType != OUTPUT) {
		    oprint (0, ") ");
		}
		if (currTermType != OUTPUT) {
		    oprint (0, "o(");
		    firstinode = 1;
		}
		currTermType = tref -> type;
	    }
	}

	if (firstinode) {
	    firstinode = 0;
	}
	else {
	    if (tog_comma) {
		oprint (1, ",");
	    }
	    oprint (0, " ");
	}

	if (language == EDIF) oprint (0, "(port ");
	nmprint (0, t -> term_name, t -> term_dim, 
		 t -> term_lower, t -> term_upper, 1, tog_nodnbr, 1);
	if (language == EDIF) oprint (0, ")");
    }

    if (language == SLS || language == SIMON) 
	oprint (1, ")");
    if (language == EDIF) {

	if (ntw -> param != NULL) {
	    p = ntw -> param;
	    while (*p != '\0') {
		sscanf (p, "%s", par);
		oprint (0, "(parameter ");
		oprint (0, par);
		/*
		if (strcmp (ntw -> name, "res") == 0 && par[0] == 'v') {
		    oprint (0, "(number 0)");
		    oprint (0, "(unit RESISTANCE)");
		}
		else if (strcmp (ntw -> name, "cap") == 0 && par[0] == 'v') {
		    oprint (0, "(number 0)");
		    oprint (0, "(unit CAPACITANCE)");
		}
		else if (par[0] == 'w' && par[1] == '\0') {
		    oprint (0, "(number (e 1 -6))");
		    oprint (0, "(unit DISTANCE)");
		}
		else if (par[0] == 'l' && par[1] == '\0') {
		    oprint (0, "(number (e 1 -6))");
		    oprint (0, "(unit DISTANCE)");
		}
		else {
		*/
		    oprint (0, "(number)");
		/*
		}
		*/
		oprint (0, ")");
		while (*p != '\0' && *p != ' ')
		    p++;
		if (*p == ' ') p++;
	    }
	}
	oprint (0, ")");
    }
    else
	oprint (0, "\n");
    out_indent = 0;
    if (language == SLS) {
	oprint (0, "{");
	oprint (0, "\n");
	(void) outPos ();
    }
}
