static char *SccsId = "@(#)change.c 4.2 (TU-Delft) 08/28/90";
/**********************************************************

Name/Version      : tecc/4.2

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author            : A.J. van Genderen
Creation date     : 15-Mar-1988
Modified by       :
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1988. All rights reserved.
**********************************************************/
#include <stdio.h>
#include <dmincl.h>
#include "define.h"
#include "type.h"
#include "extern.h"

/* changeMasks completes the keylist,
 * contructs the maskTransf vector,
 * and calculates the LayerWeights.
 */

static struct layerRef *newkeylist;

changeMasks ()
{
    struct layerRef *ref;
    int i;
    int i_new;
    int nbr;
    int currWeight;

    newkeylist = NULL;

    for (ref = keylist; ref != NULL; ref = ref -> next) {
	if (ref -> lay -> occurrence == OTHEREDGE) {
	    addNewkeylist (ref -> lay -> mask, SURFACE);
	    addNewkeylist (ref -> lay -> mask, EDGE);
	    addNewkeylist (ref -> lay -> mask, OTHEREDGE);
	}
    }

    for (ref = keylist; ref != NULL; ref = ref -> next) {
	if (ref -> lay -> occurrence == EDGE) {
	    addNewkeylist (ref -> lay -> mask, SURFACE);
	    addNewkeylist (ref -> lay -> mask, EDGE);
	}
    }

    for (ref = keylist; ref != NULL; ref = ref -> next) {
	if (ref -> lay -> occurrence == SURFACE) {
	    addNewkeylist (ref -> lay -> mask, SURFACE);
	}
    }

    keylist = newkeylist;

    if (maxNbrKeys >= 0) {
	ref = keylist;
	for (nbr = 1; nbr < maxNbrKeys && ref != NULL; nbr++) {
	    ref = ref -> next;
	}
	if (ref == keylist)
	    keylist = NULL;
	else if (ref != NULL)
	    ref -> next = NULL;
    }

    sSlotCnt = eSlotCnt = oeSlotCnt = 0;
    for (ref = keylist; ref != NULL; ref = ref -> next) {
	switch (ref -> lay -> occurrence) {
	    case SURFACE:
		sSlotCnt++;
		break;
	    case EDGE:
		eSlotCnt++;
		break;
	    case OTHEREDGE:
		oeSlotCnt++;
		break;
	}
    }
    
    for (i = 0; i < procdata -> nomasks; i++) {
	maskTransf[i] = -1;
    }

    i_new = 0;
    for (ref = keylist; 
	 ref != NULL && ref -> lay -> occurrence == SURFACE; 
	 ref = ref -> next) {
	maskTransf[ref -> lay -> mask] = i_new++;
    }
    
    for (i = 0; i < procdata -> nomasks; i++) {
	if (maskTransf[i] == -1)
	    maskTransf[i] = i_new++;
    }

    for (i = 0; i < procdata -> nomasks; i++) {
	maskBackTransf[ maskTransf[i] ] = i;
    }

    ALLOC (sLayerWeight, procdata -> nomasks, int);
    for (i = 0; i < procdata -> nomasks; i++) {
	sLayerWeight[i] = 0;
    }
    ALLOC (eLayerWeight, procdata -> nomasks, int);
    for (i = 0; i < procdata -> nomasks; i++) {
	eLayerWeight[i] = 0;
    }
    ALLOC (oeLayerWeight, procdata -> nomasks, int);
    for (i = 0; i < procdata -> nomasks; i++) {
	oeLayerWeight[i] = 0;
    }

    currWeight = 1;
    for (ref = keylist; ref; ref = ref -> next) {
	
	if (ref -> lay -> occurrence == SURFACE) {
	    sLayerWeight [ref -> lay -> mask] = currWeight;
	}
	else if (ref -> lay -> occurrence == EDGE) {
	    eLayerWeight [ref -> lay -> mask] = currWeight;
	}
	else if (ref -> lay -> occurrence == OTHEREDGE) {
	    oeLayerWeight [ref -> lay -> mask] = currWeight;
	}
	currWeight = currWeight * 2;
    }

    nbrKeySlots = currWeight;
}

addNewkeylist (mask, occurrence)
int mask;
int occurrence;
{
    struct layerRef *prevref;
    struct layerRef *newref;
    struct layerRef *ref;

    prevref = NULL;
    for (ref = newkeylist; ref != NULL; ref = ref -> next) {

	if (ref -> lay -> mask == mask
	&& ref -> lay -> occurrence == occurrence) {
	    return;
	}

	if (occurrence == SURFACE) {
	    if (ref -> lay -> occurrence == EDGE
	    || ref -> lay -> occurrence == OTHEREDGE) {
		break;
	    }
	}
	else if (occurrence == EDGE) {
	    if (ref -> lay -> occurrence == OTHEREDGE) {
		break;
	    }
	}

	prevref = ref;
    }

    ALLOC (newref, 1, struct layerRef);
    if (prevref == NULL) {
	newref -> next = NULL;
	newkeylist = newref;
    }
    else {
	newref -> next = prevref -> next;
	prevref -> next = newref;
    }
    ALLOC (newref -> lay, 1, struct layer);
    newref -> lay -> mask = mask;
    newref -> lay -> occurrence = occurrence;
}
