#ifndef lint
static char *SccsId = "@(#)info.c 4.5 (TU-Delft) 11/24/92";
#endif /* lint */
/**********************************************************

Name/Version      : space/4.5

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.J. van Genderen
		  : N.P. van der Meijs
Creation date     : 15-Mar-1988
Modified by       :
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1988. All rights reserved.
**********************************************************/
#include <stdio.h>
#include "include/config.h"
#include "include/type.h"
#include "scan.h"

struct _scanInfo scanInfo;

void scanPrintInfo (fp)
FILE *fp;
{
    fprintf (fp, "\tsize (x*y)         : %d*%d\n", 
	scanInfo.xr - scanInfo.xl, scanInfo.yt - scanInfo.yb);
    fprintf (fp, "\tnumber of edges    : %d\n", scanInfo.edges);
    fprintf (fp, "\tnumber of x pos.   : %d\n", scanInfo.xpos);
    fprintf (fp, "\taverage sr length  : %d\n",
	scanInfo.xpos != 0 ? scanInfo.srl/scanInfo.xpos : 0);
    edgeStatistics (fp);
    tileStatistics (fp);
#   ifdef NOTDEF
    {
    long utime, stime, rtime;
    utime = (long) scanInfo.tms2.tms_utime - scanInfo.tms1.tms_utime;
    stime = (long) scanInfo.tms2.tms_stime - scanInfo.tms1.tms_stime;
    rtime = (long) scanInfo.rtime;
    fprintf (fp, "\tuser time (sec)    : %d.%d\n", utime/60, utime%10);
    fprintf (fp, "\tsystem time (sec)  : %d.%d\n", stime/60, stime%10);
    fprintf (fp, "\tcpu time (u+s)     : %d.%d\n", (utime + stime)/60,
				 	      (utime + stime)%10);
    fprintf (fp, "\treal time (sec)    : %d.%d (%d%%)\n", rtime/60, rtime%10,
				             (100*utime + 100*stime)/rtime);
    }
#   endif /* NOTDEF */
}
