#ifndef lint
static char *SccsId = "@(#)getParam.c 4.8 (TU-Delft) 01/28/93";
#endif /* lint */
/**********************************************************

Name/Version      : space/4.8

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.J. van Genderen
		  : N.P. van der Meijs
Creation date     : 15-Mar-1988
Modified by       :
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1988. All rights reserved.
**********************************************************/
#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include "dmincl.h"
#include "include/config.h"
#include "include/type.h"
#include "aux/aux.h"

extern bool_t optLatCap;

#define DEFAULT_PARAM_FILE "space.def.p"

int min_art_degree   = -1;    
int min_degree       = -1;
double min_res       = -1.0;
double low_sheet_res = 1.0;
double max_par_res   = -1.0;  
double min_coup_cap  = -1.0;
bool_t no_neg_res = FALSE;
bool_t paramCapitalize = FALSE;

double max_tan_slice_y = -1.0;
double max_obtuse      = -1.0;

double physBandWidth = 0.0;


#define KV(k, v) \
    else if (strsame (k, key)) { \
	 if (!(lineError = (sscanf (val, "%le", &d_val) != 1))) \
	     v = d_val; \
    }

#define KW(k, v) \
    else if (strsame (k, key)) { v = TRUE; }


/* local operations */
private void    readParameterFile ();
private void    resetParameters ();

static char * paramfile;

void getParameters (dmproject, libFile, userFile)
DM_PROJECT * dmproject;
char * libFile;
char * userFile;
{
    char * pfile;
    char filebuf[256];

    if (userFile == NULL) {
	if (libFile == NULL) {
#if NCF_RELEASE >= 400
	    sprintf (filebuf, "%s/%s", dmproject -> TMPath, ".space.def.p");
#else
	    sprintf (filebuf, "%s/%s", dmproject -> dmpath, ".space.def.p");
#endif
	    if (access (filebuf, 0) == 0)
		pfile = filebuf;
	    else
	    pfile = dmGetMetaDesignData (PROCPATH, dmproject,
					  DEFAULT_PARAM_FILE);
	}
	else {
	    pfile = dmGetMetaDesignData (PROCPATH, dmproject,
			    mprintf ("space.%s.p", libFile));
	    if (access (pfile, 0) != 0) {
		say ("space.%s.p: no such parameter file in %s",
		     libFile, dmGetMetaDesignData (PROCPATH, dmproject, ""));
		die ();
	    }
	}
    }
    else {
	pfile = userFile;
    }

    verbose ("parameter control file: %s\n", pfile);

    paramfile = strsave (pfile);

    readParameterFile ();
}

/*
 * reGetParameters is executed before every extraction
 * in interactive (display) mode.
 *
 * reGetParameters should perhaps check to see if the file
 * has changed since the last time it has read the file.
 */
void reGetParameters ()
{

    readParameterFile ();
}


private void readParameterFile () 
{

    int lineError = 0;
    int numErrors = 0;
    int    line;
    FILE * fp;
    char * key;
    char * val;
    double d_val;
    char linebuf[200];

    resetParameters ();

    fp = cfopen (paramfile, "r");

    lineError = 0;

    line = 0;

    while (fgets (linebuf, sizeof (linebuf) - 1, fp)) {
	line++;
	linebuf[strlen(linebuf)-1] = '\0';      /* strip '\n' */
	key = strtok (linebuf, " \t");
	if (key == NULL) continue;

	/* since the string does not contain \n's,
	 * this delivers the rest of the string.
	 */
	val = strtok ((char *) NULL, "\n");
	if (val == NULL) val = "";

	/* strip initial white space, gives nicer error messages. */
	while (isspace (*val)) val++;

	Debug (fprintf (stderr,
	    "line %d: key <%s> val <%s>\n", line, key, val));

	if (key[0] == '#') {
	}
	KV ("max_obtuse", max_obtuse)
	KV ("max_tan_slice_y", max_tan_slice_y) /* currently, for backwards 
						   compatibility only */
	KV ("min_art_degree", min_art_degree)
	KV ("min_degree", min_degree)
	KV ("min_res", min_res)
	KV ("max_par_res", max_par_res)
	KV ("low_sheet_res", low_sheet_res)
	KW ("no_neg_res", no_neg_res)
	KW ("capitalize", paramCapitalize)
	KV ("min_coup_cap", min_coup_cap)
	KV ("lat_cap_window", physBandWidth)

	else {
	    paramSet (key, val);
	}

	if (lineError) {
	    say ("error in file %s, line %d: %s %s",
		paramfile, line, key, val);
	    numErrors++;
	    lineError = 0;
	}
    }

    if (numErrors) {
	say ("can not continue because of error(s) in file %s\n", paramfile);
	die ();
    }

    if (!optLatCap)
	physBandWidth = 0.0;

    if (max_obtuse > 90.00001) {
	if (max_obtuse >= 179.99999) {
	    max_tan_slice_y = 0.0;
	}
	else {
	    max_tan_slice_y = 1.0 / tan (M_PI * (max_obtuse - 90.0) / 180.0);
	}
    }
    fclose (fp);
}

/*
 * reset parameters to extractor built-in default value
 */

extern int nrOfConductors;
private void resetParameters () 
{
    min_art_degree = -1;
    min_degree = -1;
    min_res = -1.0;
    max_par_res = -1.0;
    min_coup_cap = -1.0;
    low_sheet_res = 1.0;
    no_neg_res = FALSE;

    max_tan_slice_y = -1.0;

    physBandWidth = 0.0;

    paramFree ();
}

/* EOF */
