static char *SccsId = "@(#)clearTile.c 4.5 (TU-Delft) 05/14/93";
/**********************************************************

Name/Version      : space/4.5

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.J. van Genderen
		  : N.P. van der Meijs
Creation date     : 15-Mar-1988
Modified by       :
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1988. All rights reserved.
**********************************************************/
#include <stdio.h>
#include "include/config.h"
#include "include/type.h"
#include "aux/aux.h"
#include "extract/define.h"
#include "extract/extern.h"


/* clearTile (tile)
 *
 * will finish the influence of 'tile' on the network by
 * cleaning the related network datastructures.
 *
 * actions performed :
 *
 * - Subnodes for 'tile' are deleted. 
 *   This will result in a possible elimination of nodes,
 *   or outputting of extracted circuit nodes and elements.
 *
 * - Possible subtransistors for 'tile' are deleted.
 *   This again may result in outputting of circuit data.
 */

void clearTile (tile)
tile_t * tile;
{
    register int i;
    node_t * dsn = NULL;

    if (tile -> tor != NULL) {    
	subtorDel (tile, dsn);
    }

    /* Currently, the order between above and below
       can not be changed since subtorDel may set type = 't'
       for a node that would otherwize be eliminated by subnodeDel

       Note: however, the current situation gives problems for the 
       implementation of the R mesh for transistors !!! 
    */

    if (!optRes && !optAccWL) {
	register subnode_t ** cons = tile -> cons;
	for (i = 0; i < nrOfExtConductors; i++) {
	    if (cons[i] != NULL) {
		subnodeDel (cons[i]);
	    }
	}
    }
}

