static char *SccsId = "@(#)monitor.c 4.4 (TU-Delft) 04/19/93";
/**********************************************************

Name/Version      : aux/4.4

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Authors           : A.J. van Genderen
                  : N.P. van der Meijs
Creation date     : 15-Mar-1988
Modified by       :
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1988. All rights reserved.
**********************************************************/

#if defined (DRIVER) && ! defined (MONITOR)
#define MONITOR
#endif

/* #define MONITOR		/* if the system supports it */

#include <stdio.h>
#include "include/config.h"
#include "monitor.h"

#ifdef MONITOR

/* Primitive interface for profiling,
 * No function call counts, but only used time.
 * Produces a mon.out file, to be processed by prof (1).
 * See also monitor (3c) and profil (2).
 *
 * Example:
 *    ...
 *    monitorStart ();
 *    ...
 *    doMyTrick ();
 *    ...
 *    monitorStop ();
 *    ...
 */
void monitorStart () 
{
    WORD *buffer;
    int bufsize, nfunc;
    extern etext;

    bufsize = ((int) &etext) / 5;

    buffer = NEW (WORD, bufsize);
     
    nfunc = 0;

    monitor ((int(*)())2, (int(*)())& etext, buffer, bufsize, nfunc);
}

/*
 * Stop monitoring
 */
void monitorStop ()
{
    monitor ((int(*)())0, (int(*)())0, 0, 0, 0);
}
#endif /* MONITOR */


#ifdef DRIVER

/* test driver and example */
main ()
{
    int i;
    monitorStart ();

    for (i = 0; i< 1000000; i++) strlen ("abcd");

    for (i = 0; i < 10000; i++) access ("/usr/abc/def", 0);

    monitorStop ();
}
#endif /* DRIVER */
