/* SccsId = "@(#)aux.h 4.6 (TU-Delft) 01/28/93" */
/**********************************************************

Name/Version      : aux/4.6

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Authors           : A.J. van Genderen
                  : N.P. van der Meijs
Creation date     : 15-Mar-1988
Modified by       :
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1988. All rights reserved.
**********************************************************/

#include "aux/bool.h"
#include "aux/debug.h"
#include "aux/assert.h"
#include "aux/malloc.h"
#include "aux/proto.h"
#include "aux/libc.h"

#ifdef BSD
#define strchr  	index
#define strrchr	 	rindex
#endif /* BSD */

/* 'Standard' macros
*/
#define EOS             '\0'
#define strsame(s1,s2)  (!strcmp(s1,s2))
#define	Abs(a)		((a) < 0   ?-(a) : (a))
#define Min(a,b)	((a) < (b) ? (a) : (b))
#define	Max(a,b)	((a) > (b) ? (a) : (b))
#define Round(x)	(((x) > 0) ? ((x)+0.5) : ((x)-0.5))
#define Sign(n)	        ((n)>0?1:((n)<0?-1:0))
#define Sqr(x)          ((x)*(x))
#define Null(type)      ((type)0)
#define Ctl(ch)         (ch & 037)
#define Swap(type,a,b)  {type c=a; a=b; b=c;}

/* File open and close
*/
#define OPENR(fp, fn)   fp=cfopen(fn, "r")
#define OPENW(fp, fn)   fp=cfopen(fn, "w")
#define CLOSE(fp)       { fclose (fp); }


/* Assume 8 bits per byte and highest bit is sign bit
*/
#define MAXTYPE(type)  (~(1<<(8*(int)sizeof(type))-1))
#ifndef MAXINT
#define MAXINT	        MAXTYPE(int)
#endif /* MAXINT */
#ifndef MAXLONG
#define MAXLONG	        MAXTYPE(long)
#endif /* MAXLONG */
#ifndef MAXSHORT
#define MAXSHORT        MAXTYPE(short)
#endif /* MAXSHORT */

/* Bit fiddling
 */
#define BitTest(v,b)    ((b)&v)
#define BitSet(v, b)    (v|=b)
#define BitClr(v, b)    (v&=~(b))

/*  Next define is used for static functions.
    Since the gprof profiler does not interpret static functions
    very well, this can then be defined empty
    (Provided there are no name clashes.)
*/
#define private static /* or empty */
