static char *SccsId = "@(#)slserr.c 4.2 (TU-Delft) 05/17/93";
/**********************************************************

Name/Version      : sls/4.2

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.C. de Graaf, A.J. van Genderen
Creation date     : 10-Jul-1986
Modified by       : S. de Graaf
Modification date : 10-Jul-1986


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1986 , All rights reserved
**********************************************************/
#include "extern.h"

#define  MAXERRORS  20
int nbr_errs = 0;

slserror (fn, lineno, errtype, str1, str2)
char   *fn;
int     lineno;
int     errtype;
char   *str1;
char   *str2;
{
    if (fn == NULL) 
	fprintf (stderr, "%s:", argv0);
    else {
        fprintf (stderr, "\"%s\"", fn);
        if (lineno > 0)
            fprintf (stderr, ", line %d:", lineno);
        else
            fprintf (stderr, ":");
    }

    switch (errtype) {
	case ERROR1: 
            break;
	case ERROR2: 
	    break;
	case WARNING: 
	    fprintf (stderr, " (warning)");
	    break;
    }
    if (str1 != NULL)
	fprintf (stderr, " %s", str1);
    if (str2 != NULL)
	fprintf (stderr, " %s", str2);
    fprintf (stderr, "\n");

    if (errtype == ERROR1)
	die (1);
    if (errtype == ERROR2) {
	fatalerror = TRUE;
        nbr_errs++;
        if (nbr_errs > MAXERRORS)
            die (1);
    }
}
