static char *SccsId = "@(#)compare.c 3.1 (TU-Delft) 04/16/87";
/**********************************************************

Name/Version      : sldm/3.1

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : N. van der Meijs
Creation date     : 17-Oct-1984
Modified by       :
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1984 , All rights reserved
**********************************************************/
# include "sldm.h"

/*
** position - determine stretch position relative to box 
** l, r, b, and t are the coordinates of the box
** sp is a pointer to a STRETCH node
*/

position (l, r, b, t, sp)
int     l, r, b, t;		/* coordinates of box */
STRETCH * sp;			/* addres of STRETCH node */
{
    int     temp;		/* to exchange l and r, and b and t */
    int     result;		/* return value */
    if (sp -> dir == YDIR) {
	temp = l;
	l = b;
	b = temp;
	temp = r;
	r = t;
	t = temp;
    }
    else  if (sp -> dir != XDIR) {
	PANIC ("bad direction: %d", sp -> dir);
	result = ERROR;
    }

    if (sp -> pos > r)
	result = HIGHER;
    else  if (sp -> pos == r)
	result = HEDGE;
    else  if (sp -> pos > l)
	result = MID;
    else  if (sp -> pos == l)
	result = LEDGE;
    else
	result = LOWER;

    return (result);
}

/*
** instersect - determine intersection of stretch line with a box 
** L, r, b, and t are the coordinates of the box.
** Sp is a pointer to a STRETCH node.
** Return value is number of edges of the box that are intersected
** (touched) by the stretch line.
*/

intersect (l, r, b, t, sp)
int     l, r, b, t;
STRETCH * sp;
{
    int     temp;
    int     count = 2;
    if (sp -> dir == YDIR) {
	temp = l;
	l = b;
	b = temp;
	temp = r;
	r = t;
	t = temp;
    }
    else  if (sp -> dir != XDIR) {
	PANIC ("bad direction: %d", sp -> dir);
	die ("internal error");
    }

    if (sp -> hi > b && sp -> hi < t)
	count = 1;
/*
**   +----+
**   |  _ |
**   |  | |
**   +--+-+
**      |
**      -
*/
    if (sp -> lo > b && sp -> lo < t)
	count = 1;
/*
**       _
**       |
**    +--+-+
**    |  | |
**    |  - |
**    +----+
*/
    if (sp -> lo >= t || sp -> hi <= b)
	count = 0;
/*
**      -
**      |
**      -
**    +----+    +----+
**    |    |    |    |
**    |    |    |    |
**    +----+    +----+
**    	          _
**	          |
**    	          _
*/
    return (count);
}
