static char *SccsId = "@(#)merge.c 4.1 (TU-Delft) 05/24/90";
/**********************************************************

Name/Version      : makevln/4.1

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : J. Annevelink
Creation date     : 18-May-1983
Modified by       : S. de Graaf
Modification date : 29-Jan-1987


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1987 , All rights reserved
**********************************************************/
#include "incl.h"

struct group_tree  *fdgrp_ptr ();

struct group_tree  *merge_groups (group1, group2)
struct group_tree  *group1,
                   *group2;
{
/* Merge two groups, i.e. make one the parent of the other */

    struct group_tree  *large,
                       *small;

    if (group1 == NULL && group2 == NULL) {
	fprintf (stderr, " Function : merge_groups \n");
	fprintf (stderr, " ??? Unidentified situation\n");
	return (NULL);
    }
    else
	if (group1 == NULL)
	    return (group2);
	else
	    if (group2 == NULL)
		return (group1);
	    else {
		group1 = fdgrp_ptr (group1);
		group2 = fdgrp_ptr (group2);
		if (group1 == group2)
		    return (group1);
		if (group1 -> tree_count <= group2 -> tree_count) {
		    large = group2;
		    small = group1;
		}
		else {
		    large = group1;
		    small = group2;
		}
		small -> parent = large;
		large -> tree_count += small -> tree_count;
		return (large);
	    }
}
