static char *SccsId = "@(#)sexp_box.c 4.3 (TU-Delft) 02/13/92";
/**********************************************************

Name/Version      : makebox/4.3

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : S. de Graaf
Creation date     : 22-Apr-1986
Modified by       : S. de Graaf
Modification date : 01-Sep-1987


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1987 , All rights reserved
**********************************************************/
#include "extern.h"

/*
** expand special box/terminal to the root level
** of the mc-tree according to mc-parameters
*/
s_exp_box (Xl, Xr, Yb, Yt)
long Xl, Xr, Yb, Yt;
{
    register long *m;
    register struct tmtx *tm;
    long xl, xr, yb, yt, tmp;

    if (s_mode) {
	strcpy (gspec.layer, process -> mask_name[gterm.layer_no]);
	strcpy (gspec.name, gterm.term_name);
    }
    else {
	strcpy (gspec.layer, "bb");
    }

    for (tm = tm_s; tm; tm = tm -> tm_next) {

	if (!s_mode) {
	    if (cellkey -> dmproject != project)
		sprintf (gspec.name, "%s(%s:%s)",
		    tm -> name,
		    cellkey -> dmproject -> projectid,
		    cellkey -> cell);
	    else
		strcpy (gspec.name, cellkey -> cell);
	}

	m = tm -> mtx;
	xl = m[0] * Xl + m[1] * Yb + m[2];
	yb = m[3] * Xl + m[4] * Yb + m[5];
	xr = m[0] * Xr + m[1] * Yt + m[2];
	yt = m[3] * Xr + m[4] * Yt + m[5];

	if (xl > xr) { tmp = xl; xl = xr; xr = tmp; }
	if (yb > yt) { tmp = yb; yb = yt; yt = tmp; }

	if (part_exp) {
	    if (xr <= exp_reg[0] || xl >= exp_reg[1]
	    ||  yt <= exp_reg[2] || yb >= exp_reg[3]) {
	    /*
	    ** the box-coordinates have no overlap
	    ** with the expansion region
	    */
		continue;
	    }
	}

	gspec.xl = xl;
	gspec.xr = xr;
	gspec.yb = yb;
	gspec.yt = yt;

	if (!nordatahack && !hier_mode)
	    dmPutDesignData (fp_spec, GEO_SPEC);
    }
}
