static char *SccsId = "@(#)readbox.c 4.3 (TU-Delft) 04/20/93";
/**********************************************************

Name/Version      : makebox/4.3

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : S. de Graaf
Creation date     : 22-Apr-1986
Modified by       : S. de Graaf
Modification date : 14-Apr-1987


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1987 , All rights reserved
**********************************************************/
#include "extern.h"

/*
** read the boxes of the cell
*/
read_box ()
{
    struct stat statbuf;

    read_box_stream ("box");

    if (add3Dbox && dmStat (cellkey, "3Dbox", &statbuf) == 1) {
	read_box_stream ("3Dbox");
    }
}

static read_box_stream (streamname)
char *streamname;
{
    DM_STREAM *fp;
    long    xl, xr, yb, yt;
    register long i, j;

    fp = dmOpenStream (cellkey, streamname, "r");

    while (dmGetDesignData (fp, GEO_BOX) > 0) {

	mask_no = gbox.layer_no;

	xl = samples * gbox.xl;
	xr = samples * gbox.xr;
	gbox.yb *= samples;
	gbox.yt *= samples;
	gbox.dx *= samples;
	gbox.dy *= samples;

	for (i = 0;;) {
	    yb = gbox.yb;
	    yt = gbox.yt;
	    for (j = 0;;) {
		exp_box (xl, xr, yb, yt);
		if (++j > gbox.ny) break;
		yb += gbox.dy;
		yt += gbox.dy;
	    }
	    if (++i > gbox.nx) break;
	    xl += gbox.dx;
	    xr += gbox.dx;
	}
    }

    dmCloseStream (fp, COMPLETE);
}
