static char *SccsId = "@(#)upd_motree.c 4.1 (TU-Delft) 05/24/90";
/**********************************************************

Name/Version      : makebox/4.1

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : J. Annevelink
Creation date     : 18-May-1983
Modified by       : S. de Graaf
Modification date : 11-Feb-1987


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1987 , All rights reserved
**********************************************************/
#include "extern.h"

/*
** search cell tree for cell name and update it
** if the cell is not already in it
*/
upd_ctree (cell, name)
struct ctree *cell;
char   *name;
{
    int    cmp;

    cmp = strcmp (name, cell -> name);

    if (cmp < 0) {
	if (cell -> lchild == NULL) {
	    cell -> lchild = upd_cptrl (name);
	}
	else {
	    upd_ctree (cell -> lchild, name);
	}
	return;
    }
    if (cmp > 0) {
	if (cell -> rchild == NULL) {
	    cell -> rchild = upd_cptrl (name);
	}
	else {
	    upd_ctree (cell -> rchild, name);
	}
    }
}

/*
** add cell to cell tree and make an entry in the
** cell-ptr-list, so that the cell will be expanded
*/
struct ctree *upd_cptrl (name)
char   *name;
{
    struct ctree *ct_tmp;
    struct cptrl *cp_tmp;

    ALLOCPTR (ct_tmp, ctree);
    strcpy (ct_tmp -> name, name);
    ct_tmp -> lchild = NULL;
    ct_tmp -> rchild = NULL;

    ALLOCPTR (cp_tmp, cptrl);
    cp_tmp -> cell = ct_tmp;
    cp_tmp -> next = NULL;
    if (cptrlast)
	cptrlast -> next = cp_tmp;
    cptrlast = cp_tmp;

    return (ct_tmp);
}
