static char *SccsId = "@(#)mak_actreg.c 4.1 (TU-Delft) 05/24/90";
/**********************************************************

Name/Version      : makebox/4.1

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : J. Annevelink
Creation date     : 18-May-1983
Modified by       : S. de Graaf
Modification date : 11-Feb-1987


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1987 , All rights reserved
**********************************************************/
#include "extern.h"

struct mc_elmt *mct;

/*
** make an active region list for each child of pmc,
** i.e. determine the overlapping wdws of the pmc->act_regl
** and the expanded bounding boxes of the cell calls
*/
make_actreg (pmc)
struct mc_elmt *pmc;
{
    for (mct = pmc -> child; mct; mct = mct -> sibling) {
#ifdef DEBUG1
P_E "exp_wdw(mct,bbox): %08x (%4d, %4d, %4d, %4d)\n",
mct,mct->bbox[0],mct->bbox[1],mct->bbox[2],mct->bbox[3]);
#endif
	/* expand mc bbox */
	exp_wdw (pmc, mct -> bbox[0], mct -> bbox[1],
			mct -> bbox[2], mct -> bbox[3]);

#ifdef DEBUG1
pr_wdwl(mct->act_regl,"act reg list");
#endif
    }

#ifdef DEBUG1
P_E "<= make_actreg()\n");
#endif
}

/*
** expand mct mc-bbox till root level, and add overlaps
** of the act regions of the parent to mct act reg list
*/
exp_wdw (pmc, xl, xr, yb, yt)
struct mc_elmt *pmc;
long   xl, xr, yb, yt;
{
    register struct wdw *t1;
    register long i, j, *w, tdy;
    struct wdw *el;

    if (!pmc -> parent) { /* root level */
	for (t1 = *arl_ptr; t1; t1 = t1 -> next) {
	/*
	** compare active regions with expanded bbox
	*/
	    w = t1 -> wdw;

	    if (xr > w[0] && xl < w[1]
	    &&  yt > w[2] && yb < w[3]) {
	    /*
	    ** add overlap to act reg list of mct
	    */
		ALLOCPTR (el, wdw);
		olap (xl, xr, yb, yt, w, el -> wdw);
		el -> next = mct -> act_regl;
		mct -> act_regl = el;
	    }
	}
	return;
    }

    w = pmc -> mtx;
    i = xl;
    xl = w[0] * i + w[1] * yb + w[2];
    yb = w[3] * i + w[4] * yb + w[5];
    i = xr;
    xr = w[0] * i + w[1] * yt + w[2];
    yt = w[3] * i + w[4] * yt + w[5];

    if (xl > xr) { i = xl; xl = xr; xr = i; }
    if (yb > yt) { i = yb; yb = yt; yt = i; }

    /*
    ** do it nx,ny times
    */
    for (i = 0;;) {
	for (tdy = j = 0;;) {
	    exp_wdw (pmc -> parent, xl, xr, yb + tdy, yt + tdy);
	    if (++j > pmc -> ny) break;
	    tdy += pmc -> dy;
	}
	if (++i > pmc -> nx) break;
	xl += pmc -> dx;
	xr += pmc -> dx;
    }
}
