static char *SccsId = "@(#)errexit.c 4.2 (TU-Delft) 06/18/90";
/**********************************************************

Name/Version      : makebox/4.2

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : J. Annevelink
Creation date     : 18-May-1983
Modified by       : S. de Graaf
Modification date : 11-Feb-1987


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1987 , All rights reserved
**********************************************************/
#include "extern.h"

char *err_list[] = {
/* 0 */    "%s",
/* 1 */    "no cell specified",
/* 2 */    "incorrect number of arguments",
/* 3 */    "incorrect window specified",
/* 4 */    "cannot create file: %s",
/* 5 */    "too many arguments specified",
/* 6 */    "sorry: cannot allocate core",
/* 7 */    "error: unknown mask name: %s",
/* 8 */    "error: check level must be >= 1",
/* 9 */    "interrupted due to signal: %s",
/* 10 */   "error in ddm interface function",
/* 11 */   "error: but cannot find error message"
};

errexit (errno, cs)
int     errno;
char   *cs;
{
    int i;

    i = (errno < 0) ? -errno : errno;
    if (i > 11) i = 11;

    P_E "%s: ", argv0);
    P_E err_list[i], cs);
    P_E "\n");

    if (errno >= 0) die ();
}

dmError (s)
char *s;
{
    P_E "%s: ", argv0);
    dmPerror (s);
    errexit (10, "");
}

die ()
{
    P_E "%s: -- program aborted --\n", argv0);
    if (project) dmCloseProject (project, COMPLETE);
    dmQuit ();
    exit (1);
}
