static char *SccsId = "@(#)BWEXNOR.c 4.1 (TU-Delft) 05/24/90";
/**********************************************************

Name/Version      : libfunc/4.1

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : GOULD

Author(s)         : O. Hol
Creation date     : 18-Feb-1988
Modified by       : 
Modification date : 


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1988 , All rights reserved
**********************************************************/
#include <stdio.h>
#include <varargs.h>

char * adm_bsalloc();

/* BWEXNOR() : returns a bit string containing the result of a bit-wise  */
/*           : exnor-operation on the given bit strings                  */

char *BWEXNOR (va_alist)
va_dcl
{
    va_list	ap;
    char	*str;
    char	*res;
    int		i;
    int		*nmbones;
    int		lenstr;

    va_start(ap);
    str = va_arg(ap,char *);
    lenstr = strlen(str);

    nmbones =  (int * ) adm_bsalloc ( sizeof(int)*lenstr , 'p' );

    res = adm_bsalloc ( lenstr + 1, 'p' );

    for ( i=0; i< lenstr   ; i++ ) {
	res[i]='I';
	nmbones[i]=0;
    }
    res[i]='\0';

    do {
	for ( i=0; i < lenstr    ; i++ ) {
	    if ( res[i] != 'X' ) {
	    	if ( str[i] == 'I' )
	            nmbones[i]++;
	    	else if ( str[i] == 'X' )
	            res[i] = 'X';
	    }
	}
    }
    while ( strcmp( (str = va_arg(ap,char *)), "ENDVAR") !=0 ) ;
    va_end(ap);

    for ( i=0; i< lenstr   ; i++ ) {
	if ( res[i] != 'X' ) {
	    if ( nmbones[i] % 2 != 0 )
		res[i]='O';
	}
    }

    return(res);
}
