static char *SccsId = "@(#)dmutil.c 3.9 (TU-Delft) 04/28/93";
/*
**	@(#)getopt.c	2.2 (smail) 1/26/87
*/

/*
 * Here's something you've all been waiting for:  the AT&T public domain
 * source for getopt(3).  It is the code which was given out at the 1985
 * UNIFORUM conference in Dallas.  I obtained it by electronic mail
 * directly from AT&T.  The people there assure me that it is indeed
 * in the public domain.
 * 
 * There is no manual page.  That is because the one they gave out at
 * UNIFORUM was slightly different from the current System V Release 2
 * manual page.  The difference apparently involved a note about the
 * famous rules 5 and 6, recommending using white space between an option
 * and its first argument, and not grouping options that have arguments.
 * Getopt itself is currently lenient about both of these things White
 * space is allowed, but not mandatory, and the last option in a group can
 * have an argument.  That particular version of the man page evidently
 * has no official existence, and my source at AT&T did not send a copy.
 * The current SVR2 man page reflects the actual behavor of this getopt.
 * However, I am not about to post a copy of anything licensed by AT&T.
 */

#include <string.h>

/*LINTLIBRARY*/

#ifndef NULL
#    define NULL	0
#endif
#ifndef EOF
#   define EOF	(-1)
#endif

#define ERR(s, c)	if(opterr){\
	extern int write();\
	char errbuf[2];\
	errbuf[0] = c; errbuf[1] = '\n';\
	(void) write(2, argv[0], (unsigned)strlen(argv[0]));\
	(void) write(2, s, (unsigned)strlen(s));\
	(void) write(2, errbuf, 2);}

extern char *index ();

int     opterr = 1;
int     optind = 1;
int     optopt;
char   *optarg;

int
        getopt (argc, argv, opts)
int     argc;
char  **argv,
       *opts;
{
    static int  sp = 1;
    register int    c;
    register char  *cp;

    if (sp == 1)
	if (optind >= argc ||
		argv[optind][0] != '-' || argv[optind][1] == '\0')
	    return (EOF);
	else
	    if (strcmp (argv[optind], "--") == NULL) {
		optind++;
		return (EOF);
	    }
    optopt = c = argv[optind][sp];
    if (c == ':' || (cp = index (opts, c)) == NULL) {
	ERR (": illegal option -- ", c);
	if (argv[optind][++sp] == '\0') {
	    optind++;
	    sp = 1;
	}
	return ('?');
    }
    if (*++cp == ':') {
	if (argv[optind][sp + 1] != '\0')
	    optarg = &argv[optind++][sp + 1];
	else
	    if (++optind >= argc) {
		ERR (": option requires an argument -- ", c);
		sp = 1;
		return ('?');
	    }
	    else
		optarg = argv[optind++];
	sp = 1;
    }
    else {
	if (argv[optind][++sp] == '\0') {
	    sp = 1;
	    optind++;
	}
	optarg = NULL;
    }
    return (c);
}
#if defined(hpux) || defined(MSDOS)
/*
 * These are routines found in BSD and not found in HP-UX.  They are
 * included so that some clients can compile.
 */

bcopy (b1, b2, length)
register unsigned char *b1,
                       *b2;
register    length;
{
    if (b1 < b2) {
	b2 += length;
	b1 += length;
	while (length--) {
	    *--b2 = *--b1;
	}
    }
    else {
	while (length--) {
	    *b2++ = *b1++;
	}
    }
}

bcmp (b1, b2, length)
register unsigned char *b1,
                       *b2;
register    length;
{
    while (length--) {
	if (*b1++ != *b2++)
	    return 1;
    }
    return 0;
}

bzero (b, length)
register unsigned char *b;
register    length;
{
    while (length--) {
	*b++ = '\0';
    }
}


/* Find the first set bit
 * i.e. least signifigant 1 bit:
 * 0 => 0
 * 1 => 1
 * 2 => 2
 * 3 => 1
 * 4 => 3
 */

int
        ffs (mask)
unsigned int    mask;
{
    register    i;

    if (!mask)
	return 0;
    i = 1;
    while (!(mask & 1)) {
	i++;
	mask = mask >> 1;
    }
    return i;
}

char   *
        index (s, c)
char   *s,
        c;
{
    return ((char *) strchr (s, c));
}

char   *
        rindex (s, c)
char   *s,
        c;
{
    return ((char *) strrchr (s, c));
}

/*
 * insque, remque - insert/remove element from a queue
 *
 * DESCRIPTION
 *      Insque and remque manipulate queues built from doubly linked
 *      lists.  Each element in the queue must in the form of
 *      ``struct qelem''.  Insque inserts elem in a queue immedi-
 *      ately after pred; remque removes an entry elem from a queue.
 *
 * SEE ALSO
 *      ``VAX Architecture Handbook'', pp. 228-235.
 */

struct qelem {
    struct qelem   *q_forw;
    struct qelem   *q_back;
    char   *q_data;
};

insque (elem, pred)
register struct qelem  *elem,
                       *pred;
{
    register struct qelem  *q;
 /* Insert locking code here */
    if (elem -> q_forw = q = (pred ? pred -> q_forw : pred))
	q -> q_back = elem;
    if (elem -> q_back = pred)
	pred -> q_forw = elem;
 /* Insert unlocking code here */
}

remque (elem)
register struct qelem  *elem;
{
    register struct qelem  *q;
    if (!elem)
	return;
 /* Insert locking code here */

    if (q = elem -> q_back)
	q -> q_forw = elem -> q_forw;
    if (q = elem -> q_forw)
	q -> q_back = elem -> q_back;

 /* insert unlocking code here */
}

/*
 * Berkeley random()
 *
 * We simulate via System V's rand()
 */

int
        random () {
            return (rand ());
}

/*
 * Berkeley srandom()
 *
 * We simulate via System V's rand()
 */

int
        srandom (seed)
int     seed;
{
    return (srand (seed));
}
#endif
