static char *SccsId = "@(#)dmsprtf.c 3.6 (TU-Delft) 04/28/93";
/**********************************************************

Name/Version      : The Design Data Management Project

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000/S500

Author(s)         : S. de Graaf
                    A. van der Hoeven
                    T.G.R. van Leuken
                    N. van der Meijs
		    T. Vogel
		    P. van der Wolf
Creation date     : 04-Dec-1986
Modified by       : 
Modification date : 


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1985-1987 , All rights reserved
**********************************************************/

# include "dmstd.h"

#if defined(sun) || defined(hpux) || defined(apollo) || defined(ultrix)
#define USE_TRICKY_NON_PORTABLE_SHIT 1
#endif /* sun, hp, apollo or ultrix */

#  ifndef MSDOS
#  ifdef __STDC__
# include <stdarg.h>
#  else /* not __STDC__ */
# include <varargs.h>
#  endif /* else not __STDC__ */

# define    BASE  10
# define MAXCHAR  100
# define  PUT(x)  (*ptr++ = (unsigned) (x))
# define UNPUT()  (ptr--)

/*
** This is a fast sprintf, only %s and %d format.
** On SEL/GOULD much faster, less difference on HP.
*/

#ifndef _dmSprintf /* in dmincl.h we can #define _dmSprintf sprintf ... */
/* VARARGS2 */
#  ifdef __STDC__
_dmSprintf ( char  *ptr, char  *fmt, ...)
#  else /* not __STDC__ */
_dmSprintf (ptr, fmt, va_alist)
register char  *ptr;
register char  *fmt;
va_dcl
#  endif /* else not __STDC__ */
{
    register char  *s;
    register char  *cp;
    register int    n;

    char    prbuf[11];
    va_list ap;
#  ifdef __STDC__
    va_start (ap, fmt);
#  else /* not __STDC__ */
    va_start (ap);
#  endif /* else not __STDC__ */

    fmt--;
loop: 
    if (*++fmt == '\0') {
	PUT ('\0');
	return (0);
    }
    else
	if (*fmt != '%') {
	    PUT (*fmt);		/* ordinary char */
	    goto loop;
	}

    if (*++fmt == 's') {
	s = va_arg (ap, char *);
	while (PUT (*s++));
	UNPUT ();
	goto loop;
    }
    else
	if (*fmt == 'd') {
	    n = va_arg (ap, int);

	    if (n < 0) {
		PUT ('-');
		n = (unsigned) (-n);
	    }

	    cp = prbuf;
	    do {
		*cp++ = '0' + n % BASE;/* ASCII */
	    } while (n /= BASE);

	    do {
		PUT (*--cp);
	    } while (cp > prbuf);
	    goto loop;
	}
	else {
	    dmerrno = DME_DDM;
	    dmError2 ("_dmSprintf", fmt);
	    PUT ('\0');
	    return (-1);
	}
}

#endif /* _dmSprintf */

#if USE_TRICKY_NON_PORTABLE_SHIT
extern int  _doprnt (); 
#endif

/*VARARGS2*/
#  ifdef __STDC__
int dmPrintf ( DM_STREAM * iop, char   *format, ...)
#  else /* not __STDC__ */
int dmPrintf (iop, format, va_alist)
        DM_STREAM * iop;
char   *format;
va_dcl
#  endif /* else not __STDC__ */
{
    register int    count;
    va_list ap;

#  ifdef __STDC__
    va_start (ap, format);
#  else /* not __STDC__ */
    va_start (ap);
#  endif /* else not __STDC__ */
#ifdef USE_TRICKY_NON_PORTABLE_SHIT
    count = _doprnt (format, ap, iop -> dmfp);
#else
    count = vfprintf(iop->dmfp, format, ap);  /* [ps] */
#endif /* USE_TRICKY_NON_PORTABLE_SHIT */
    va_end (ap);
    return (ferror (iop -> dmfp) ? EOF : count);
}

#if USE_TRICKY_NON_PORTABLE_SHIT
extern int  _doscan (); 
#endif

/*VARARGS2*/
#  ifdef __STDC__
int dmScanf ( DM_STREAM * iop, char   *fmt, ...)
#  else /* not __STDC__ */
int dmScanf (iop, fmt, va_alist)
        DM_STREAM * iop;
char   *fmt;
va_dcl
#  endif /* else not __STDC__ */
{
    va_list ap;

#  ifdef __STDC__
    va_start (ap, fmt);
#  else /* not __STDC__ */
    va_start (ap);
#  endif /* else not __STDC__ */

#ifdef USE_TRICKY_NON_PORTABLE_SHIT
    return (_doscan (iop -> dmfp, fmt, ap));
#else
    return vfscanf(iop->dmfp, fmt, ap);  /* [ps] */
#endif /* USE_TRICKY_NON_PORTABLE_SHIT */
}

#endif /* MSDOS */
