static char *SccsId = "@(#)dmaddimp.c 3.6 (TU-Delft) 03/26/91";
/**********************************************************

Name/Version      : The Design Data Management Project

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000/S500

Author(s)         : S. de Graaf
                    A. van der Hoeven
                    T.G.R. van Leuken
                    N. van der Meijs
		    T. Vogel
		    P. van der Wolf
Creation date     : 04-Dec-1986
Modified by       : S. de Graaf
Modification date : 30-Mar-1987


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1985-1987 , All rights reserved
**********************************************************/
#include "dmstd.h"

_dmAddImportedCell (dmproject, cellname, alias, view, dmpath)
DM_PROJECT *dmproject;
char   *cellname, *alias, *view, *dmpath;
{
    FILE   *fp;
    struct stat stat_buf;
    char    path[MAXLINE];

    if (strlen (alias) > DM_MAXNAME || dmTestname (alias) ||
	    strlen (cellname) > DM_MAXNAME || dmTestname (cellname))
	return (-1);
    _dmSprintf (path, "%s/%s/%s", dmpath, view, cellname);
    if (stat (path, &stat_buf) != 0) {
	dmerrno = DME_NOCELL;
	dmError ("_dmAddImportedCell");
	return (-1);
    }

#ifdef MSDOS
    _dmSprintf (path, "%s/%s/impclist", dmproject -> dmpath, view);
#else
    _dmSprintf (path, "%s/%s/impcelllist", dmproject -> dmpath, view);
#endif
    if (!(fp = fopen (path, "a"))) {
	dmerrno = DME_NOIMPCL;
	dmError ("_dmAddImportedCell: cannot add to imported celllist");
	return (-1);
    }

    /* format: alias, cellname, project-path */
    fprintf (fp, "%s %s %s\n", alias, cellname, dmpath);

    fclose (fp);
    return (0);
}
