#ifndef lint
static char *SccsId = "@(#)output.c 4.3 (TU-Delft) 01/31/92";
#endif
/*
 *      Copyright 1990 by Delft University of Technology (DUT),
 *                      Delft, The Netherlands.
 * 
 *                        All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its  documentation  without  fee,  is  hereby  granted  for  non-
 * commercial purposes  only,  provided  that  the  above  copyright
 * notice  appear  in all copies and that both that copyright notice
 * and this permission notice appear  in  supporting  documentation,
 * and  that the name of DUT not be used in advertising or publicity
 * pertaining to distribution  of  the  software  without  specific,
 * written prior permission.
 * 
 * THE DUT DISCLAIMS ALL WARRANTIES WITH REGARD  TO  THIS  SOFTWARE,
 * INCLUDING  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE DUT BE LIABLE FOR ANY SPECIAL, INDIRECT  OR
 * CONSEQUENTIAL  DAMAGES  OR  ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION  OF  CONTRACT,
 * NEGLIGENCE  OR  OTHER  TORTIOUS  ACTION,  ARISING  OUT  OF  OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 * 
 * Author(s):
 *           S. de Graaf
 *           T.G.R. van Leuken
 *           P. Kist
 * 
 * 
 * Contact address:
 * 
 * 
 * Dimes Design and Test Centre     phone: + 31 (15) 78 1459
 * Delft University of Technology   fax:   + 31 (15) 62 3271
 * P.O. Box 5053 		    email: nelsis@dutentb.tudelft.nl
 * Feldmannweg 17, 2600 GB Delft    The Netherlands
 */
#include "incl.h"
#include "extern.h"

/*
** output layout language description
*/
outp_lld ()
{
    struct mo_elmt *p, *q;

    if (v_mode) PE "\nlevel:   cell:\n");
    do { /* start at lowest level */
	q = 0;
	PF "%slevel %d%s", begC, llevel, endC);
	for (p = molist; p; p = p -> next) {
	    if (p -> level == llevel) {
		if (v_mode)
		    PE "-- %3d   %s\n", llevel, p -> mo);
		ckey = p -> key;
		switch (Pmode) {
		    case LDM:
			outp_ldm (p -> mo); break;
		    case CIF:
			outp_cif (p); break;
		    case CMK:
			outp_cmk (p -> mo); break;
		    case DLL:
			outp_dll (p -> mo); break;
		}
		dmCheckIn (ckey, COMPLETE);
		if (q) q -> next = p -> next;
		else molist = p -> next;
	    }
	    else q = p; /* last cell on another level */
	}
    } while (--llevel > 0);
}

struct ic_elmt *
inst_ic_elmt (cell)
char *cell;
{
    struct ic_elmt *p;
    ALLOC (p, struct ic_elmt);
    p -> mo = cell;
    p -> l = p -> r = 0;
    return (p);
}

inst_alias (p, cell)
struct ic_elmt *p;
char *cell;
{
    int     i;
    if ((i = strcmp (cell, p -> mo)) == 0) return;
    if (i < 0) {
	if (p -> l)
	    inst_alias (p -> l, cell);
	else
	    p -> l = inst_ic_elmt (cell);
    }
    else {
	if (p -> r)
	    inst_alias (p -> r, cell);
	else
	    p -> r = inst_ic_elmt (cell);
    }
}

#ifndef __linux                 /* this function is already in libg.a */
char *
dtoa (d)
double  d;
{
    static char xbuf[80];	/* using 4 times 20 bytes */
    static int  i = 0;
    register char  *s, *c;

    i += 20;
    i %= 80;
    s = &xbuf[i];		/* select next 20 bytes */
    sprintf (s, "%.3f", d);
    while (*++s != '.');
    c = s + 3;
    if (*c == '0')
	if (*--c == '0')
	    if (*--c == '0') --c;
    if (c == s)
	*s = 0;
    else
	*++c = 0;
    return (&xbuf[i]);
}
#endif /* __linux */

char *
strsave (s, slen)
char *s;
int   slen;
{
    register char *c, *p;
    if (!(c = malloc (slen + 1))) error (3, "char");
    p = c;
    while ((p - c) < slen) *p++ = *s++;
    *p = 0;
    return (c);
}
