static char *SccsId = "@(#)get_vln.c 4.1 (TU-Delft) 05/24/90";
/**********************************************************

Name/Version      : DUBCHECK/4.1

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)	  : T.G.R. van Leuken, J.T. Fokkema
Creation date	  : 15-Jun-1982
Modified by       : S. de Graaf
Modification date : 09-Dec-1985


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1984 , All rights reserved
**********************************************************/
#include "dubcheck.h"

/* This procedure reads a line from a vln_file and	 */
/* places its contents in the structure event.		 */
/* On the end of file EOF is returned.			 */

get_vln (fp, nbr_file)
DM_STREAM *fp;
int     nbr_file;
{
    int     edge;

    do {
	if (dmGetDesignData (fp, GEO_VLNLAY) <= 0)
	    return (0);

	edge = gvlnlay.occ_type & 7;
    }
    while ((edge == 0) || (edge == 3));

    event[nbr_file].e_xi    = gvlnlay.x;
    event[nbr_file].e_yb    = gvlnlay.yb;
    event[nbr_file].e_yt    = gvlnlay.yt;
    event[nbr_file].e_occ   = edge;
    event[nbr_file].e_group = gvlnlay.grp_number;
    event[nbr_file].e_ctype = gvlnlay.chk_type;
    return (1);
}
