static char *SccsId = "@(#)to_db.cls 4.4 (TU-Delft) 10/21/92";
/**********************************************************

Name/Version      : sls_mkdb/4.4

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.C. de Graaf
Creation date     : 10-Jul-1986
Modified by       : S. de Graaf
Modification date : 10-Jul-1986


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1986 , All rights reserved
**********************************************************/
#include "sys_incl.h"
#class
#include "class.h"
#include "mkdbdefs.h"
#include "mkdbincl.h"

extern Netelem *notconnected;

DM_STREAM * dsp_net;

void  fill_lub_cnet ();
void  fill_lub_ref ();
void  fill_lub_inst ();

void    term_to_db (q)
        Queue * q;
{
    int     i;
    Link * pq;

    for (i = 0, pq = q -> first_elem ();
	    i < q -> length ();
	    i++, pq = q -> next_elem (pq)) {
	switch (pq -> type) {
	    case QueueType: 
		term_to_db ((Queue *) pq);
		break;

	    case TermType: 
		((Netelem *) pq) -> to_db ();
		break;
	}
    }
}

void    inst_to_db (inst)
        NetworkInstance * inst;
{
    inst -> to_db ();
}

void    net_to_db (q)
        Queue * q;
{
    int     i,
            j;
    Queue * pq;
    Netelem * pnet;
    NetReference * peqv;

    if (q -> empty ()) {
	delete q;
	return;
    }

    if (doSimpleNet) {
	outSimple (q);
    }
    else {
	for (i = 0, pnet = (Netelem *) q -> first_elem ();
		i < q -> length ();
		i++, pnet = (Netelem *) q -> next_elem ((Link *) pnet)) {

	    if (pnet == notconnected)
	        continue;             /* this net is not stored in the db */

	    strcpy (cnet.net_name, pnet -> name);
	    fill_lub_cnet (&cnet, pnet -> xs);

	    pq = pnet -> eqv;
	    if (pq) {

		cnet.net_neqv = pq -> length ();
		cnet.net_eqv = new struct cir_net   [cnet.net_neqv];

		for (j=0; ! pq->empty(); j++) {
		    peqv = (NetReference *) pq -> get();
                    if (peqv -> net == notconnected) {
                        delete peqv;
                        cnet.net_neqv--;
			j--;
                        continue;       /* this one is not stored in the db */
                    }
		    strcpy (cnet.net_eqv[j].net_name, peqv -> net -> name);
		    fill_lub_cnet (&(cnet.net_eqv[j]), peqv -> net_xs);
		    fill_lub_ref (&(cnet.net_eqv[j]), peqv -> ref_xs);

		    if (peqv -> inst)
		    {
			strcpy (cnet.net_eqv[j].inst_name,
				peqv -> inst -> inst_struct -> inst_name);
			if(peqv -> inst_xs)
			    fill_lub_inst(&cnet.net_eqv[j], peqv->inst_xs);
		    }

		    delete peqv;
		}
		delete pq;
	    }

	    dmPutDesignData (dsp_net, CIR_NET);
	    
	    if(cnet.net_dim)
	    {
#ifdef DMEM
		int_nbyte -= 2 * cnet.net_dim * sizeof(int);
#endif
		delete cnet.net_lower;
		delete cnet.net_upper;
		cnet.net_dim = 0;
	    }
	
	    if(cnet.inst_dim)
	    {
#ifdef DMEM
		int_nbyte -= 2 * cnet.inst_dim * sizeof(int);
#endif
		delete cnet.inst_lower;
		delete cnet.inst_upper;
		cnet.inst_dim = 0;
	    }
	
	    if(cnet.ref_dim)
	    {
#ifdef DMEM
		int_nbyte -= 2 * cnet.net_dim * sizeof(int);
#endif
		delete cnet.ref_lower;
		delete cnet.ref_upper;
		cnet.ref_dim = 0;
	    }
	
	    if(cnet.net_neqv)
	    {
		delete cnet.net_eqv;
		cnet.net_neqv = 0;
	    }
	}

	while(!q -> empty()) { 
	    pnet = (Netelem *) q -> get(); 
	    delete pnet;
	}
	delete q;
    }
}

void    fill_lub_cnet (cnet, xs) 
struct cir_net *cnet;
Stack * xs;
{
    int     j;
    int     size = 0;
    char  **pxs;

    if (xs) {
	size = xs ? xs -> limit () - xs -> base() : 0;
	cnet -> net_dim = size;
#ifdef DMEM
    int_nbyte += size * sizeof(int);
    int_maxnbyte = int_nbyte > int_maxnbyte ? int_nbyte:int_maxnbyte;
#endif
	cnet -> net_lower = new long   [size];
#ifdef DMEM
    int_nbyte += size * sizeof(int);
    int_maxnbyte = int_nbyte > int_maxnbyte ? int_nbyte:int_maxnbyte;
#endif
	cnet -> net_upper = new long   [size];
    /* lower _boundaries */
	for (j = 0, pxs = xs -> base (); pxs < xs -> limit (); j++, pxs++)
	    cnet -> net_lower[j] = ((Xelem *) * pxs) -> left_bound;

    /* upper _boundaries */
	for (j = 0, pxs = xs -> base (); pxs < xs -> limit (); j++, pxs++)
	    cnet -> net_upper[j] = ((Xelem *) * pxs) -> right_bound;
    }
    else
	cnet -> net_dim = 0;
}
void    fill_lub_ref (cnet, xs)
	struct cir_net *cnet;
        Stack * xs;
{
    int     j;
    int     size=0;
    char  **pxs;

    if (xs) {
	size = xs ? xs -> limit () - xs -> base() : 0;
	cnet -> ref_dim = size;
#ifdef DMEM
    int_nbyte += size * sizeof(int);
    int_maxnbyte = int_nbyte > int_maxnbyte ? int_nbyte:int_maxnbyte;
#endif
	cnet -> ref_lower = new long   [size];
#ifdef DMEM
    int_nbyte += size * sizeof(int);
    int_maxnbyte = int_nbyte > int_maxnbyte ? int_nbyte:int_maxnbyte;
#endif
	cnet -> ref_upper = new long   [size];
    /* lower _boundaries */
	for (j = 0, pxs = xs -> base (); pxs < xs -> limit (); j++, pxs++)
	    cnet -> ref_lower[j] = ((Xelem *) * pxs) -> left_bound;

    /* upper _boundaries */
	for (j = 0, pxs = xs -> base (); pxs < xs -> limit (); j++, pxs++)
	    cnet -> ref_upper[j] = ((Xelem *) * pxs) -> right_bound;
    }
    else
	cnet -> ref_dim = 0;
}
void    fill_lub_inst (cnet, xs)
	struct cir_net *cnet;
        Stack * xs;
{
    int     j;
    int     size = 0;
    char  **pxs;

    if (xs) {
	size = xs ? xs -> limit () - xs -> base() : 0;
	cnet -> inst_dim = size;
#ifdef DMEM
    int_nbyte += size * sizeof(int);
    int_maxnbyte = int_nbyte > int_maxnbyte ? int_nbyte:int_maxnbyte;
#endif
	cnet -> inst_lower = new long   [size];
#ifdef DMEM
    int_nbyte += size * sizeof(int);
    int_maxnbyte = int_nbyte > int_maxnbyte ? int_nbyte:int_maxnbyte;
#endif
	cnet -> inst_upper = new long   [size];
    /* lower _boundaries */
	for (j = 0, pxs = xs -> base (); pxs < xs -> limit (); j++, pxs++)
	    cnet -> inst_lower[j] = ((Xelem *) * pxs) -> left_bound;

    /* upper _boundaries */
	for (j = 0, pxs = xs -> base (); pxs < xs -> limit (); j++, pxs++)
	    cnet -> inst_upper[j] = ((Xelem *) * pxs) -> right_bound;
    }
    else
	cnet -> inst_dim = 0;
}
