#ifdef __cplusplus
   #include <stdio.h>
   extern "C" {
     extern void yyerror(char *);
     extern int yylex();
   }
#endif	/* __cplusplus */ 

# line 2 "spipar.y"
/* SccsId = "@(#)spipar.y 4.9 (TU-Delft) 12/15/92" */
/**********************************************************

Name/Version      : sls_mkdb/4.9

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.J. van Genderen
Creation date     : 19-May-1992
Modified by       : 
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1986 , All rights reserved
**********************************************************/
#include "sys_incl.h"
#class
#include "class.h"
#include "mkdbdefs.h"
#include "mkdbincl.h"

extern char yytext[];
extern Netelem * notconnected;

int resynch();
char *strsav();
double cvt_atof();
Stack *stackcpy();
Stack *xstackcpy();
Network *init_ntw();
Network *read_ntw();
Network *dev_tab[];

int n_net_cnt;
int n_inst_cnt = 0;
int n_term_cnt;

Stack 	*xs, *pxs;
Stack 	*attr_s;
Queue	*pq;
Queue	*netq;
Queue	*pnetq;
extern Dictionary *ntw_dict;
extern Dictionary *sym_dict;
extern Dictionary *dff_dict;

extern char **globNets;
extern int globNets_cnt;

Xelem 	*pxelem;
Netelem	*pnet;
Network *ntw;
Network *pntw;
NetReference *pnref;
NetworkInstance *inst;

char name_buf[BUFSIZ];
char net_buf[BUFSIZ];
char ntw_name[BUFSIZ];
char topcell[BUFSIZ];
char attr_buf[BUFSIZ];

int trunc_warn = 0;
int externspec = 0;
Network *curr_ntw;
int curr_inst_type;

char mc_type = 'i';  /* Indicates what type of model call is being parsed.
			Used for write to sim_mc stream. */

int behind_header = 0;   /* used for lexical analyzer to detect 
			    correct initial condition */


# line 88 "spipar.y"
typedef union  {
	int   ival;
	char *sval;
	char cval;
	int *pival;
	float fval;
	double dval;
	} YYSTYPE;
# define INTEGER 257
# define IDENTIFIER 258
# define FLOAT 259
# define TOR_INST 260
# define NETW_INST 261
# define CAP_INST 262
# define RES_INST 263
# define T_WIDTH 264
# define T_LENGTH 265
# define SUBCKT 266
# define ENDS 267
# define END 268
# define OTHER_CARD_BEGIN 269
# define VNET 270
# define RNET 271
# define CNET 272
# define PERIOD 273
# define ASSIGN 274
# define LPS 275
# define RPS 276
# define OTHER 277
# define NEWLINE 278
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif

/* __YYSCLASS defines the scoping/storage class for global objects
 * that are NOT renamed by the -p option.  By default these names
 * are going to be 'static' so that multi-definition errors
 * will not occur with multiple parsers.
 * If you want (unsupported) access to internal names you need
 * to define this to be null so it implies 'extern' scope.
 * This should not be used in conjunction with -p.
 */
#ifndef __YYSCLASS
# define __YYSCLASS static
#endif
YYSTYPE yylval;
__YYSCLASS YYSTYPE yyval;
typedef int yytabelem;
# define YYERRCODE 256

# line 908 "spipar.y"


void yyerror(s)
char * s;
{
    sls_error(yylineno,SYNTAX,NULL);
}

int resynch(c)
char c;
{
    int c1,
	newline = 0;

    fprintf(stderr," \"");
    if(yytext)
    	fprintf(stderr,"%s",yytext);
    while((c1 = Input()) != c && c1 != 0)
    {
	if(!(newline = (newline || ((c1=='\n')?1:0))))
        fprintf(stderr,"%c",c1);
    }

    fprintf(stderr,"\"\n");

    return(c1);
}

void stackfree(xs, type)
Stack *xs;
int type;
{
    char *p;

    if(xs)
    {
         while(! xs->empty())
         {
	     p = xs -> pop();
	     switch (type) {
	         case XELEM:
		     if(p)
		         delete (Xelem *) p;
		     break;
	         case STRING:
		     if(p)
		     {
#ifdef DMEM
    char_nbyte -=  strlen(p) + 1;
#endif
		         delete p;
		     }
		     break;
	     }
         }
    }
}

Netelem *findterm(inst, term_name)
NetworkInstance *inst;
char *term_name;
{
    Queue *termq;
    int termq_len;
    Netelem *pterm;
    int i;

    if (inst)
	termq = inst -> ntw -> termq;
    else
	termq = ntw -> termq;

    termq_len = termq -> length ();

    for(i=0, pterm = (Netelem *) termq -> first_elem ();
	i < termq_len;
	i++, pterm = (Netelem *) termq -> next_elem ((Link *) pterm))
    {
	if(strcmp(pterm->name, term_name) == 0)
	    return(pterm);
    }

    return(0);
}

int gettermcnt (netw)
Network *netw;
{
    Queue *termq;
    int termq_len;
    Netelem *pterm;
    int i;
    int term_cnt;

    termq = netw -> termq;
    termq_len = termq -> length ();
    term_cnt = 0;

    for(i=0, pterm = (Netelem *) termq -> first_elem ();
	i < termq_len;
	i++, pterm = (Netelem *) termq -> next_elem ((Link *) pterm))
    {
	term_cnt += getxslength (pterm -> xs);
    }

    return (term_cnt);
}

void prxs(xs)
Stack *xs;
{

    int i;
    int xs_len = xs -> length();

    fprintf(stderr,"stack: %x, length: %d\n", xs, xs_len);
    if(xs)
    {
        for(i=0; i<xs_len; i++)
        {
	    pxelem = (Xelem *) xs -> access(i);
	    fprintf(stderr,"lb: %d, rb: %d\n", pxelem -> left_bound,
					       pxelem -> right_bound);
        }
    }
}
__YYSCLASS yytabelem yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
-1, 16,
	267, 13,
	268, 13,
	-2, 0,
-1, 101,
	257, 61,
	258, 61,
	-2, 45,
	};
# define YYNPROD 87
# define YYLAST 159
__YYSCLASS yytabelem yyact[]={

    52,    53,    54,    92,    51,     8,   122,    63,    64,    55,
    56,    57,    58,    21,     8,    47,    59,    60,    61,    62,
    65,    51,    52,    53,    54,     6,   119,   120,   115,    63,
    64,    55,    56,    57,    58,    13,    73,     8,    59,    60,
    61,    62,    65,    26,    71,     8,   114,    42,    41,    44,
    43,    97,   111,    98,    90,     8,    35,    32,    33,    34,
    74,   105,    88,    70,     7,    19,    49,    15,    50,     5,
    25,    23,    22,    16,     7,    48,    20,    45,    46,    10,
    17,    79,    81,    18,    14,     3,     9,    66,     4,     2,
    67,    68,    69,     1,    72,    89,   118,    75,    76,    94,
   117,    77,    82,    83,   100,   123,    84,    96,    40,    91,
    31,    39,    30,    85,    38,    29,    99,    37,    28,    36,
    27,    24,    11,   102,    12,    95,   104,    87,    78,    80,
    86,     0,     0,    93,     0,     0,     0,     0,     0,   101,
     0,   103,     0,   106,   106,   107,     0,     0,    91,   113,
   110,   124,   108,   109,   116,     0,   112,     0,   121 };
__YYSCLASS yytabelem yypact[]={

 -3000, -3000, -3000,  -253,  -231, -3000, -3000, -3000, -3000, -3000,
 -3000, -3000, -3000,  -244, -3000,  -255,  -213,  -252, -3000,  -257,
 -3000, -3000, -3000,  -274,  -274,  -274, -3000, -3000, -3000, -3000,
 -3000, -3000,  -221,  -221,  -221, -3000,  -221,  -221,  -221,  -221,
 -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000,  -203,  -275,
 -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000,
 -3000, -3000, -3000, -3000, -3000, -3000,  -257,  -275,  -275,  -275,
  -206,  -221, -3000, -3000, -3000,  -206, -3000,  -235,  -221, -3000,
  -244,  -221,  -244,  -244,  -235,  -257,  -274,  -203, -3000, -3000,
 -3000, -3000, -3000,  -275, -3000, -3000, -3000, -3000, -3000, -3000,
 -3000, -3000, -3000, -3000,  -221,  -206, -3000,  -206,  -275,  -275,
 -3000,  -238,  -238,  -221, -3000, -3000, -3000, -3000,  -268, -3000,
 -3000, -3000,  -206, -3000, -3000 };
__YYSCLASS yytabelem yypgo[]={

     0,   130,    63,   129,   128,    44,   127,    62,   125,   124,
   122,   121,   120,   119,   118,   117,   115,   114,   112,   111,
   110,   108,    52,    46,   107,   105,    28,   100,    96,    61,
    95,    94,    69,    60,    93,    89,    88,    86,    85,    84,
    65,    66,    79,    67,    78,    76,    75,    73,    72,    71,
    70,    68 };
__YYSCLASS yytabelem yyr1[]={

     0,    34,    39,    35,    38,    38,    36,    36,    42,    37,
    46,     9,    10,    43,    44,    45,     1,     6,     6,     7,
    47,    47,    48,    48,    48,    48,    11,    11,    11,    49,
    49,    49,    49,    49,    50,    12,    14,    16,    18,    20,
    13,    15,    17,    19,    21,    22,    22,    23,    27,    28,
    28,    25,    26,    26,    24,     2,     3,     4,     4,     5,
    31,    31,    29,    29,    32,    30,    30,    40,    40,    51,
    51,    51,    51,    51,    51,    51,    51,    51,    51,    51,
    51,    51,    51,    33,     8,    41,    41 };
__YYSCLASS yytabelem yyr2[]={

     0,     6,     1,    10,     0,     4,     0,     4,     7,     7,
     1,    11,     1,     2,     6,     7,     3,     3,     5,     3,
     0,     4,     5,     4,     4,     3,     7,     7,     5,     2,
     2,     2,     2,     2,     4,     9,     9,     9,     9,     4,
     3,     3,     3,     3,     3,     1,     5,     3,     7,     3,
     3,     3,     3,     3,     3,     5,     9,     3,     5,     3,
     3,     3,     1,     3,     3,     3,     3,     0,     4,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     3,     3,     2,     4 };
__YYSCLASS yytabelem yychk[]={

 -3000,   -34,   -35,   -38,   -36,   -32,   278,   -33,   258,   -37,
   -42,   -10,    -9,   266,   -39,   -43,   -47,   -43,   -32,   -40,
   -45,   268,   -48,   -49,   -11,   -50,   256,   -12,   -14,   -16,
   -18,   -20,   270,   271,   272,   269,   -13,   -15,   -17,   -19,
   -21,   261,   260,   263,   262,   -33,   -44,   267,   -46,   -41,
   -51,   278,   257,   258,   259,   266,   267,   268,   269,   273,
   274,   275,   276,   264,   265,   277,   -40,   -41,   -41,   -41,
    -2,    -5,   -31,   257,   -33,    -2,    -2,   -40,    -4,    -5,
    -3,    -5,    -2,    -2,   -40,   -40,    -1,    -6,    -7,   -30,
   257,   -33,   278,   -41,   -26,    -8,   -24,   257,   259,    -5,
   -26,   -33,    -5,   -33,    -5,   -29,   -33,   -29,   -41,   -41,
    -7,   -22,   -22,    -5,   -23,   -26,   -23,   -27,   -28,   264,
   265,    -5,   274,   -25,   -26 };
__YYSCLASS yytabelem yydef[]={

     4,    -2,     6,     0,    12,     2,     5,    64,    83,     1,
     7,    20,    20,     0,    67,     0,    -2,     0,    10,     0,
     9,    67,    21,     0,     0,     0,    25,    29,    30,    31,
    32,    33,     0,     0,     0,    67,     0,     0,     0,     0,
    67,    40,    41,    42,    43,    44,     8,    67,     0,     3,
    68,    85,    69,    70,    71,    72,    73,    74,    75,    76,
    77,    78,    79,    80,    81,    82,     0,    22,    23,    24,
     0,     0,    59,    60,    61,     0,    28,    34,     0,    57,
     0,     0,    62,    62,    39,     0,     0,    16,    17,    19,
    65,    66,    86,    15,    26,    52,    53,    84,    54,    55,
    27,    -2,    58,    45,     0,     0,    63,     0,    14,    11,
    18,    35,    36,     0,    37,    47,    38,    46,     0,    49,
    50,    56,     0,    48,    51 };
typedef struct { char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

__YYSCLASS yytoktype yytoks[] =
{
	"INTEGER",	257,
	"IDENTIFIER",	258,
	"FLOAT",	259,
	"TOR_INST",	260,
	"NETW_INST",	261,
	"CAP_INST",	262,
	"RES_INST",	263,
	"T_WIDTH",	264,
	"T_LENGTH",	265,
	"SUBCKT",	266,
	"ENDS",	267,
	"END",	268,
	"OTHER_CARD_BEGIN",	269,
	"VNET",	270,
	"RNET",	271,
	"CNET",	272,
	"PERIOD",	273,
	"ASSIGN",	274,
	"LPS",	275,
	"RPS",	276,
	"OTHER",	277,
	"NEWLINE",	278,
	"-unknown-",	-1	/* ends search */
};

__YYSCLASS char * yyreds[] =
{
	"-no such reduction-",
	"spice_descr : file_header sub_ckts nom_ckt",
	"file_header : file_top ntw_name",
	"file_header : file_top ntw_name stuff eoc",
	"file_top : /* empty */",
	"file_top : file_top NEWLINE",
	"sub_ckts : /* empty */",
	"sub_ckts : sub_ckts sub_ckt",
	"sub_ckt : sub_ckt_head ckt_body sub_ckt_end",
	"nom_ckt : nom_ckt_head ckt_body nom_ckt_end",
	"sub_ckt_head : SUBCKT ntw_name",
	"sub_ckt_head : SUBCKT ntw_name ckt_term_list eoc",
	"nom_ckt_head : /* empty */",
	"ckt_body : stmt_list",
	"sub_ckt_end : ENDS stuff eoc",
	"nom_ckt_end : END stuff eoc",
	"ckt_term_list : terminal_list",
	"terminal_list : terminal",
	"terminal_list : terminal_list terminal",
	"terminal : net_name",
	"stmt_list : /* empty */",
	"stmt_list : stmt_list statement",
	"statement : inst_stmt eoc",
	"statement : net_stmt eoc",
	"statement : other_card eoc",
	"statement : error",
	"net_stmt : VNET two_con_list real",
	"net_stmt : RNET two_con_list real",
	"net_stmt : CNET two_con_list",
	"inst_stmt : x_inst_stmt",
	"inst_stmt : t_inst_stmt",
	"inst_stmt : r_inst_stmt",
	"inst_stmt : c_inst_stmt",
	"inst_stmt : o_inst_stmt",
	"other_card : OTHER_CARD_BEGIN stuff",
	"x_inst_stmt : x_inst_struct connect_list ident attr_list",
	"t_inst_stmt : t_inst_struct four_con_list ident attr_list",
	"r_inst_stmt : r_inst_struct two_con_list i_cell_name single_attr",
	"c_inst_stmt : c_inst_struct two_con_list i_cell_name single_attr",
	"o_inst_stmt : o_inst_struct stuff",
	"x_inst_struct : NETW_INST",
	"t_inst_struct : TOR_INST",
	"r_inst_struct : RES_INST",
	"c_inst_struct : CAP_INST",
	"o_inst_struct : ident",
	"attr_list : /* empty */",
	"attr_list : attr_list i_attribute",
	"single_attr : real",
	"i_attribute : attr_spec ASSIGN attr_val",
	"attr_spec : T_WIDTH",
	"attr_spec : T_LENGTH",
	"attr_val : real",
	"real : i_val",
	"real : f_val",
	"f_val : FLOAT",
	"two_con_list : connect connect",
	"four_con_list : connect connect connect connect",
	"connect_list : connect",
	"connect_list : connect_list connect",
	"connect : net_ref",
	"net_ref : INTEGER",
	"net_ref : ident",
	"i_cell_name : /* empty */",
	"i_cell_name : ident",
	"ntw_name : ident",
	"net_name : INTEGER",
	"net_name : ident",
	"stuff : /* empty */",
	"stuff : stuff stuff_item",
	"stuff_item : INTEGER",
	"stuff_item : IDENTIFIER",
	"stuff_item : FLOAT",
	"stuff_item : SUBCKT",
	"stuff_item : ENDS",
	"stuff_item : END",
	"stuff_item : OTHER_CARD_BEGIN",
	"stuff_item : PERIOD",
	"stuff_item : ASSIGN",
	"stuff_item : LPS",
	"stuff_item : RPS",
	"stuff_item : T_WIDTH",
	"stuff_item : T_LENGTH",
	"stuff_item : OTHER",
	"ident : IDENTIFIER",
	"i_val : INTEGER",
	"eoc : NEWLINE",
	"eoc : eoc NEWLINE",
};
#endif /* YYDEBUG */
#define YYFLAG  (-3000)
/* @(#) $Revision: 66.3 $ */    

/*
** Skeleton parser driver for yacc output
*/

#if defined(NLS) && !defined(NL_SETN)
#include <msgbuf.h>
#endif

#ifndef nl_msg
#define nl_msg(i,s) (s)
#endif

/*
** yacc user known macros and defines
*/
#define YYERROR		goto yyerrlab

#ifndef __RUNTIME_YYMAXDEPTH
#define YYACCEPT	return(0)
#define YYABORT		return(1)
#else
#define YYACCEPT	{free_stacks(); return(0);}
#define YYABORT		{free_stacks(); return(1);}
#endif

#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( (nl_msg(30001,"syntax error - cannot backup")) );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
/* define for YYFLAG now generated by yacc program. */
/*#define YYFLAG		(FLAGVAL)*/

/*
** global variables used by the parser
*/
# ifndef __RUNTIME_YYMAXDEPTH
__YYSCLASS YYSTYPE yyv[ YYMAXDEPTH ];	/* value stack */
__YYSCLASS int yys[ YYMAXDEPTH ];		/* state stack */
# else
__YYSCLASS YYSTYPE *yyv;			/* pointer to malloc'ed value stack */
__YYSCLASS int *yys;			/* pointer to malloc'ed stack stack */
#ifdef __cplusplus
	extern char *malloc(int);
	extern char *realloc(char *, int);
	extern void free();
# else
	extern char *malloc();
	extern char *realloc();
	extern void free();
# endif /* __cplusplus */
static int allocate_stacks(); 
static void free_stacks();
# ifndef YYINCREMENT
# define YYINCREMENT (YYMAXDEPTH/2) + 10
# endif
# endif	/* __RUNTIME_YYMAXDEPTH */
long  yymaxdepth = YYMAXDEPTH;

__YYSCLASS YYSTYPE *yypv;			/* top of value stack */
__YYSCLASS int *yyps;			/* top of state stack */

__YYSCLASS int yystate;			/* current state */
__YYSCLASS int yytmp;			/* extra var (lasts between blocks) */

int yynerrs;			/* number of errors */
__YYSCLASS int yyerrflag;			/* error recovery flag */
int yychar;			/* current input token number */



/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
int
yyparse()
{
	register YYSTYPE *yypvt;	/* top of value stack for $vars */

	/*
	** Initialize externals - yyparse may be called more than once
	*/
# ifdef __RUNTIME_YYMAXDEPTH
	if (allocate_stacks()) YYABORT;
# endif
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

	goto yystack;
	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yydebug )
		{
			register int yy_i;

			printf( "State %d, token ", yy_state );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_ps >= &yys[ yymaxdepth ] )	/* room on stack? */
		{
# ifndef __RUNTIME_YYMAXDEPTH
			yyerror( (nl_msg(30002,"yacc stack overflow")) );
			YYABORT;
# else
			/* save old stack bases to recalculate pointers */
			YYSTYPE * yyv_old = yyv;
			int * yys_old = yys;
			yymaxdepth += YYINCREMENT;
			yys = (int *) realloc(yys, yymaxdepth * sizeof(int));
			yyv = (YYSTYPE *) realloc(yyv, yymaxdepth * sizeof(YYSTYPE));
			if (yys==0 || yyv==0) {
			    yyerror( (nl_msg(30002,"yacc stack overflow")) );
			    YYABORT;
			    }
			/* Reset pointers into stack */
			yy_ps = (yy_ps - yys_old) + yys;
			yyps = (yyps - yys_old) + yys;
			yy_pv = (yy_pv - yyv_old) + yyv;
			yypv = (yypv - yyv_old) + yyv;
# endif

		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yytmp = yychar < 0;
#endif
		if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
			yychar = 0;		/* reached EOF */
#if YYDEBUG
		if ( yydebug && yytmp )
		{
			register int yy_i;

			printf( "Received token " );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto yydefault;
		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--;
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
#if YYDEBUG
			yytmp = yychar < 0;
#endif
			if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
				yychar = 0;		/* reached EOF */
#if YYDEBUG
			if ( yydebug && yytmp )
			{
				register int yy_i;

				printf( "Received token " );
				if ( yychar == 0 )
					printf( "end-of-file\n" );
				else if ( yychar < 0 )
					printf( "-none-\n" );
				else
				{
					for ( yy_i = 0;
						yytoks[yy_i].t_val >= 0;
						yy_i++ )
					{
						if ( yytoks[yy_i].t_val
							== yychar )
						{
							break;
						}
					}
					printf( "%s\n", yytoks[yy_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
				yyerror( (nl_msg(30003,"syntax error")) );
				yynerrs++;
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
				yynerrs++;
			skip_init:
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yydebug )
						printf( _POP_, *yy_ps,
							yy_ps[-1] );
#	undef _POP_
#endif
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yydebug )
				{
					register int yy_i;

					printf( "Error recovery discards " );
					if ( yychar == 0 )
						printf( "token end-of-file\n" );
					else if ( yychar < 0 )
						printf( "token -none-\n" );
					else
					{
						for ( yy_i = 0;
							yytoks[yy_i].t_val >= 0;
							yy_i++ )
						{
							if ( yytoks[yy_i].t_val
								== yychar )
							{
								break;
							}
						}
						printf( "token %s\n",
							yytoks[yy_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yydebug )
			printf( "Reduce by (%d) \"%s\"\n",
				yy_n, yyreds[ yy_n ] );
#endif
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( yytmp )
	{
		
case 2:
# line 129 "spipar.y"
{
		    behind_header = 1;

		    strcpy (topcell, yypvt[-0].sval);

		    /*
		    fprintf (stderr, "topcell %s\n", topcell);
		    */
		} break;
case 8:
# line 150 "spipar.y"
{
			if(end_ntw(yypvt[-2].ival, externspec, COMPLETE))
			{
			    sls_error(yylineno-1, sls_errno, NULL); 
			    die();
			}
		} break;
case 9:
# line 160 "spipar.y"
{
			if(end_ntw(yypvt[-2].ival, externspec, COMPLETE))
			{
			    sls_error(yylineno-1, sls_errno, NULL); 
			    die();
			}
		} break;
case 10:
# line 170 "spipar.y"
{

			/*
			fprintf (stderr, "subckt %s\n", $2);
			*/

			if(ntw = (Network *)init_ntw(yypvt[-0].sval, externspec)) {
			    curr_ntw = ntw;
			    yyval.ival = (int) ntw;
			}
			else
			{
			    sls_errno = NTWAREF;
			    sls_error(yylineno, sls_errno, yypvt[-0].sval);
			    die();
			}
		} break;
case 11:
# line 188 "spipar.y"
{
			int i;

			yyval.ival = (int)ntw;

			if (yypvt[-1].ival && globNets_cnt > 0) {
			    pnetq = NULL;
			    for (i = 0; i < globNets_cnt; i++) {

				if (!(pnet = sym_dict->fetch(globNets[i]))) {

                                    /* add net 'globNets[i]' as an extra
				       terminal to the current network */

                                    if (!pnetq) {
					pnetq = new Queue (QueueType);
				    }

				    xs -> reset ();
				    pnet = new Netelem (globNets[i], 
							stackcpy((Stack *) xs),
							TermType);
				    pnet -> type = pnet -> type | N_GLOBADDED;
				    pnetq -> put ((Link *) pnet);
				    pnet = new Netelem (globNets[i], 
							stackcpy((Stack *) xs),
							TermType);
				    pnet -> type = pnet -> type | N_GLOBADDED;
				    sym_dict->store (pnet->name, (char *) pnet);
				    ntw -> netq -> put ((Link *) pnet);
				}
				else if (pnet -> xs) {
				    sls_errno = ILLRANGE;
				    sls_error (yylineno-1, sls_errno, 
							 globNets[i]);
				    yyval.ival = 0;
				    break;
				}
			    }

			    if (pnetq) {
				if(ntw->termq)
				    ntw->termq->append((Queue *) pnetq);
				else
				    ntw -> termq = (Queue *) pnetq;
			    }
			}

			if (yyval.ival) {
			    if (yypvt[-1].ival)
				term_to_db((Queue *) yypvt[-1].ival);
			}
		} break;
case 12:
# line 244 "spipar.y"
{

			/*
			fprintf (stderr, "ckt %s\n", topcell);
			*/

			if(ntw = (Network *)init_ntw(topcell, externspec)) {
			    curr_ntw = ntw;
			    yyval.ival = (int) ntw;
			}
			else
			{
			    sls_errno = NTWAREF;
			    sls_error(yylineno, sls_errno, topcell);
			    die();
			}
		} break;
case 15:
# line 270 "spipar.y"
{
		    behind_header = 0;
		} break;
case 16:
# line 276 "spipar.y"
{
			if(yypvt[-0].ival)
			{
			    if(ntw->termq)
				ntw->termq->append((Queue *) yypvt[-0].ival);
			    else
			    	ntw -> termq = (Queue *) yypvt[-0].ival;
			    yyval.ival = (int) yypvt[-0].ival;
			}
			else {
			    yyval.ival = 0;
			}
		} break;
case 17:
# line 292 "spipar.y"
{
			if (yypvt[-0].ival) {
			    pnetq = new Queue (QueueType);
			    pnetq->put((Link *) yypvt[-0].ival);
			    yyval.ival = (int) pnetq;
			}
                        else
			    yyval.ival = 0;
		} break;
case 18:
# line 302 "spipar.y"
{
			if (yypvt[-1].ival && yypvt[-0].ival)
			    ((Queue *) yypvt[-1].ival)->put((Link *) yypvt[-0].ival);
			yyval.ival = yypvt[-1].ival;
		} break;
case 19:
# line 310 "spipar.y"
{
			xs->reset();

			if(sym_dict->fetch(yypvt[-0].sval))
			{
			    sls_errno = TERMADEF;
			    sls_error(yylineno, sls_errno, yypvt[-0].sval);
			    yyval.ival = 0;
			}
			else
			{
			    pnet = new Netelem (yypvt[-0].sval, stackcpy((Stack *) xs),
				       		TermType);
			    yyval.ival = (int) pnet;
			    pnet = new Netelem (yypvt[-0].sval, stackcpy((Stack *) xs),
						TermType);
			    sym_dict->store(pnet->name, (char *) pnet);
			    ntw -> netq -> put ((Link *) pnet);
			}
		} break;
case 22:
# line 337 "spipar.y"
{
			if(inst && curr_inst_type)
			{
			    if(ntw->mcq == NULL)
				ntw -> mcq = new Queue (QueueType);
			    
			    ntw -> mcq -> put ((Link *) inst);
			    inst_to_db((NetworkInstance *) inst);
			}
		} break;
case 25:
# line 350 "spipar.y"
{
		    	if(resynch(';'))
			{
		    	    yyerrok;
		    	    yyclearin;
			}
			else
			    die();
		} break;
case 26:
# line 362 "spipar.y"
{
		    if (yypvt[-0].dval < 1.0e-9 && yypvt[-0].dval > -1.0e-9) {
			if (neteqv((Queue *) yypvt[-1].ival)) {
			    sls_error(yylineno, sls_errno, NULL);
			}
		    }
		} break;
case 27:
# line 370 "spipar.y"
{
		    if (yypvt[-0].dval < 1.1e-3 && yypvt[-0].dval > -1.1e-3) {
			if (neteqv((Queue *) yypvt[-1].ival)) {
			    sls_error(yylineno, sls_errno, NULL);
			}
		    }
		    else if (!noWarnings) {
			fprintf (stderr, "Warning: card 'rnetxxx' skipped\n");
		    }
		} break;
case 28:
# line 381 "spipar.y"
{
		    if (neteqv((Queue *) yypvt[-0].ival)) {
			sls_error(yylineno, sls_errno, NULL);
		    }
		} break;
case 35:
# line 399 "spipar.y"
{
		    int net_cnt;
		    int inst_cnt;
		    int dev;
		    Stack * inst_xs;

		    /*
		    fprintf (stderr, "instance %s %s\n", 
			     ((InstanceStruct *)$1)->inst_name, $3);
		    */

		    if (yypvt[-3].ival && yypvt[-2].ival) {
			if (yypvt[-1].sval == NULL) 
			    yyerror (NULL);
			if ((pntw = (Network *) ntw_dict -> fetch(yypvt[-1].sval)) 
								   == NULL)
			{
			    if ((pntw = read_ntw (yypvt[-1].sval)) == NULL)
			    {
				sls_errno = UNKNETWORK;
				sls_error(yylineno-1, sls_errno, yypvt[-1].sval);
				die();
			    }
			}

			yyval.ival = (int) new NetworkInstance(pntw, NULL);

			((Link *)yyval.ival) -> type = curr_inst_type;

			inst = (NetworkInstance *) yyval.ival;

			inst->inst_struct = (InstanceStruct *) yypvt[-3].ival;
			sym_dict->store(inst->inst_struct->inst_name,
					(char *) inst);

                        /* set n_*_cnt for possibly adding extra global nets 
			   in match_net() */

			inst_xs = inst -> inst_struct -> inst_construct;
			if(inst_xs)
			    n_inst_cnt = getxslength (inst_xs);
			else
			    n_inst_cnt = 1;
			n_net_cnt = getnetcnt((Queue *) yypvt[-2].ival);
			n_term_cnt = gettermcnt (inst -> ntw);
			if (n_net_cnt % n_inst_cnt != 0)
			    n_inst_cnt = 0;

			inst -> ntw_attr = stackcpy(attr_s);
			if(inst_net_eqv(inst, (Queue *) yypvt[-2].ival))
			{
			    sls_error(yylineno-1, sls_errno, NULL);
			}
			n_inst_cnt = 0;
		    }
		} break;
case 36:
# line 458 "spipar.y"
{
		    int net_cnt;
		    int inst_cnt;
		    int dev;
		    Stack * inst_xs;

		    /*
		    fprintf (stderr, "instance %s %s\n", 
			     ((InstanceStruct *)$1)->inst_name, $3);
		    */

		    if (yypvt[-3].ival && yypvt[-2].ival) {
			if (yypvt[-1].sval == NULL) 
			    yyerror (NULL);
			if ((pntw = read_ntw (yypvt[-1].sval)) == NULL) {

			    /* if the transistor is not defined in the database,
			       it must be a predefined transistor.
			    */

			    if (strcmp (yypvt[-1].sval, "nenh") == 0) dev = DevNenh;
			    else if (strcmp (yypvt[-1].sval, "penh") == 0) dev = DevPenh;
			    else if (strcmp (yypvt[-1].sval, "ndep") == 0) dev = DevNdep;
			    else {
				sls_errno = UNKDEVICE;
				sls_error(yylineno-1, sls_errno, yypvt[-1].sval);
				die();
			    }
			    pntw = dev_tab[dev];
			}
			yyval.ival = (int) new NetworkInstance(pntw, NULL);

			((Link *)yyval.ival) -> type = curr_inst_type;

			inst = (NetworkInstance *) yyval.ival;

			inst->inst_struct = (InstanceStruct *) yypvt[-3].ival;
			sym_dict->store(inst->inst_struct->inst_name,
					(char *) inst);

			n_inst_cnt = 0;

			inst -> ntw_attr = stackcpy(attr_s);
			if(inst_net_eqv(inst, (Queue *) yypvt[-2].ival))
			{
			    sls_error(yylineno-1, sls_errno, NULL);
			}
			n_inst_cnt = 0;
		    }
		} break;
case 37:
# line 511 "spipar.y"
{
		    int net_cnt;
		    int inst_cnt;
		    int dev;
		    Stack * inst_xs;

		    /*
		    fprintf (stderr, "instance %s %s\n", 
			     ((InstanceStruct *)$1)->inst_name, $3);
		    */

		    if (yypvt[-3].ival && yypvt[-2].ival) {
			yyval.ival = (int) new NetworkInstance(dev_tab[DevRes], NULL);

			((Link *)yyval.ival) -> type = curr_inst_type;

			inst = (NetworkInstance *) yyval.ival;

			inst->inst_struct = (InstanceStruct *) yypvt[-3].ival;
			sym_dict->store(inst->inst_struct->inst_name,
					(char *) inst);

			n_inst_cnt = 0;

			inst -> ntw_attr = stackcpy(attr_s);
			if(inst_net_eqv(inst, (Queue *) yypvt[-2].ival))
			{
			    sls_error(yylineno-1, sls_errno, NULL);
			}
			n_inst_cnt = 0;
		    }
		} break;
case 38:
# line 546 "spipar.y"
{
		    int net_cnt;
		    int inst_cnt;
		    int dev;
		    Stack * inst_xs;

		    /*
		    fprintf (stderr, "instance %s %s\n", 
			     ((InstanceStruct *)$1)->inst_name, $3);
		    */

		    if (yypvt[-3].ival && yypvt[-2].ival) {
			yyval.ival = (int) new NetworkInstance(dev_tab[DevCap], NULL);

			((Link *)yyval.ival) -> type = curr_inst_type;

			inst = (NetworkInstance *) yyval.ival;

			inst->inst_struct = (InstanceStruct *) yypvt[-3].ival;
			sym_dict->store(inst->inst_struct->inst_name,
					(char *) inst);

			n_inst_cnt = 0;

			inst -> ntw_attr = stackcpy(attr_s);
			if(inst_net_eqv(inst, (Queue *) yypvt[-2].ival))
			{
			    sls_error(yylineno-1, sls_errno, NULL);
			}
			n_inst_cnt = 0;
		    }
		} break;
case 40:
# line 584 "spipar.y"
{
			curr_inst_type = NetworkType;

			xs->reset();

                        if(sym_dict->fetch(yytext))
                        {
                            sls_errno = INSTADEF;
                            sls_error(yylineno, sls_errno, yytext);
                            yyval.ival = 0;
                        }
                        else
                        {
                            yyval.ival = (int) new InstanceStruct (strsav(yytext),
                                           stackcpy((Stack *) xs));
                        }
                } break;
case 41:
# line 604 "spipar.y"
{
			curr_inst_type = TransistorType;

			xs->reset();

                        if(sym_dict->fetch(yytext))
                        {
                            sls_errno = INSTADEF;
                            sls_error(yylineno, sls_errno, yytext);
                            yyval.ival = 0;
                        }
                        else
                        {
                            yyval.ival = (int) new InstanceStruct (strsav(yytext),
                                           stackcpy((Stack *) xs));
                        }
                } break;
case 42:
# line 624 "spipar.y"
{
			curr_inst_type = ResistorType;

			xs->reset();

                        if(sym_dict->fetch(yytext))
                        {
                            sls_errno = INSTADEF;
                            sls_error(yylineno, sls_errno, yytext);
                            yyval.ival = 0;
                        }
                        else
                        {
                            yyval.ival = (int) new InstanceStruct (strsav(yytext),
                                           stackcpy((Stack *) xs));
                        }
                } break;
case 43:
# line 644 "spipar.y"
{
			curr_inst_type = CapacitorType;

			xs->reset();

                        if(sym_dict->fetch(yytext))
                        {
                            sls_errno = INSTADEF;
                            sls_error(yylineno, sls_errno, yytext);
                            yyval.ival = 0;
                        }
                        else
                        {
                            yyval.ival = (int) new InstanceStruct (strsav(yytext),
                                           stackcpy((Stack *) xs));
                        }
                } break;
case 44:
# line 664 "spipar.y"
{
			curr_inst_type = 0;
			yyval.ival = 0;
		} break;
case 45:
# line 671 "spipar.y"
{
			attr_s->reset();
			yyval.ival = (int) attr_s;
		} break;
case 46:
# line 676 "spipar.y"
{
			((Stack *) yypvt[-1].ival) -> push((char *) strsav(yypvt[-0].sval) );
			yyval.ival = yypvt[-1].ival;
		} break;
case 47:
# line 683 "spipar.y"
{
			attr_s->reset();
		    	sprintf(attr_buf, "v=%g", yypvt[-0].dval);
			attr_s -> push(strsav(attr_buf));

			yyval.ival = (int) attr_s;
		} break;
case 48:
# line 693 "spipar.y"
{
		    	sprintf(attr_buf, "%s=%g", yypvt[-2].sval, yypvt[-0].dval);
			yyval.sval = attr_buf;
		} break;
case 49:
# line 700 "spipar.y"
{
			yyval.sval = "w";
		} break;
case 50:
# line 704 "spipar.y"
{
			yyval.sval = "l";
		} break;
case 51:
# line 710 "spipar.y"
{
			yyval.dval = yypvt[-0].dval;
		} break;
case 52:
# line 716 "spipar.y"
{
			yyval.dval = (double) yypvt[-0].ival;
		} break;
case 53:
# line 720 "spipar.y"
{
			yyval.dval = yypvt[-0].dval;
		} break;
case 54:
# line 726 "spipar.y"
{
			yyval.dval = cvt_atof(yypvt[-0].sval);
		} break;
case 55:
# line 732 "spipar.y"
{
		    pnetq = new Queue (QueueType);

		    if(yypvt[-1].ival) {
			pnetq->put((Link *) yypvt[-1].ival);
		    }

		    if(yypvt[-0].ival) {
			pnetq->put((Link *) yypvt[-0].ival);
		    }

		    pnetq -> type = PmQueue;

		    yyval.ival = (int) pnetq;
		} break;
case 56:
# line 750 "spipar.y"
{
		    pnetq = new Queue (QueueType);

		    if(yypvt[-3].ival) {
			pnetq->put((Link *) yypvt[-3].ival);
		    }

		    if(yypvt[-2].ival) {
			pnetq->put((Link *) yypvt[-2].ival);
		    }

		    if(yypvt[-1].ival) {
			pnetq->put((Link *) yypvt[-1].ival);
		    }

		    if(yypvt[-0].ival) {
			pnetq->put((Link *) yypvt[-0].ival);
		    }

		    pnetq -> type = PmQueue;

		    yyval.ival = (int) pnetq;
		} break;
case 57:
# line 776 "spipar.y"
{
		    pnetq = new Queue (QueueType);

		    if(yypvt[-0].ival)
		    {
			pnetq->put((Link *) yypvt[-0].ival);
		    }

		    yyval.ival = (int) pnetq;

		    pnetq -> type = PmQueue;
		} break;
case 58:
# line 789 "spipar.y"
{
		    if(yypvt[-0].ival)
		    {
			((Queue *) yypvt[-1].ival)->put((Link *) yypvt[-0].ival);
		    }

		    yyval.ival = yypvt[-1].ival;
		} break;
case 59:
# line 800 "spipar.y"
{
			/* If net yet not defined, a new net will be defined
			   and stored in the symbol table and put in the
			   network net queue. Additionally a net reference
			   is defined and returned by this action	    */

			/*
			fprintf (stderr, "net_ref: %s\n", $1);
			*/

			if((pnet = sym_dict->fetch(yypvt[-0].sval)) == NULL)
			{
			    pnet = new Netelem (yypvt[-0].sval, NULL, NetType);
			    sym_dict->store(pnet->name, (char *) pnet);
			    ntw -> netq -> put((Link*) pnet);
			}
			yyval.ival = (int) new NetReference (pnet,NULL);
		} break;
case 60:
# line 821 "spipar.y"
{
			strcpy (net_buf, yytext);
			yyval.sval = net_buf;
		} break;
case 61:
# line 826 "spipar.y"
{
			strcpy (net_buf, yypvt[-0].sval);
			yyval.sval = net_buf;
		} break;
case 62:
# line 833 "spipar.y"
{
		    yyval.sval = 0;
		} break;
case 63:
# line 837 "spipar.y"
{
		    yyval.sval = yypvt[-0].sval;
		} break;
case 64:
# line 843 "spipar.y"
{
			strcpy (ntw_name, yypvt[-0].sval);
			yyval.sval = ntw_name;
		} break;
case 65:
# line 850 "spipar.y"
{
			strcpy (net_buf, yytext);
			yyval.sval = net_buf;
		} break;
case 66:
# line 855 "spipar.y"
{
			strcpy (net_buf, yypvt[-0].sval);
			yyval.sval = net_buf;
		} break;
case 83:
# line 882 "spipar.y"
{
			strcpy (name_buf, yypvt[-0].sval);

			if (dmTestname (name_buf) == 1) {
			    if (!trunc_warn && !noWarnings) {
			        fprintf (stderr, 
			        "Warning: name(s) truncated to %d characters\n",
			        DM_MAXNAME);
			        trunc_warn = 1;
			    }
			}
			yyval.sval = name_buf;
		} break;
case 84:
# line 898 "spipar.y"
{
		    yyval.ival = atoi(yypvt[-0].sval);
		} break;
	}
	goto yystack;		/* reset registers in driver code */
}

# ifdef __RUNTIME_YYMAXDEPTH

static int allocate_stacks() {
	/* allocate the yys and yyv stacks */
	yys = (int *) malloc(yymaxdepth * sizeof(int));
	yyv = (YYSTYPE *) malloc(yymaxdepth * sizeof(YYSTYPE));

	if (yys==0 || yyv==0) {
	   yyerror( (nl_msg(30004,"unable to allocate space for yacc stacks")) );
	   return(1);
	   }
	else return(0);

}


static void free_stacks() {
	if (yys!=0) free((char *) yys);
	if (yyv!=0) free((char *) yyv);
}

# endif  /* defined(__RUNTIME_YYMAXDEPTH) */

