/* SccsId = "@(#)sys_incl.h 4.3 (TU-Delft) 07/27/92" */
/**********************************************************

Name/Version      : sls_mkdb/4.3

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.C. de Graaf
Creation date     : 10-Jul-1986
Modified by       : S. de Graaf
Modification date : 10-Jul-1986


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1986 , All rights reserved
**********************************************************/
#ifndef NOSYSINCL
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <ctype.h>
#ifdef SYSV
#include <fcntl.h>
#else
#include <sys/file.h>
#endif
#include "dmincl.h"
#ifndef NCF_RELEASE
#define NCF_RELEASE 300
#endif
#endif

#line 1 "spipar.cls"

#line 7 "spipar.cls"

#line 2 "spipar.y"

#line 1 "./sys_incl.h"

#line 41 "./sys_incl.h"

#line 37 "spipar.cls"

#line 1 "./class.h"

#line 1 "./odb.h"
/* <<cpre-2/8/82>> */ 
#line 31 "./class.h"
typedef struct datum 
{ 
char * dptr ; 
int dsize ; 
} datum ; 

typedef struct db_files { 
char * dbname ; 
int DbRdOnly ; 
int DirF , dir_b , dir_t ; 
int PagF , pag_b , pag_t ; 

long bitno ; 
long maxbno ; 
long blkno ; 
long hmask ; 

char pagbuf [ 1024 ] ; 
char dirbuf [ 1024 ] ; 
} DbAcces ; 

DbAcces * dbOpen ( ) ; 
datum dbfetch ( ) ; 
datum makdatum ( ) ; 
datum firstkey ( ) ; 
datum nextkey ( ) ; 
datum firsthash ( ) ; 
long calchash ( ) ; 
long hashinc ( ) ; 
#line 28 "./class.h"

#line 1 "./stack.h"

#line 27 "./stack.h"
struct stack { char * * min ;
char * * top ;
char * * max ;
} ;
extern int _1stack_new ( /* short */ ) ;
extern int _2stack_delete ( ) ;
extern int _13stack_empty ( /* ? */ ) ;
extern int _14stack_push ( /* char * */ ) ;
extern char * _15stack_pop ( ) ;
extern char * _16stack_access ( /* int */ ) ;
extern int _17stack_print ( ) ;
extern int _18stack_reset ( ) ;
extern struct stack * _19stack_copy ( ) ;
extern char * * _20stack_base ( ) ;
extern char * * _21stack_limit ( ) ;
extern int _22stack_length ( ) ;

#line 44 "./stack.h"
; 
#line 29 "./class.h"

#line 1 "./queue.h"

#line 27 "./queue.h"
struct link { struct link * next ;
char type ;
} ;

#line 31 "./queue.h"
;

#line 33 "./queue.h"
struct queue { struct link _Bqueue ;
struct link * tail ;
short n ;
} ;
extern int _1queue_new ( /* char */ ) ;
extern int _2queue_delete ( ) ;
extern int _12queue_reset ( ) ;
extern struct link * _13queue_get ( ) ;
extern int _14queue_put ( /* struct link * */ ) ;
extern short _15queue_length ( ) ;
extern int _16queue_print ( ) ;
extern int _17queue_empty ( ) ;
extern struct link * _18queue_access ( /* int */ ) ;
extern struct link * _19queue_first_elem ( ) ;
extern struct link * _20queue_next_elem ( /* struct link * */ ) ;
extern struct link * _21queue_last_elem ( ) ;
extern int _22queue_append ( /* struct queue * */ ) ;

#line 51 "./queue.h"
; 
#line 30 "./class.h"

#line 1 "./dict.h"

#line 27 "./dict.h"
struct dictionary { struct db_files * db ;
struct datum key ;
struct datum data ;
} ;
extern int _1dictionary_new ( ) ;
extern int _2dictionary_delete ( ) ;
extern int _13dictionary_store ( /* char * , char * */ ) ;
extern char * _14dictionary_fetch ( /* char * */ ) ;
extern int _15dictionary_print ( /* ? */ ) ;

#line 37 "./dict.h"
; 
#line 31 "./class.h"

typedef struct dictionary Dictionary ; 
typedef struct stack Stack ; 
typedef struct queue Queue ; 
typedef struct link Link ; 
#line 1 "./ntwdefs.h"

#line 27 "./ntwdefs.h"
struct ntwdef { int inst_gen_cnt ;
int net_gen_cnt ;
char * ntw_name ;
int local ;
struct queue * termq ;
struct queue * orig_termq ;
struct queue * mcq ;
struct queue * netq ;
} ;
extern int _1ntwdef_new ( /* char * */ ) ;
extern int _2ntwdef_delete ( ) ;
extern char * _12ntwdef_genname ( /* char */ ) ;

#line 40 "./ntwdefs.h"
;

#line 42 "./ntwdefs.h"
struct instancestruct { char * inst_name ;
struct stack * inst_construct ;
int termCnt ;
struct netMember * nmem ;
} ;
extern int _1instancestruct_new ( /* char * , struct stack * */ ) ;
extern int _2instancestruct_delete ( ) ;

#line 50 "./ntwdefs.h"
;

#line 52 "./ntwdefs.h"
struct ntwinst { struct link _Bntwinst ;
struct ntwdef * ntw ;
struct stack * ntw_attr ;
struct instancestruct * inst_struct ;
} ;
extern int _1ntwinst_new ( /* struct ntwdef * , struct stack * */ ) ;
extern int _2ntwinst_delete ( ) ;
extern int _13ntwinst_to_db ( ) ;

#line 60 "./ntwdefs.h"
; 


typedef struct ntwdef Network ; 
typedef struct ntwinst NetworkInstance ; 
typedef struct instancestruct InstanceStruct ; 
#line 38 "./class.h"

#line 1 "./xelem.h"

#line 27 "./xelem.h"
struct xelem { short left_bound ;
short right_bound ;
} ;
extern int _1xelem_new ( /* short , short */ ) ;
extern int _2xelem_delete ( ) ;
extern int _12xelem_print ( /* ? */ ) ;

#line 34 "./xelem.h"
; 
#line 39 "./class.h"

#line 1 "./netelem.h"

#line 31 "./netelem.h"
struct simpleNet { struct netMember * nmem ;
struct simpleNet * next ;
struct simpleNet * prev ;
} ;

#line 36 "./netelem.h"
;

#line 49 "./ntwdefs.h"
struct netMember { struct ntwinst * inst ;
struct netelem * net ;
struct netMember * next ;
struct simpleNet * snet ;
} ;

#line 44 "./netelem.h"
;

#line 41 "./netelem.h"
struct netelem { struct link _Bnetelem ;
char * name ;
int type ;
struct stack * xs ;
struct queue * eqv ;
struct netMember * nmem ;
} ;
extern int _1netelem_new ( /* char * , struct stack * , char */ ) ;
extern int _2netelem_delete ( ) ;
extern int _15netelem_print ( /* ? */ ) ;
extern int _16netelem_to_db ( /* ? */ ) ;

#line 57 "./netelem.h"
;

#line 59 "./netelem.h"
struct net_ref { struct link _Bnet_ref ;
struct netelem * net ;
struct stack * net_xs ;
struct ntwinst * inst ;
struct stack * inst_xs ;
struct stack * ref_xs ;
} ;
extern int _1net_ref_new ( /* struct netelem * , struct stack * */ ) ;
extern int _2net_ref_delete ( ) ;

#line 68 "./netelem.h"
; 

typedef struct netMember Nmem ; 
#line 40 "./class.h"

typedef struct xelem Xelem ; 
typedef struct netelem Netelem ; 
typedef struct net_ref NetReference ; 
#line 39 "spipar.cls"

#line 1 "./mkdbdefs.h"

#line 1 "./slserr.h"

#line 30 "./mkdbdefs.h"

#line 40 "spipar.cls"

#line 1 "./mkdbincl.h"

#line 27 "spipar.cls"
extern int doSimpleNet ; 
extern int genIntNet ; 
extern int externRequired ; 
extern int forbidFirstCapital ; 
extern int noWarnings ; 
extern int sls_errcnt ; 
extern int sls_errno ; 
extern int sls_nerr ; 
extern char * sls_errlist [ ] ; 

extern int yylineno ; 
extern char fn_incl [ ] ; 

extern int int_nbyte , int_maxnbyte ; 
extern int char_nbyte , char_maxnbyte ; 
extern int ntwdef_nbyte , ntwdef_maxnbyte ; 
extern int ntwinst_nbyte , ntwinst_maxnbyte ; 
extern int inst_struct_nbyte , inst_struct_maxnbyte ; 
extern int netelem_nbyte , netelem_maxnbyte ; 
extern int dict_nbyte , dict_maxnbyte ; 
extern int net_ref_nbyte , net_ref_maxnbyte ; 
extern int xelem_nbyte , xelem_maxnbyte ; 
extern int queue_nbyte , queue_maxnbyte ; 
extern int stack_nbyte , stack_maxnbyte ; 
#line 41 "spipar.cls"

extern char yytext [ ] ; 
extern Netelem * notconnected ; 

int resynch ( ) ; 
char * strsav ( ) ; 
double cvt_atof ( ) ; 
Stack * stackcpy ( ) ; 
Stack * xstackcpy ( ) ; 
Network * init_ntw ( ) ; 
Network * read_ntw ( ) ; 
Network * dev_tab [ ] ; 

int n_net_cnt ; 
int n_inst_cnt = 0 ; 
int n_term_cnt ; 

Stack * xs , * pxs ; 
Stack * attr_s ; 
Queue * pq ; 
Queue * netq ; 
Queue * pnetq ; 
extern Dictionary * ntw_dict ; 
extern Dictionary * sym_dict ; 
extern Dictionary * dff_dict ; 

extern char * * globNets ; 
extern int globNets_cnt ; 

Xelem * pxelem ; 
Netelem * pnet ; 
Network * ntw ; 
Network * pntw ; 
NetReference * pnref ; 
NetworkInstance * inst ; 

char name_buf [ BUFSIZ ] ; 
char net_buf [ BUFSIZ ] ; 
char ntw_name [ BUFSIZ ] ; 
char topcell [ BUFSIZ ] ; 
char attr_buf [ BUFSIZ ] ; 

int trunc_warn = 0 ; 
int externspec = 0 ; 
Network * curr_ntw ; 
int curr_inst_type ; 

char mc_type = 'i' ; 


int behind_header = 0 ; 
#line 88 "spipar.y"
typedef union { 
int ival ; 
char * sval ; 
char cval ; 
int * pival ; 
float fval ; 
double dval ; 
} YYSTYPE ; 
#line 120 "spipar.y"
extern int yychar ; 
#line 136 "spipar.y"
YYSTYPE yylval ; 
static YYSTYPE yyval ; 
typedef int yytabelem ; 
#line 908 "spipar.y"


int yyerror ( s ) char * s ; 

{ int * _that ; 
sls_error ( yylineno , 6 , 0 ) ; } /* yyerror */ 


int resynch ( c ) char c ; 

{ int * _that ; int _result ; 
int c1 , 
newline = 0 ; 

fprintf ( stderr , " \"" ) ; 
if ( yytext ) 
fprintf ( stderr , "%s" , yytext ) ; 
while ( ( c1 = Input ( ) ) != c && c1 != 0 ) 
{ 
if ( ! ( newline = ( newline || ( ( c1 == '\n' ) ? 1 : 0 ) ) ) ) 
fprintf ( stderr , "%c" , c1 ) ; } 


fprintf ( stderr , "\"\n" ) ; { _result = 

 ( c1 ) ; goto _return ; } _return : return _result ; } /* resynch */ 


int stackfree ( xs , type ) struct stack * xs ; int type ; 


{ int * _that ; 
char * p ; 

if ( xs ) 
{ 
while ( ! _13stack_empty ( ( struct stack * ) xs ) ) 
{ 
 p = _15stack_pop ( ( struct stack * ) xs ) ; 
switch ( type ) { 
case 0 : 
if ( p ) { _that = ( int * ) 
 ( struct xelem * ) p ; _2xelem_delete ( ( struct xelem * ) _that ) ; free ( _that ) ; } 
break ; 
case 1 : 
if ( p ) 
{ 
#line 199 "spipar.cls"
{ _that = ( int * ) 
 p ; free ( _that ) ; } } 

break ; } } } } /* stackfree */ 
#line 208 "spipar.cls"
Netelem * findterm ( inst , term_name ) struct ntwinst * inst ; char * term_name ; 


{ int * _that ; struct netelem * _result ; 
Queue * termq ; 
int termq_len ; 
Netelem * pterm ; 
int i ; 

if ( inst ) 
 termq = ( struct queue * ) ( inst -> ntw -> termq ) ; 
else 
 termq = ( struct queue * ) ( ntw -> termq ) ; 

 termq_len = _15queue_length ( ( struct queue * ) termq ) ; 

for ( i = 0 , pterm = ( struct netelem * ) _19queue_first_elem ( ( struct queue * ) termq ) ; 
i < termq_len ; 
 i ++ , pterm = ( struct netelem * ) _20queue_next_elem ( ( struct queue * ) termq , ( struct link * ) ( ( struct link * ) pterm ) ) ) 
{ 
if ( strcmp ( pterm -> name , term_name ) == 0 ) { _result = 
 ( pterm ) ; goto _return ; } } { _result = 


 ( 0 ) ; goto _return ; } _return : return _result ; } /* findterm */ 


int gettermcnt ( netw ) struct ntwdef * netw ; 

{ int * _that ; int _result ; 
Queue * termq ; 
int termq_len ; 
Netelem * pterm ; 
int i ; 
int term_cnt ; 

 termq = ( struct queue * ) ( netw -> termq ) ; 
 termq_len = _15queue_length ( ( struct queue * ) termq ) ; 
term_cnt = 0 ; 

for ( i = 0 , pterm = ( struct netelem * ) _19queue_first_elem ( ( struct queue * ) termq ) ; 
i < termq_len ; 
 i ++ , pterm = ( struct netelem * ) _20queue_next_elem ( ( struct queue * ) termq , ( struct link * ) ( ( struct link * ) pterm ) ) ) 
{ 
 term_cnt += getxslength ( pterm -> xs ) ; } { _result = 


 ( term_cnt ) ; goto _return ; } _return : return _result ; } /* gettermcnt */ 


int prxs ( xs ) struct stack * xs ; 

{ int * _that ; 

int i ; 
int xs_len = _22stack_length ( ( struct stack * ) xs ) ; 

fprintf ( stderr , "stack: %x, length: %d\n" , xs , xs_len ) ; 
if ( xs ) 
{ 
for ( i = 0 ; i < xs_len ; i ++ ) 
{ 
 pxelem = ( struct xelem * ) _16stack_access ( ( struct stack * ) xs , ( int ) ( i ) ) ; 
fprintf ( stderr , "lb: %d, rb: %d\n" , pxelem -> left_bound , 
 pxelem -> right_bound ) ; } } } /* prxs */ 



static yytabelem yyexca [ ] = { 
- 1 , 1 , 
0 , - 1 , 
- 2 , 0 , 
- 1 , 16 , 
267 , 13 , 
268 , 13 , 
- 2 , 0 , 
- 1 , 101 , 
257 , 61 , 
258 , 61 , 
- 2 , 45 , 
} ; 


static yytabelem yyact [ ] = { 

52 , 53 , 54 , 92 , 51 , 8 , 122 , 63 , 64 , 55 , 
56 , 57 , 58 , 21 , 8 , 47 , 59 , 60 , 61 , 62 , 
65 , 51 , 52 , 53 , 54 , 6 , 119 , 120 , 115 , 63 , 
64 , 55 , 56 , 57 , 58 , 13 , 73 , 8 , 59 , 60 , 
61 , 62 , 65 , 26 , 71 , 8 , 114 , 42 , 41 , 44 , 
43 , 97 , 111 , 98 , 90 , 8 , 35 , 32 , 33 , 34 , 
74 , 105 , 88 , 70 , 7 , 19 , 49 , 15 , 50 , 5 , 
25 , 23 , 22 , 16 , 7 , 48 , 20 , 45 , 46 , 10 , 
17 , 79 , 81 , 18 , 14 , 3 , 9 , 66 , 4 , 2 , 
67 , 68 , 69 , 1 , 72 , 89 , 118 , 75 , 76 , 94 , 
117 , 77 , 82 , 83 , 100 , 123 , 84 , 96 , 40 , 91 , 
31 , 39 , 30 , 85 , 38 , 29 , 99 , 37 , 28 , 36 , 
27 , 24 , 11 , 102 , 12 , 95 , 104 , 87 , 78 , 80 , 
86 , 0 , 0 , 93 , 0 , 0 , 0 , 0 , 0 , 101 , 
0 , 103 , 0 , 106 , 106 , 107 , 0 , 0 , 91 , 113 , 
110 , 124 , 108 , 109 , 116 , 0 , 112 , 0 , 121 } ; 
static yytabelem yypact [ ] = { 

- 3000 , - 3000 , - 3000 , - 253 , - 231 , - 3000 , - 3000 , - 3000 , - 3000 , - 3000 , 
- 3000 , - 3000 , - 3000 , - 244 , - 3000 , - 255 , - 213 , - 252 , - 3000 , - 257 , 
- 3000 , - 3000 , - 3000 , - 274 , - 274 , - 274 , - 3000 , - 3000 , - 3000 , - 3000 , 
- 3000 , - 3000 , - 221 , - 221 , - 221 , - 3000 , - 221 , - 221 , - 221 , - 221 , 
- 3000 , - 3000 , - 3000 , - 3000 , - 3000 , - 3000 , - 3000 , - 3000 , - 203 , - 275 , 
- 3000 , - 3000 , - 3000 , - 3000 , - 3000 , - 3000 , - 3000 , - 3000 , - 3000 , - 3000 , 
- 3000 , - 3000 , - 3000 , - 3000 , - 3000 , - 3000 , - 257 , - 275 , - 275 , - 275 , 
- 206 , - 221 , - 3000 , - 3000 , - 3000 , - 206 , - 3000 , - 235 , - 221 , - 3000 , 
- 244 , - 221 , - 244 , - 244 , - 235 , - 257 , - 274 , - 203 , - 3000 , - 3000 , 
- 3000 , - 3000 , - 3000 , - 275 , - 3000 , - 3000 , - 3000 , - 3000 , - 3000 , - 3000 , 
- 3000 , - 3000 , - 3000 , - 3000 , - 221 , - 206 , - 3000 , - 206 , - 275 , - 275 , 
- 3000 , - 238 , - 238 , - 221 , - 3000 , - 3000 , - 3000 , - 3000 , - 268 , - 3000 , 
- 3000 , - 3000 , - 206 , - 3000 , - 3000 } ; 
static yytabelem yypgo [ ] = { 

0 , 130 , 63 , 129 , 128 , 44 , 127 , 62 , 125 , 124 , 
122 , 121 , 120 , 119 , 118 , 117 , 115 , 114 , 112 , 111 , 
110 , 108 , 52 , 46 , 107 , 105 , 28 , 100 , 96 , 61 , 
95 , 94 , 69 , 60 , 93 , 89 , 88 , 86 , 85 , 84 , 
65 , 66 , 79 , 67 , 78 , 76 , 75 , 73 , 72 , 71 , 
70 , 68 } ; 
static yytabelem yyr1 [ ] = { 

0 , 34 , 39 , 35 , 38 , 38 , 36 , 36 , 42 , 37 , 
46 , 9 , 10 , 43 , 44 , 45 , 1 , 6 , 6 , 7 , 
47 , 47 , 48 , 48 , 48 , 48 , 11 , 11 , 11 , 49 , 
49 , 49 , 49 , 49 , 50 , 12 , 14 , 16 , 18 , 20 , 
13 , 15 , 17 , 19 , 21 , 22 , 22 , 23 , 27 , 28 , 
28 , 25 , 26 , 26 , 24 , 2 , 3 , 4 , 4 , 5 , 
31 , 31 , 29 , 29 , 32 , 30 , 30 , 40 , 40 , 51 , 
51 , 51 , 51 , 51 , 51 , 51 , 51 , 51 , 51 , 51 , 
51 , 51 , 51 , 33 , 8 , 41 , 41 } ; 
static yytabelem yyr2 [ ] = { 

0 , 6 , 1 , 10 , 0 , 4 , 0 , 4 , 7 , 7 , 
1 , 11 , 1 , 2 , 6 , 7 , 3 , 3 , 5 , 3 , 
0 , 4 , 5 , 4 , 4 , 3 , 7 , 7 , 5 , 2 , 
2 , 2 , 2 , 2 , 4 , 9 , 9 , 9 , 9 , 4 , 
3 , 3 , 3 , 3 , 3 , 1 , 5 , 3 , 7 , 3 , 
3 , 3 , 3 , 3 , 3 , 5 , 9 , 3 , 5 , 3 , 
3 , 3 , 1 , 3 , 3 , 3 , 3 , 0 , 4 , 2 , 
2 , 2 , 2 , 2 , 2 , 2 , 2 , 2 , 2 , 2 , 
2 , 2 , 2 , 3 , 3 , 2 , 4 } ; 
static yytabelem yychk [ ] = { 

- 3000 , - 34 , - 35 , - 38 , - 36 , - 32 , 278 , - 33 , 258 , - 37 , 
- 42 , - 10 , - 9 , 266 , - 39 , - 43 , - 47 , - 43 , - 32 , - 40 , 
- 45 , 268 , - 48 , - 49 , - 11 , - 50 , 256 , - 12 , - 14 , - 16 , 
- 18 , - 20 , 270 , 271 , 272 , 269 , - 13 , - 15 , - 17 , - 19 , 
- 21 , 261 , 260 , 263 , 262 , - 33 , - 44 , 267 , - 46 , - 41 , 
- 51 , 278 , 257 , 258 , 259 , 266 , 267 , 268 , 269 , 273 , 
274 , 275 , 276 , 264 , 265 , 277 , - 40 , - 41 , - 41 , - 41 , 
- 2 , - 5 , - 31 , 257 , - 33 , - 2 , - 2 , - 40 , - 4 , - 5 , 
- 3 , - 5 , - 2 , - 2 , - 40 , - 40 , - 1 , - 6 , - 7 , - 30 , 
257 , - 33 , 278 , - 41 , - 26 , - 8 , - 24 , 257 , 259 , - 5 , 
- 26 , - 33 , - 5 , - 33 , - 5 , - 29 , - 33 , - 29 , - 41 , - 41 , 
- 7 , - 22 , - 22 , - 5 , - 23 , - 26 , - 23 , - 27 , - 28 , 264 , 
265 , - 5 , 274 , - 25 , - 26 } ; 
static yytabelem yydef [ ] = { 

4 , - 2 , 6 , 0 , 12 , 2 , 5 , 64 , 83 , 1 , 
7 , 20 , 20 , 0 , 67 , 0 , - 2 , 0 , 10 , 0 , 
9 , 67 , 21 , 0 , 0 , 0 , 25 , 29 , 30 , 31 , 
32 , 33 , 0 , 0 , 0 , 67 , 0 , 0 , 0 , 0 , 
67 , 40 , 41 , 42 , 43 , 44 , 8 , 67 , 0 , 3 , 
68 , 85 , 69 , 70 , 71 , 72 , 73 , 74 , 75 , 76 , 
77 , 78 , 79 , 80 , 81 , 82 , 0 , 22 , 23 , 24 , 
0 , 0 , 59 , 60 , 61 , 0 , 28 , 34 , 0 , 57 , 
0 , 0 , 62 , 62 , 39 , 0 , 0 , 16 , 17 , 19 , 
65 , 66 , 86 , 15 , 26 , 52 , 53 , 84 , 54 , 55 , 
27 , - 2 , 58 , 45 , 0 , 0 , 63 , 0 , 14 , 11 , 
18 , 35 , 36 , 0 , 37 , 47 , 38 , 46 , 0 , 49 , 
50 , 56 , 0 , 48 , 51 } ; 
typedef struct { char * t_name ; int t_val ; } yytoktype ; 
#line 508 "spipar.cls"

#line 518 "spipar.cls"

#line 535 "spipar.cls"

#line 552 "spipar.cls"

#line 557 "spipar.cls"
int yydebug ; 
#line 569 "spipar.cls"
static YYSTYPE yyv [ 150 ] ; 
static int yys [ 150 ] ; 
#line 588 "spipar.cls"

long yymaxdepth = 150 ; 

static YYSTYPE * yypv ; 
static int * yyps ; 

static int yystate ; 
static int yytmp ; 

int yynerrs ; 
static int yyerrflag ; 
int yychar ; 
#line 606 "spipar.cls"
int yyparse 
( ) 
{ int * _that ; int _result ; 
register YYSTYPE * yypvt ; 
#line 616 "spipar.cls"

yypv = & yyv [ - 1 ] ; 
yyps = & yys [ - 1 ] ; 
yystate = 0 ; 
yytmp = 0 ; 
yynerrs = 0 ; 
yyerrflag = 0 ; 
yychar = - 1 ; 

goto yystack ; 
{ 
register YYSTYPE * yy_pv ; 
register int * yy_ps ; 
register int yy_state ; 
register int yy_n ; 
#line 636 "spipar.cls"
yynewstate : 
yy_pv = yypv ; 
yy_ps = yyps ; 
yy_state = yystate ; 
goto yy_newstate ; 
#line 646 "spipar.cls"
yystack : 
yy_pv = yypv ; 
yy_ps = yyps ; 
yy_state = yystate ; 
#line 654 "spipar.cls"
yy_stack : 
#line 685 "spipar.cls"

if ( ++ yy_ps >= & yys [ yymaxdepth ] ) 
{ 

 yyerror ( ( ( "yacc stack overflow" ) ) ) ; { _result = 
 ( 1 ) ; goto _return ; } 
#line 707 "spipar.cls"
} 


* yy_ps = yy_state ; 
* ++ yy_pv = yyval ; 
#line 716 "spipar.cls"
yy_newstate : 
if ( ( yy_n = yypact [ yy_state ] ) <= ( - 3000 ) ) 
goto yydefault ; 
#line 724 "spipar.cls"

if ( ( yychar < 0 ) && ( ( yychar = yylex ( ) ) < 0 ) ) 
yychar = 0 ; 
#line 748 "spipar.cls"

if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= 159 ) ) 
goto yydefault ; 
if ( yychk [ yy_n = yyact [ yy_n ] ] == yychar ) 
{ 
yychar = - 1 ; 
yyval = yylval ; 
yy_state = yy_n ; 
if ( yyerrflag > 0 ) 
yyerrflag -- ; 
goto yy_stack ; } 


yydefault : 
if ( ( yy_n = yydef [ yy_state ] ) == - 2 ) 
{ 
#line 766 "spipar.cls"

if ( ( yychar < 0 ) && ( ( yychar = yylex ( ) ) < 0 ) ) 
yychar = 0 ; 
#line 794 "spipar.cls"




{ 
register int * yyxi = yyexca ; 

while ( ( * yyxi != - 1 ) || 
( yyxi [ 1 ] != yy_state ) ) 
{ 
yyxi += 2 ; } 

while ( ( * ( yyxi += 2 ) >= 0 ) && 
( * yyxi != yychar ) ) 
; 
if ( ( yy_n = yyxi [ 1 ] ) < 0 ) { _result = 
 ( 0 ) ; goto _return ; } } } 
#line 817 "spipar.cls"
if ( yy_n == 0 ) 
{ 

switch ( yyerrflag ) 
{ 
case 0 : 
 yyerror ( ( ( "syntax error" ) ) ) ; 
yynerrs ++ ; 
goto skip_init ; 
yyerrlab : 
#line 831 "spipar.cls"
yy_pv = yypv ; 
yy_ps = yyps ; 
yy_state = yystate ; 
yynerrs ++ ; 
skip_init : 
case 1 : 
case 2 : 

yyerrflag = 3 ; 
#line 844 "spipar.cls"
while ( yy_ps >= yys ) 
{ 
yy_n = yypact [ * yy_ps ] + 256 ; 
if ( yy_n >= 0 && yy_n < 159 && 
yychk [ yyact [ yy_n ] ] == 256 ) { 



yy_state = yyact [ yy_n ] ; 
goto yy_stack ; 
#line 865 "spipar.cls"
} 
yy_ps -- ; 
yy_pv -- ; } { _result = 
#line 873 "spipar.cls"
 ( 1 ) ; goto _return ; } 
case 3 : 
#line 908 "spipar.cls"

if ( yychar == 0 ) { _result = 
 ( 1 ) ; goto _return ; } 
yychar = - 1 ; 
goto yy_newstate ; } 
#line 928 "spipar.cls"
} 
yytmp = yy_n ; 
yypvt = yy_pv ; 
#line 943 "spipar.cls"
{ 

register int yy_len = yyr2 [ yy_n ] ; 

if ( ! ( yy_len & 01 ) ) 
{ 
yy_len >>= 1 ; 
yyval = ( yy_pv -= yy_len ) [ 1 ] ; 
yy_state = yypgo [ yy_n = yyr1 [ yy_n ] ] + 
* ( yy_ps -= yy_len ) + 1 ; 
if ( yy_state >= 159 || 
yychk [ yy_state = 
yyact [ yy_state ] ] != - yy_n ) 
{ 
yy_state = yyact [ yypgo [ yy_n ] ] ; } 

goto yy_stack ; } 

yy_len >>= 1 ; 
yyval = ( yy_pv -= yy_len ) [ 1 ] ; 
yy_state = yypgo [ yy_n = yyr1 [ yy_n ] ] + 
* ( yy_ps -= yy_len ) + 1 ; 
if ( yy_state >= 159 || 
yychk [ yy_state = yyact [ yy_state ] ] != - yy_n ) 
{ 
yy_state = yyact [ yypgo [ yy_n ] ] ; } } 



yystate = yy_state ; 
yyps = yy_ps ; 
yypv = yy_pv ; } 
#line 979 "spipar.cls"
switch ( yytmp ) 
{ 

case 2 : 
#line 129 "spipar.y"
{ 
behind_header = 1 ; 

strcpy ( topcell , yypvt [ - 0 ] . sval ) ; } 
#line 137 "spipar.y"
break ; 
case 8 : 
#line 150 "spipar.y"
{ 
if ( end_ntw ( yypvt [ - 2 ] . ival , externspec , COMPLETE ) ) 
{ 
sls_error ( yylineno - 1 , sls_errno , 0 ) ; 
die ( ) ; } } 

break ; 
case 9 : 
#line 160 "spipar.y"
{ 
if ( end_ntw ( yypvt [ - 2 ] . ival , externspec , COMPLETE ) ) 
{ 
sls_error ( yylineno - 1 , sls_errno , 0 ) ; 
die ( ) ; } } 

break ; 
case 10 : 
#line 170 "spipar.y"
{ 
#line 176 "spipar.y"
if ( ntw = ( struct ntwdef * ) init_ntw ( yypvt [ - 0 ] . sval , externspec ) ) { 
 curr_ntw = ( struct ntwdef * ) ( ntw ) ; 
 yyval . ival = ( int ) ntw ; } 

else 
{ 
sls_errno = 14 ; 
sls_error ( yylineno , sls_errno , yypvt [ - 0 ] . sval ) ; 
die ( ) ; } } 

break ; 
case 11 : 
#line 188 "spipar.y"
{ 
int i ; 

 yyval . ival = ( int ) ntw ; 

if ( yypvt [ - 1 ] . ival && globNets_cnt > 0 ) { 
 pnetq = ( struct queue * ) ( 0 ) ; 
for ( i = 0 ; i < globNets_cnt ; i ++ ) { 

if ( ! ( pnet = ( struct netelem * ) ( _14dictionary_fetch ( ( struct dictionary * ) sym_dict , ( char * ) ( globNets [ i ] ) ) ) ) ) { 
#line 202 "spipar.y"
if ( ! pnetq ) { 
 pnetq = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct queue ) ) , _1queue_new ( ( struct queue * ) _that , ( char ) ( 0x01 ) ) , ( struct queue * ) _that ) ; } 


 _18stack_reset ( ( struct stack * ) xs ) ; 


 pnet = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct netelem ) ) , _1netelem_new ( ( struct netelem * ) _that , ( char * ) ( globNets [ i ] ) , ( struct stack * ) ( stackcpy ( ( struct stack * ) xs ) ) , ( char ) ( 0x04 ) ) , ( struct netelem * ) _that ) ; 
 pnet -> type = pnet -> type | 2 ; 
 _14queue_put ( ( struct queue * ) pnetq , ( struct link * ) ( ( struct link * ) pnet ) ) ; 


 pnet = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct netelem ) ) , _1netelem_new ( ( struct netelem * ) _that , ( char * ) ( globNets [ i ] ) , ( struct stack * ) ( stackcpy ( ( struct stack * ) xs ) ) , ( char ) ( 0x04 ) ) , ( struct netelem * ) _that ) ; 
 pnet -> type = pnet -> type | 2 ; 
 _13dictionary_store ( ( struct dictionary * ) sym_dict , ( char * ) ( pnet -> name ) , ( char * ) ( ( char * ) pnet ) ) ; 
 _14queue_put ( ( struct queue * ) ntw -> netq , ( struct link * ) ( ( struct link * ) pnet ) ) ; } 

else if ( pnet -> xs ) { 
sls_errno = 7 ; 
sls_error ( yylineno - 1 , sls_errno , 
globNets [ i ] ) ; 
yyval . ival = 0 ; 
break ; } } 



if ( pnetq ) { 
if ( ntw -> termq ) 
 _22queue_append ( ( struct queue * ) ntw -> termq , ( struct queue * ) ( ( struct queue * ) pnetq ) ) ; 
else 
 ntw -> termq = ( struct queue * ) pnetq ; } } 



if ( yyval . ival ) { 
if ( yypvt [ - 1 ] . ival ) 
 term_to_db ( ( struct queue * ) yypvt [ - 1 ] . ival ) ; } } 

break ; 
case 12 : 
#line 244 "spipar.y"
{ 
#line 250 "spipar.y"
if ( ntw = ( struct ntwdef * ) init_ntw ( topcell , externspec ) ) { 
 curr_ntw = ( struct ntwdef * ) ( ntw ) ; 
 yyval . ival = ( int ) ntw ; } 

else 
{ 
sls_errno = 14 ; 
sls_error ( yylineno , sls_errno , topcell ) ; 
die ( ) ; } } 

break ; 
case 15 : 
#line 270 "spipar.y"
{ 
behind_header = 0 ; } 
break ; 
case 16 : 
#line 276 "spipar.y"
{ 
if ( yypvt [ - 0 ] . ival ) 
{ 
if ( ntw -> termq ) 
 _22queue_append ( ( struct queue * ) ntw -> termq , ( struct queue * ) ( ( struct queue * ) yypvt [ - 0 ] . ival ) ) ; 
else 
 ntw -> termq = ( struct queue * ) yypvt [ - 0 ] . ival ; 
yyval . ival = ( int ) yypvt [ - 0 ] . ival ; } 

else { 
yyval . ival = 0 ; } } 

break ; 
case 17 : 
#line 292 "spipar.y"
{ 
if ( yypvt [ - 0 ] . ival ) { 
 pnetq = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct queue ) ) , _1queue_new ( ( struct queue * ) _that , ( char ) ( 0x01 ) ) , ( struct queue * ) _that ) ; 
 _14queue_put ( ( struct queue * ) pnetq , ( struct link * ) ( ( struct link * ) yypvt [ - 0 ] . ival ) ) ; 
 yyval . ival = ( int ) pnetq ; } 

else 
yyval . ival = 0 ; } 
break ; 
case 18 : 
#line 302 "spipar.y"
{ 
if ( yypvt [ - 1 ] . ival && yypvt [ - 0 ] . ival ) 
 _14queue_put ( ( struct queue * ) ( ( struct queue * ) yypvt [ - 1 ] . ival ) , ( struct link * ) ( ( struct link * ) yypvt [ - 0 ] . ival ) ) ; 
yyval . ival = yypvt [ - 1 ] . ival ; } 
break ; 
case 19 : 
#line 310 "spipar.y"
{ 
 _18stack_reset ( ( struct stack * ) xs ) ; 

if ( _14dictionary_fetch ( ( struct dictionary * ) sym_dict , ( char * ) ( yypvt [ - 0 ] . sval ) ) ) 
{ 
sls_errno = 8 ; 
sls_error ( yylineno , sls_errno , yypvt [ - 0 ] . sval ) ; 
yyval . ival = 0 ; } 

else 
{ 

 pnet = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct netelem ) ) , _1netelem_new ( ( struct netelem * ) _that , ( char * ) ( yypvt [ - 0 ] . sval ) , ( struct stack * ) ( stackcpy ( ( struct stack * ) xs ) ) , ( char ) ( 0x04 ) ) , ( struct netelem * ) _that ) ; 
 yyval . ival = ( int ) pnet ; 

 pnet = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct netelem ) ) , _1netelem_new ( ( struct netelem * ) _that , ( char * ) ( yypvt [ - 0 ] . sval ) , ( struct stack * ) ( stackcpy ( ( struct stack * ) xs ) ) , ( char ) ( 0x04 ) ) , ( struct netelem * ) _that ) ; 
 _13dictionary_store ( ( struct dictionary * ) sym_dict , ( char * ) ( pnet -> name ) , ( char * ) ( ( char * ) pnet ) ) ; 
 _14queue_put ( ( struct queue * ) ntw -> netq , ( struct link * ) ( ( struct link * ) pnet ) ) ; } } 

break ; 
case 22 : 
#line 337 "spipar.y"
{ 
if ( inst && curr_inst_type ) 
{ 
if ( ntw -> mcq == 0 ) 
 ntw -> mcq = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct queue ) ) , _1queue_new ( ( struct queue * ) _that , ( char ) ( 0x01 ) ) , ( struct queue * ) _that ) ; 

 _14queue_put ( ( struct queue * ) ntw -> mcq , ( struct link * ) ( ( struct link * ) inst ) ) ; 
 inst_to_db ( ( struct ntwinst * ) inst ) ; } } 

break ; 
case 25 : 
#line 350 "spipar.y"
{ 
if ( resynch ( ( char ) ( ';' ) ) ) 
{ 
yyerrflag = 0 ; 
yychar = - 1 ; } 

else 
die ( ) ; } 
break ; 
case 26 : 
#line 362 "spipar.y"
{ 
if ( yypvt [ - 0 ] . dval < 1.0e-9 && yypvt [ - 0 ] . dval > - 1.0e-9 ) { 
if ( neteqv ( ( struct queue * ) yypvt [ - 1 ] . ival ) ) { 
sls_error ( yylineno , sls_errno , 0 ) ; } } } 


break ; 
case 27 : 
#line 370 "spipar.y"
{ 
if ( yypvt [ - 0 ] . dval < 1.1e-3 && yypvt [ - 0 ] . dval > - 1.1e-3 ) { 
if ( neteqv ( ( struct queue * ) yypvt [ - 1 ] . ival ) ) { 
sls_error ( yylineno , sls_errno , 0 ) ; } } 


else if ( ! noWarnings ) { 
fprintf ( stderr , "Warning: card 'rnetxxx' skipped\n" ) ; } } 

break ; 
case 28 : 
#line 381 "spipar.y"
{ 
if ( neteqv ( ( struct queue * ) yypvt [ - 0 ] . ival ) ) { 
sls_error ( yylineno , sls_errno , 0 ) ; } } 

break ; 
case 35 : 
#line 399 "spipar.y"
{ 
int net_cnt ; 
int inst_cnt ; 
int dev ; 
Stack * inst_xs ; 
#line 410 "spipar.y"
if ( yypvt [ - 3 ] . ival && yypvt [ - 2 ] . ival ) { 
if ( yypvt [ - 1 ] . sval == 0 ) 
 yyerror ( 0 ) ; 
if ( 
 ( pntw = ( struct ntwdef * ) _14dictionary_fetch ( ( struct dictionary * ) ntw_dict , ( char * ) ( yypvt [ - 1 ] . sval ) ) ) == 0 ) 
{ 
if ( ( pntw = ( struct ntwdef * ) ( read_ntw ( yypvt [ - 1 ] . sval ) ) ) == 0 ) 
{ 
sls_errno = 12 ; 
sls_error ( yylineno - 1 , sls_errno , yypvt [ - 1 ] . sval ) ; 
die ( ) ; } } 



yyval . ival = ( int ) ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct ntwinst ) ) , _1ntwinst_new ( ( struct ntwinst * ) _that , ( struct ntwdef * ) ( pntw ) , ( struct stack * ) 0 ) , ( struct ntwinst * ) _that ) ; 

 ( ( struct link * ) yyval . ival ) -> type = curr_inst_type ; 

 inst = ( struct ntwinst * ) yyval . ival ; 

 inst -> inst_struct = ( struct instancestruct * ) yypvt [ - 3 ] . ival ; 

 _13dictionary_store ( ( struct dictionary * ) sym_dict , ( char * ) ( inst -> inst_struct -> inst_name ) , ( char * ) ( ( char * ) inst ) ) ; 
#line 437 "spipar.y"
 inst_xs = ( struct stack * ) ( inst -> inst_struct -> inst_construct ) ; 
if ( inst_xs ) 
 n_inst_cnt = getxslength ( inst_xs ) ; 
else 
n_inst_cnt = 1 ; 
 n_net_cnt = getnetcnt ( ( struct queue * ) yypvt [ - 2 ] . ival ) ; 
 n_term_cnt = gettermcnt ( inst -> ntw ) ; 
if ( n_net_cnt % n_inst_cnt != 0 ) 
n_inst_cnt = 0 ; 

 inst -> ntw_attr = ( struct stack * ) ( stackcpy ( attr_s ) ) ; 
if ( inst_net_eqv ( inst , ( struct queue * ) yypvt [ - 2 ] . ival ) ) 
{ 
sls_error ( yylineno - 1 , sls_errno , 0 ) ; } 

n_inst_cnt = 0 ; } } 

break ; 
case 36 : 
#line 458 "spipar.y"
{ 
int net_cnt ; 
int inst_cnt ; 
int dev ; 
Stack * inst_xs ; 
#line 469 "spipar.y"
if ( yypvt [ - 3 ] . ival && yypvt [ - 2 ] . ival ) { 
if ( yypvt [ - 1 ] . sval == 0 ) 
 yyerror ( 0 ) ; 
if ( ( pntw = ( struct ntwdef * ) ( read_ntw ( yypvt [ - 1 ] . sval ) ) ) == 0 ) { 
#line 478 "spipar.y"
if ( strcmp ( yypvt [ - 1 ] . sval , "nenh" ) == 0 ) dev = 0 ; 
else if ( strcmp ( yypvt [ - 1 ] . sval , "penh" ) == 0 ) dev = 1 ; 
else if ( strcmp ( yypvt [ - 1 ] . sval , "ndep" ) == 0 ) dev = 2 ; 
else { 
sls_errno = 16 ; 
sls_error ( yylineno - 1 , sls_errno , yypvt [ - 1 ] . sval ) ; 
die ( ) ; } 

 pntw = ( struct ntwdef * ) ( dev_tab [ dev ] ) ; } 

yyval . ival = ( int ) ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct ntwinst ) ) , _1ntwinst_new ( ( struct ntwinst * ) _that , ( struct ntwdef * ) ( pntw ) , ( struct stack * ) 0 ) , ( struct ntwinst * ) _that ) ; 

 ( ( struct link * ) yyval . ival ) -> type = curr_inst_type ; 

 inst = ( struct ntwinst * ) yyval . ival ; 

 inst -> inst_struct = ( struct instancestruct * ) yypvt [ - 3 ] . ival ; 

 _13dictionary_store ( ( struct dictionary * ) sym_dict , ( char * ) ( inst -> inst_struct -> inst_name ) , ( char * ) ( ( char * ) inst ) ) ; 

n_inst_cnt = 0 ; 

 inst -> ntw_attr = ( struct stack * ) ( stackcpy ( attr_s ) ) ; 
if ( inst_net_eqv ( inst , ( struct queue * ) yypvt [ - 2 ] . ival ) ) 
{ 
sls_error ( yylineno - 1 , sls_errno , 0 ) ; } 

n_inst_cnt = 0 ; } } 

break ; 
case 37 : 
#line 511 "spipar.y"
{ 
int net_cnt ; 
int inst_cnt ; 
int dev ; 
Stack * inst_xs ; 
#line 522 "spipar.y"
if ( yypvt [ - 3 ] . ival && yypvt [ - 2 ] . ival ) { 
yyval . ival = ( int ) ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct ntwinst ) ) , _1ntwinst_new ( ( struct ntwinst * ) _that , ( struct ntwdef * ) ( dev_tab [ 3 ] ) , ( struct stack * ) 0 ) , ( struct ntwinst * ) _that ) ; 

 ( ( struct link * ) yyval . ival ) -> type = curr_inst_type ; 

 inst = ( struct ntwinst * ) yyval . ival ; 

 inst -> inst_struct = ( struct instancestruct * ) yypvt [ - 3 ] . ival ; 

 _13dictionary_store ( ( struct dictionary * ) sym_dict , ( char * ) ( inst -> inst_struct -> inst_name ) , ( char * ) ( ( char * ) inst ) ) ; 

n_inst_cnt = 0 ; 

 inst -> ntw_attr = ( struct stack * ) ( stackcpy ( attr_s ) ) ; 
if ( inst_net_eqv ( inst , ( struct queue * ) yypvt [ - 2 ] . ival ) ) 
{ 
sls_error ( yylineno - 1 , sls_errno , 0 ) ; } 

n_inst_cnt = 0 ; } } 

break ; 
case 38 : 
#line 546 "spipar.y"
{ 
int net_cnt ; 
int inst_cnt ; 
int dev ; 
Stack * inst_xs ; 
#line 557 "spipar.y"
if ( yypvt [ - 3 ] . ival && yypvt [ - 2 ] . ival ) { 
yyval . ival = ( int ) ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct ntwinst ) ) , _1ntwinst_new ( ( struct ntwinst * ) _that , ( struct ntwdef * ) ( dev_tab [ 4 ] ) , ( struct stack * ) 0 ) , ( struct ntwinst * ) _that ) ; 

 ( ( struct link * ) yyval . ival ) -> type = curr_inst_type ; 

 inst = ( struct ntwinst * ) yyval . ival ; 

 inst -> inst_struct = ( struct instancestruct * ) yypvt [ - 3 ] . ival ; 

 _13dictionary_store ( ( struct dictionary * ) sym_dict , ( char * ) ( inst -> inst_struct -> inst_name ) , ( char * ) ( ( char * ) inst ) ) ; 

n_inst_cnt = 0 ; 

 inst -> ntw_attr = ( struct stack * ) ( stackcpy ( attr_s ) ) ; 
if ( inst_net_eqv ( inst , ( struct queue * ) yypvt [ - 2 ] . ival ) ) 
{ 
sls_error ( yylineno - 1 , sls_errno , 0 ) ; } 

n_inst_cnt = 0 ; } } 

break ; 
case 40 : 
#line 584 "spipar.y"
{ 
curr_inst_type = 0x13 ; 

 _18stack_reset ( ( struct stack * ) xs ) ; 

if ( _14dictionary_fetch ( ( struct dictionary * ) sym_dict , ( char * ) ( yytext ) ) ) 
{ 
sls_errno = 11 ; 
sls_error ( yylineno , sls_errno , yytext ) ; 
yyval . ival = 0 ; } 

else 
{ 
yyval . ival = ( int ) 
 ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct instancestruct ) ) , _1instancestruct_new ( ( struct instancestruct * ) _that , ( char * ) ( strsav ( yytext ) ) , ( struct stack * ) ( stackcpy ( ( struct stack * ) xs ) ) ) , ( struct instancestruct * ) _that ) ; } } 

break ; 
case 41 : 
#line 604 "spipar.y"
{ 
curr_inst_type = 0x10 ; 

 _18stack_reset ( ( struct stack * ) xs ) ; 

if ( _14dictionary_fetch ( ( struct dictionary * ) sym_dict , ( char * ) ( yytext ) ) ) 
{ 
sls_errno = 11 ; 
sls_error ( yylineno , sls_errno , yytext ) ; 
yyval . ival = 0 ; } 

else 
{ 
yyval . ival = ( int ) 
 ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct instancestruct ) ) , _1instancestruct_new ( ( struct instancestruct * ) _that , ( char * ) ( strsav ( yytext ) ) , ( struct stack * ) ( stackcpy ( ( struct stack * ) xs ) ) ) , ( struct instancestruct * ) _that ) ; } } 

break ; 
case 42 : 
#line 624 "spipar.y"
{ 
curr_inst_type = 0x11 ; 

 _18stack_reset ( ( struct stack * ) xs ) ; 

if ( _14dictionary_fetch ( ( struct dictionary * ) sym_dict , ( char * ) ( yytext ) ) ) 
{ 
sls_errno = 11 ; 
sls_error ( yylineno , sls_errno , yytext ) ; 
yyval . ival = 0 ; } 

else 
{ 
yyval . ival = ( int ) 
 ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct instancestruct ) ) , _1instancestruct_new ( ( struct instancestruct * ) _that , ( char * ) ( strsav ( yytext ) ) , ( struct stack * ) ( stackcpy ( ( struct stack * ) xs ) ) ) , ( struct instancestruct * ) _that ) ; } } 

break ; 
case 43 : 
#line 644 "spipar.y"
{ 
curr_inst_type = 0x12 ; 

 _18stack_reset ( ( struct stack * ) xs ) ; 

if ( _14dictionary_fetch ( ( struct dictionary * ) sym_dict , ( char * ) ( yytext ) ) ) 
{ 
sls_errno = 11 ; 
sls_error ( yylineno , sls_errno , yytext ) ; 
yyval . ival = 0 ; } 

else 
{ 
yyval . ival = ( int ) 
 ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct instancestruct ) ) , _1instancestruct_new ( ( struct instancestruct * ) _that , ( char * ) ( strsav ( yytext ) ) , ( struct stack * ) ( stackcpy ( ( struct stack * ) xs ) ) ) , ( struct instancestruct * ) _that ) ; } } 

break ; 
case 44 : 
#line 664 "spipar.y"
{ 
curr_inst_type = 0 ; 
yyval . ival = 0 ; } 
break ; 
case 45 : 
#line 671 "spipar.y"
{ 
 _18stack_reset ( ( struct stack * ) attr_s ) ; 
 yyval . ival = ( int ) attr_s ; } 
break ; 
case 46 : 
#line 676 "spipar.y"
{ 
 _14stack_push ( ( struct stack * ) ( ( struct stack * ) yypvt [ - 1 ] . ival ) , ( char * ) ( ( char * ) strsav ( yypvt [ - 0 ] . sval ) ) ) ; 
yyval . ival = yypvt [ - 1 ] . ival ; } 
break ; 
case 47 : 
#line 683 "spipar.y"
{ 
 _18stack_reset ( ( struct stack * ) attr_s ) ; 
sprintf ( attr_buf , "v=%g" , yypvt [ - 0 ] . dval ) ; 
 _14stack_push ( ( struct stack * ) attr_s , ( char * ) ( strsav ( attr_buf ) ) ) ; 

 yyval . ival = ( int ) attr_s ; } 
break ; 
case 48 : 
#line 693 "spipar.y"
{ 
sprintf ( attr_buf , "%s=%g" , yypvt [ - 2 ] . sval , yypvt [ - 0 ] . dval ) ; 
yyval . sval = attr_buf ; } 
break ; 
case 49 : 
#line 700 "spipar.y"
{ 
yyval . sval = "w" ; } 
break ; 
case 50 : 
#line 704 "spipar.y"
{ 
yyval . sval = "l" ; } 
break ; 
case 51 : 
#line 710 "spipar.y"
{ 
yyval . dval = yypvt [ - 0 ] . dval ; } 
break ; 
case 52 : 
#line 716 "spipar.y"
{ 
yyval . dval = ( double ) yypvt [ - 0 ] . ival ; } 
break ; 
case 53 : 
#line 720 "spipar.y"
{ 
yyval . dval = yypvt [ - 0 ] . dval ; } 
break ; 
case 54 : 
#line 726 "spipar.y"
{ 
 yyval . dval = cvt_atof ( yypvt [ - 0 ] . sval ) ; } 
break ; 
case 55 : 
#line 732 "spipar.y"
{ 
 pnetq = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct queue ) ) , _1queue_new ( ( struct queue * ) _that , ( char ) ( 0x01 ) ) , ( struct queue * ) _that ) ; 

if ( yypvt [ - 1 ] . ival ) { 
 _14queue_put ( ( struct queue * ) pnetq , ( struct link * ) ( ( struct link * ) yypvt [ - 1 ] . ival ) ) ; } 


if ( yypvt [ - 0 ] . ival ) { 
 _14queue_put ( ( struct queue * ) pnetq , ( struct link * ) ( ( struct link * ) yypvt [ - 0 ] . ival ) ) ; } 


 ( ( struct link * ) pnetq ) -> type = 0x08 ; 

 yyval . ival = ( int ) pnetq ; } 
break ; 
case 56 : 
#line 750 "spipar.y"
{ 
 pnetq = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct queue ) ) , _1queue_new ( ( struct queue * ) _that , ( char ) ( 0x01 ) ) , ( struct queue * ) _that ) ; 

if ( yypvt [ - 3 ] . ival ) { 
 _14queue_put ( ( struct queue * ) pnetq , ( struct link * ) ( ( struct link * ) yypvt [ - 3 ] . ival ) ) ; } 


if ( yypvt [ - 2 ] . ival ) { 
 _14queue_put ( ( struct queue * ) pnetq , ( struct link * ) ( ( struct link * ) yypvt [ - 2 ] . ival ) ) ; } 


if ( yypvt [ - 1 ] . ival ) { 
 _14queue_put ( ( struct queue * ) pnetq , ( struct link * ) ( ( struct link * ) yypvt [ - 1 ] . ival ) ) ; } 


if ( yypvt [ - 0 ] . ival ) { 
 _14queue_put ( ( struct queue * ) pnetq , ( struct link * ) ( ( struct link * ) yypvt [ - 0 ] . ival ) ) ; } 


 ( ( struct link * ) pnetq ) -> type = 0x08 ; 

 yyval . ival = ( int ) pnetq ; } 
break ; 
case 57 : 
#line 776 "spipar.y"
{ 
 pnetq = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct queue ) ) , _1queue_new ( ( struct queue * ) _that , ( char ) ( 0x01 ) ) , ( struct queue * ) _that ) ; 

if ( yypvt [ - 0 ] . ival ) 
{ 
 _14queue_put ( ( struct queue * ) pnetq , ( struct link * ) ( ( struct link * ) yypvt [ - 0 ] . ival ) ) ; } 


 yyval . ival = ( int ) pnetq ; 

 ( ( struct link * ) pnetq ) -> type = 0x08 ; } 
break ; 
case 58 : 
#line 789 "spipar.y"
{ 
if ( yypvt [ - 0 ] . ival ) 
{ 
 _14queue_put ( ( struct queue * ) ( ( struct queue * ) yypvt [ - 1 ] . ival ) , ( struct link * ) ( ( struct link * ) yypvt [ - 0 ] . ival ) ) ; } 


yyval . ival = yypvt [ - 1 ] . ival ; } 
break ; 
case 59 : 
#line 800 "spipar.y"
{ 
#line 810 "spipar.y"
if ( ( pnet = ( struct netelem * ) ( _14dictionary_fetch ( ( struct dictionary * ) sym_dict , ( char * ) ( yypvt [ - 0 ] . sval ) ) ) ) == 0 ) 
{ 
 pnet = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct netelem ) ) , _1netelem_new ( ( struct netelem * ) _that , ( char * ) ( yypvt [ - 0 ] . sval ) , ( struct stack * ) 0 , ( char ) ( 0x05 ) ) , ( struct netelem * ) _that ) ; 
 _13dictionary_store ( ( struct dictionary * ) sym_dict , ( char * ) ( pnet -> name ) , ( char * ) ( ( char * ) pnet ) ) ; 
 _14queue_put ( ( struct queue * ) ntw -> netq , ( struct link * ) ( ( struct link * ) pnet ) ) ; } 

yyval . ival = ( int ) ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct net_ref ) ) , _1net_ref_new ( ( struct net_ref * ) _that , ( struct netelem * ) ( pnet ) , ( struct stack * ) 0 ) , ( struct net_ref * ) _that ) ; } 
break ; 
case 60 : 
#line 821 "spipar.y"
{ 
strcpy ( net_buf , yytext ) ; 
yyval . sval = net_buf ; } 
break ; 
case 61 : 
#line 826 "spipar.y"
{ 
strcpy ( net_buf , yypvt [ - 0 ] . sval ) ; 
yyval . sval = net_buf ; } 
break ; 
case 62 : 
#line 833 "spipar.y"
{ 
yyval . sval = 0 ; } 
break ; 
case 63 : 
#line 837 "spipar.y"
{ 
yyval . sval = yypvt [ - 0 ] . sval ; } 
break ; 
case 64 : 
#line 843 "spipar.y"
{ 
strcpy ( ntw_name , yypvt [ - 0 ] . sval ) ; 
yyval . sval = ntw_name ; } 
break ; 
case 65 : 
#line 850 "spipar.y"
{ 
strcpy ( net_buf , yytext ) ; 
yyval . sval = net_buf ; } 
break ; 
case 66 : 
#line 855 "spipar.y"
{ 
strcpy ( net_buf , yypvt [ - 0 ] . sval ) ; 
yyval . sval = net_buf ; } 
break ; 
case 83 : 
#line 882 "spipar.y"
{ 
strcpy ( name_buf , yypvt [ - 0 ] . sval ) ; 

if ( dmTestname ( name_buf ) == 1 ) { 
if ( ! trunc_warn && ! noWarnings ) { 
fprintf ( stderr , 
"Warning: name(s) truncated to %d characters\n" , 
DM_MAXNAME ) ; 
trunc_warn = 1 ; } } 


yyval . sval = name_buf ; } 
break ; 
case 84 : 
#line 898 "spipar.y"
{ 
yyval . ival = atoi ( yypvt [ - 0 ] . sval ) ; } 
break ; } 

goto yystack ; 
#line 1703 "spipar.cls"
_return : return _result ; } /* yyparse */ 
