static char *SccsId = "@(#)dbopen.c 4.2 (TU-Delft) 06/11/91";
/**********************************************************

Name/Version      : sls_mkdb/4.2

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.C. de Graaf
Creation date     : 10-Jul-1986
Modified by       : S. de Graaf
Modification date : 10-Jul-1986


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1986 , All rights reserved
**********************************************************/
#include "sys_incl.h"
# include "odb.h"

DbAcces * dbOpen (dbname)
char   *dbname;
{
/* 	Open object database (ODB) dbname :
 *		dbname.dir  - hash info to acces ...pag dbname
 *		dbname.pag  - object adress <-> object key info
 *
 */
    struct stat statb;
    DbAcces * dbacces;

    dbacces = (DbAcces *) calloc (1, sizeof (DbAcces));
    dbacces -> DbRdOnly = 0;
    dbacces -> dbname = (char *) calloc (strlen (dbname) + 1, sizeof (char));
    strcpy (dbacces -> dbname, dbname);

/*	Open pag file
 */
    strcpy (dbacces -> pagbuf, dbname);
    strcat (dbacces -> pagbuf, ".pag");
    dbacces -> PagF = open (dbacces -> pagbuf, O_RDWR | O_CREAT | O_TRUNC, 0644);
    if (dbacces -> PagF < 0) {
	dbacces -> PagF = open (dbacces -> pagbuf, 0);
	dbacces -> DbRdOnly = 1;
    }

/*	Open dir file
 */
    strcpy (dbacces -> pagbuf, dbname);
    strcat (dbacces -> pagbuf, ".dir");
    dbacces -> DirF = open (dbacces -> pagbuf, O_RDWR | O_CREAT | O_TRUNC, 0644);
    if (dbacces -> DirF < 0) {
	dbacces -> DirF = open (dbacces -> pagbuf, 0);
	dbacces -> DbRdOnly = 1;
    }

/* 	Initialize database files and file buffers 
 */
    dbacces -> dir_b = -1;
    dbacces -> pag_b = -1;

    return (dbacces);
}

dbClose (dbacces)
DbAcces ** dbacces;
{
    char file_name[BUFSIZ];
    char   *cs;

    if ((*dbacces) -> dir_t) {
	lseek ((*dbacces) -> DirF, (*dbacces) -> dir_b * DBLKSIZ, 0);
	write ((*dbacces) -> DirF, (*dbacces) -> dirbuf, DBLKSIZ);
	(*dbacces) -> dir_t = 0;
    }
    if ((*dbacces) -> pag_t) {
	lseek ((*dbacces) -> PagF, (*dbacces) -> pag_b * PBLKSIZ, 0);
	write ((*dbacces) -> PagF, (*dbacces) -> pagbuf, PBLKSIZ);
	(*dbacces) -> pag_t = 0;
    }
    close ((*dbacces) -> DirF);
    close ((*dbacces) -> PagF);

    sprintf (file_name, "%s", (*dbacces) -> dbname);
    cs = file_name + strlen (file_name);
    strcpy (cs, ".pag");
    unlink (file_name);
    strcpy (cs, ".dir");
    unlink (file_name);
    cfree ((*dbacces));
    *dbacces = NULL;
    return (0);
}
