/* SccsId = "@(#)sys_incl.h 4.3 (TU-Delft) 07/27/92" */
/**********************************************************

Name/Version      : sls_mkdb/4.3

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.C. de Graaf
Creation date     : 10-Jul-1986
Modified by       : S. de Graaf
Modification date : 10-Jul-1986


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1986 , All rights reserved
**********************************************************/
#ifndef NOSYSINCL
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <ctype.h>
#ifdef SYSV
#include <fcntl.h>
#else
#include <sys/file.h>
#endif
#include "dmincl.h"
#ifndef NCF_RELEASE
#define NCF_RELEASE 300
#endif
#endif

#line 1 "class.cls"
/* <<cpre-2/8/82>> */ static char * SccsId = "@(#)class.cls 4.4 (TU-Delft) 07/27/92" ; 
#line 1 "./sys_incl.h"

#line 41 "./sys_incl.h"

#line 28 "class.cls"

#line 1 "./class.h"

#line 1 "./odb.h"

#line 31 "./class.h"
typedef struct datum 
{ 
char * dptr ; 
int dsize ; 
} datum ; 

typedef struct db_files { 
char * dbname ; 
int DbRdOnly ; 
int DirF , dir_b , dir_t ; 
int PagF , pag_b , pag_t ; 

long bitno ; 
long maxbno ; 
long blkno ; 
long hmask ; 

char pagbuf [ 1024 ] ; 
char dirbuf [ 1024 ] ; 
} DbAcces ; 

DbAcces * dbOpen ( ) ; 
datum dbfetch ( ) ; 
datum makdatum ( ) ; 
datum firstkey ( ) ; 
datum nextkey ( ) ; 
datum firsthash ( ) ; 
long calchash ( ) ; 
long hashinc ( ) ; 
#line 28 "./class.h"

#line 1 "./stack.h"

#line 27 "./stack.h"
struct stack { char * * min ;
char * * top ;
char * * max ;
} ;
extern int _1stack_new ( /* short */ ) ;
extern int _2stack_delete ( ) ;
extern int _13stack_empty ( /* ? */ ) ;
extern int _14stack_push ( /* char * */ ) ;
extern char * _15stack_pop ( ) ;
extern char * _16stack_access ( /* int */ ) ;
extern int _17stack_print ( ) ;
extern int _18stack_reset ( ) ;
extern struct stack * _19stack_copy ( ) ;
extern char * * _20stack_base ( ) ;
extern char * * _21stack_limit ( ) ;
extern int _22stack_length ( ) ;

#line 44 "./stack.h"
; 
#line 29 "./class.h"

#line 1 "./queue.h"

#line 27 "./queue.h"
struct link { struct link * next ;
char type ;
} ;

#line 31 "./queue.h"
;

#line 33 "./queue.h"
struct queue { struct link _Bqueue ;
struct link * tail ;
short n ;
} ;
extern int _1queue_new ( /* char */ ) ;
extern int _2queue_delete ( ) ;
extern int _12queue_reset ( ) ;
extern struct link * _13queue_get ( ) ;
extern int _14queue_put ( /* struct link * */ ) ;
extern short _15queue_length ( ) ;
extern int _16queue_print ( ) ;
extern int _17queue_empty ( ) ;
extern struct link * _18queue_access ( /* int */ ) ;
extern struct link * _19queue_first_elem ( ) ;
extern struct link * _20queue_next_elem ( /* struct link * */ ) ;
extern struct link * _21queue_last_elem ( ) ;
extern int _22queue_append ( /* struct queue * */ ) ;

#line 51 "./queue.h"
; 
#line 30 "./class.h"

#line 1 "./dict.h"

#line 27 "./dict.h"
struct dictionary { struct db_files * db ;
struct datum key ;
struct datum data ;
} ;
extern int _1dictionary_new ( ) ;
extern int _2dictionary_delete ( ) ;
extern int _13dictionary_store ( /* char * , char * */ ) ;
extern char * _14dictionary_fetch ( /* char * */ ) ;
extern int _15dictionary_print ( /* ? */ ) ;

#line 37 "./dict.h"
; 
#line 31 "./class.h"

typedef struct dictionary Dictionary ; 
typedef struct stack Stack ; 
typedef struct queue Queue ; 
typedef struct link Link ; 
#line 1 "./ntwdefs.h"

#line 27 "./ntwdefs.h"
struct ntwdef { int inst_gen_cnt ;
int net_gen_cnt ;
char * ntw_name ;
int local ;
struct queue * termq ;
struct queue * orig_termq ;
struct queue * mcq ;
struct queue * netq ;
} ;
extern int _1ntwdef_new ( /* char * */ ) ;
extern int _2ntwdef_delete ( ) ;
extern char * _12ntwdef_genname ( /* char */ ) ;

#line 40 "./ntwdefs.h"
;

#line 42 "./ntwdefs.h"
struct instancestruct { char * inst_name ;
struct stack * inst_construct ;
int termCnt ;
struct netMember * nmem ;
} ;
extern int _1instancestruct_new ( /* char * , struct stack * */ ) ;
extern int _2instancestruct_delete ( ) ;

#line 50 "./ntwdefs.h"
;

#line 52 "./ntwdefs.h"
struct ntwinst { struct link _Bntwinst ;
struct ntwdef * ntw ;
struct stack * ntw_attr ;
struct instancestruct * inst_struct ;
} ;
extern int _1ntwinst_new ( /* struct ntwdef * , struct stack * */ ) ;
extern int _2ntwinst_delete ( ) ;
extern int _13ntwinst_to_db ( ) ;

#line 60 "./ntwdefs.h"
; 


typedef struct ntwdef Network ; 
typedef struct ntwinst NetworkInstance ; 
typedef struct instancestruct InstanceStruct ; 
#line 38 "./class.h"

#line 1 "./xelem.h"

#line 27 "./xelem.h"
struct xelem { short left_bound ;
short right_bound ;
} ;
extern int _1xelem_new ( /* short , short */ ) ;
extern int _2xelem_delete ( ) ;
extern int _12xelem_print ( /* ? */ ) ;

#line 34 "./xelem.h"
; 
#line 39 "./class.h"

#line 1 "./netelem.h"

#line 31 "./netelem.h"
struct simpleNet { struct netMember * nmem ;
struct simpleNet * next ;
struct simpleNet * prev ;
} ;

#line 36 "./netelem.h"
;

#line 49 "./ntwdefs.h"
struct netMember { struct ntwinst * inst ;
struct netelem * net ;
struct netMember * next ;
struct simpleNet * snet ;
} ;

#line 44 "./netelem.h"
;

#line 41 "./netelem.h"
struct netelem { struct link _Bnetelem ;
char * name ;
int type ;
struct stack * xs ;
struct queue * eqv ;
struct netMember * nmem ;
} ;
extern int _1netelem_new ( /* char * , struct stack * , char */ ) ;
extern int _2netelem_delete ( ) ;
extern int _15netelem_print ( /* ? */ ) ;
extern int _16netelem_to_db ( /* ? */ ) ;

#line 57 "./netelem.h"
;

#line 59 "./netelem.h"
struct net_ref { struct link _Bnet_ref ;
struct netelem * net ;
struct stack * net_xs ;
struct ntwinst * inst ;
struct stack * inst_xs ;
struct stack * ref_xs ;
} ;
extern int _1net_ref_new ( /* struct netelem * , struct stack * */ ) ;
extern int _2net_ref_delete ( ) ;

#line 68 "./netelem.h"
; 

typedef struct netMember Nmem ; 
#line 40 "./class.h"

typedef struct xelem Xelem ; 
typedef struct netelem Netelem ; 
typedef struct net_ref NetReference ; 
#line 30 "class.cls"

#line 1 "./mkdbincl.h"

#line 27 "class.cls"
extern int doSimpleNet ; 
extern int genIntNet ; 
extern int externRequired ; 
extern int forbidFirstCapital ; 
extern int noWarnings ; 
extern int sls_errcnt ; 
extern int sls_errno ; 
extern int sls_nerr ; 
extern char * sls_errlist [ ] ; 

extern int yylineno ; 
extern char fn_incl [ ] ; 

extern int int_nbyte , int_maxnbyte ; 
extern int char_nbyte , char_maxnbyte ; 
extern int ntwdef_nbyte , ntwdef_maxnbyte ; 
extern int ntwinst_nbyte , ntwinst_maxnbyte ; 
extern int inst_struct_nbyte , inst_struct_maxnbyte ; 
extern int netelem_nbyte , netelem_maxnbyte ; 
extern int dict_nbyte , dict_maxnbyte ; 
extern int net_ref_nbyte , net_ref_maxnbyte ; 
extern int xelem_nbyte , xelem_maxnbyte ; 
extern int queue_nbyte , queue_maxnbyte ; 
extern int stack_nbyte , stack_maxnbyte ; 
#line 31 "class.cls"

#line 1 "./mkdbdefs.h"

#line 1 "./slserr.h"

#line 30 "./mkdbdefs.h"

#line 32 "class.cls"

DM_STREAM * dsp_term = 0 ; 
DM_STREAM * dsp_mc = 0 ; 
DM_STREAM * dsp_net = 0 ; 
DM_STREAM * dsp_sim_mc = 0 ; 
#line 1 "./stack.cls"

#line 27 "./stack.cls"
int _1stack_new ( this , size ) short size ; register struct stack * this ; { int * _that ; 
 ( this -> top ) = ( this -> min ) = ( char * * ) calloc ( ( unsigned ) ( size ) , sizeof ( char * ) ) ; 
 ( this -> max ) = ( this -> min ) + size ; 
#line 33 "./stack.cls"
} /* _1stack_new */ 


int _2stack_delete ( this ) register struct stack * this ; { int * _that ; 
#line 39 "./stack.cls"
} /* _2stack_delete */ 


int _18stack_reset ( this ) register struct stack * this ; { int * _that ; 
 ( this -> top ) = ( this -> min ) ; } /* _18stack_reset */ 


int _13stack_empty ( this ) register struct stack * this ; { int * _that ; int _result ; { _result = 
 ( ( this -> top ) == ( this -> min ) ) ; goto _return ; } _return : return _result ; } /* _13stack_empty */ 


int _14stack_push ( this , elem ) char * elem ; register struct stack * this ; { int * _that ; int _result ; 
if ( ( this -> top ) < ( this -> max ) ) 
 * ( this -> top ) ++ = elem ; 
else { _result = 
 0x1 ; goto _return ; } _return : return _result ; } /* _14stack_push */ 


char * _15stack_pop ( this ) register struct stack * this ; { int * _that ; char * _result ; 
if ( ( this -> top ) > ( this -> min ) ) { _result = 
 ( * -- ( this -> top ) ) ; goto _return ; } 
else { _result = 
 ( 0 ) ; goto _return ; } _return : return _result ; } /* _15stack_pop */ 


int _17stack_print ( this ) register struct stack * this ; { int * _that ; 
char * * pxs ; 
printf ( "StackB\n" ) ; 
printf ( "ptr: %x\tsize: %d\tmin: %x\t max: %x\ttop: %x\n" , 
 this , ( ( this -> top ) - ( this -> min ) ) , ( this -> min ) , ( this -> max ) , ( this -> top ) ) ; 
for ( pxs = ( this -> min ) ; pxs < ( this -> top ) ; pxs ++ ) 
printf ( "[%d] ptr: %x\t*ptr: %x\n" , ( pxs - ( this -> min ) ) , pxs , * pxs ) ; 
printf ( "StackE\n" ) ; } /* _17stack_print */ 


char * _16stack_access ( this , x ) int x ; register struct stack * this ; { int * _that ; char * _result ; 
if ( ! _13stack_empty ( ( struct stack * ) this ) ) 
{ 
if ( x < 0 || x >= ( ( this -> top ) - ( this -> min ) ) ) 
fprintf ( stderr , "stack: Invalid index" ) ; 
else { _result = 
 ( * ( ( this -> min ) + x ) ) ; goto _return ; } } _return : return _result ; } /* _16stack_access */ struct stack 



* _19stack_copy ( this ) register struct stack * this ; { int * _that ; struct stack * _result ; struct stack 
* pstack = 0 ; 
char * * p ; 

if ( ! _13stack_empty ( ( struct stack * ) this ) ) 
{ 
 pstack = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct stack ) ) , _1stack_new ( ( struct stack * ) _that , ( short ) ( ( this -> top ) - ( this -> min ) ) ) , ( struct stack * ) _that ) ; 
for ( p = ( this -> min ) ; p < ( this -> top ) ; p ++ ) 
 _14stack_push ( ( struct stack * ) pstack , ( char * ) ( * p ) ) ; } { _result = 

 pstack ; goto _return ; } _return : return _result ; } /* _19stack_copy */ 


char * * _20stack_base ( this ) register struct stack * this ; { int * _that ; char * * _result ; { _result = 
 ( this -> min ) ; goto _return ; } _return : return _result ; } /* _20stack_base */ 


char * * _21stack_limit ( this ) register struct stack * this ; { int * _that ; char * * _result ; { _result = 
 ( this -> max ) ; goto _return ; } _return : return _result ; } /* _21stack_limit */ 


int _22stack_length ( this ) register struct stack * this ; { int * _that ; int _result ; { _result = 
 ( ( this -> top ) - ( this -> min ) ) ; goto _return ; } 
#line 39 "class.cls"

#line 1 "./queue.cls"
_return : return _result ; } /* _22stack_length */ 
#line 27 "./queue.cls"
int _1queue_new ( this , qtype ) char qtype ; register struct queue * this ; 
{ int * _that ; 
 ( ( ( struct link * ) this ) -> type ) = qtype ; 
 ( this -> tail ) = ( struct link * ) ( 0 ) ; 
 ( this -> n ) = 0 ; 
#line 35 "./queue.cls"
} /* _1queue_new */ 


int _2queue_delete ( this ) register struct queue * this ; 
{ int * _that ; 
#line 42 "./queue.cls"
} /* _2queue_delete */ 


int _12queue_reset ( this ) register struct queue * this ; 
{ int * _that ; 
 ( this -> n ) = 0 ; } /* _12queue_reset */ 


short _15queue_length ( this ) register struct queue * this ; 
{ int * _that ; short _result ; { _result = 
 ( this -> n ) ; goto _return ; } _return : return _result ; } /* _15queue_length */ 



int _14queue_put ( this , p ) struct link * p ; register struct queue * this ; 
{ int * _that ; 
if ( ( this -> n ) ++ ) { 
 p -> next = ( struct link * ) ( ( this -> tail ) -> next ) ; 
 ( this -> tail ) -> next = ( struct link * ) ( p ) ; } 

else 
 p -> next = ( struct link * ) ( p ) ; 
 ( this -> tail ) = ( struct link * ) ( p ) ; } /* _14queue_put */ struct link 


* _13queue_get ( this ) register struct queue * this ; 
{ int * _that ; struct link * _result ; struct link 
* p ; 

if ( ( this -> n ) -- ) { 
 p = ( struct link * ) ( ( this -> tail ) -> next ) ; 
 ( this -> tail ) -> next = ( struct link * ) ( p -> next ) ; { _result = 
 p ; goto _return ; } } 

else { 
 ( this -> n ) = 0 ; { _result = 
 0 ; goto _return ; } } _return : return _result ; } /* _13queue_get */ 



int _16queue_print ( this ) register struct queue * this ; { int * _that ; struct link 
* cur = ( this -> tail ) -> next ; 
int i ; 

printf ( "QueueB\n" ) ; 
printf ( "ptr: %x\tn: %d\ttail: %x\t" , this , ( this -> n ) , ( this -> tail ) ) ; 

if ( ( this -> tail ) ) 
{ 
do { 
printf ( "[%d] ptr: %x\t*ptr: %x\n" , i , cur , * cur ) ; 

switch ( cur -> type ) { 
case 0x01 : printf ( "type: QueueType\n" ) ; 
 _16queue_print ( ( struct queue * ) ( ( struct queue * ) cur ) ) ; 
break ; 
case 0x05 : printf ( "type: NetType\n" ) ; 
 _15netelem_print ( ( struct netelem * ) ( ( struct netelem * ) cur ) ) ; 
break ; 
case 0x04 : printf ( "type: TermType\n" ) ; 
 _15netelem_print ( ( struct netelem * ) ( ( struct netelem * ) cur ) ) ; 
break ; } 


 cur = ( struct link * ) ( cur -> next ) ; 
i ++ ; } 
while ( cur != ( this -> tail ) -> next ) ; } 

printf ( "QueueE\n" ) ; } /* _16queue_print */ 


int _17queue_empty ( this ) register struct queue * this ; 
{ int * _that ; int _result ; { _result = 
 ( ( this -> n ) == 0 ) ; goto _return ; } _return : return _result ; } /* _17queue_empty */ struct link 


* _18queue_access ( this , x ) int x ; register struct queue * this ; 
{ int * _that ; struct link * _result ; struct link 
* p = ( this -> tail ) -> next ; 
int i ; 

for ( i = 0 ; i < x ; i ++ ) 
 p = ( struct link * ) ( p -> next ) ; { _result = 
 p ; goto _return ; } _return : return _result ; } /* _18queue_access */ struct link 


* _19queue_first_elem ( this ) register struct queue * this ; { int * _that ; struct link * _result ; { _result = 
 ( this -> tail ) -> next ; goto _return ; } _return : return _result ; } /* _19queue_first_elem */ struct link 


* _20queue_next_elem ( this , cur_elem ) struct link * cur_elem ; register struct queue * this ; { int * _that ; struct link * _result ; { _result = 
 cur_elem -> next ; goto _return ; } _return : return _result ; } /* _20queue_next_elem */ struct link 


* _21queue_last_elem ( this ) register struct queue * this ; { int * _that ; struct link * _result ; { _result = 
 ( this -> tail ) ; goto _return ; } _return : return _result ; } /* _21queue_last_elem */ 


int _22queue_append ( this , pq ) struct queue * pq ; register struct queue * this ; 
{ int * _that ; 
while ( ! _17queue_empty ( ( struct queue * ) pq ) ) 
 _14queue_put ( ( struct queue * ) this , ( struct link * ) ( _13queue_get ( ( struct queue * ) pq ) ) ) ; { _that = ( int * ) 
 pq ; _2queue_delete ( ( struct queue * ) _that ) ; free ( _that ) ; } 
#line 40 "class.cls"

#line 1 "./diction.cls"
} /* _22queue_append */ 
#line 27 "./diction.cls"
static int counter = 0 ; 

int _1dictionary_new ( this ) register struct dictionary * this ; { int * _that ; 
char * tempval ; 
char * template ; 
char * mktemp ( ) ; 

template = ( char * ) calloc ( ( unsigned ) ( 24 ) , sizeof ( char ) ) ; 

sprintf ( template , "/usr/tmp/x%dXXXXXX" , counter ) ; 
counter ++ ; 

tempval = mktemp ( template ) ; 
 ( this -> db ) = dbOpen ( tempval ) ; 
#line 44 "./diction.cls"
} /* _1dictionary_new */ 


int _2dictionary_delete ( this ) register struct dictionary * this ; { int * _that ; 
#line 50 "./diction.cls"

if ( ( this -> db ) ) 
 dbClose ( & ( this -> db ) ) ; } /* _2dictionary_delete */ 


int _13dictionary_store ( this , item_key , item_data ) char * item_key ; char * item_data ; register struct dictionary * this ; { int * _that ; 
 ( this -> key ) . dptr = item_key ; 
 ( this -> key ) . dsize = strlen ( item_key ) + 1 ; 
 ( this -> data ) . dptr = ( char * ) & item_data ; 
 ( this -> data ) . dsize = sizeof ( int ) ; 
 dbstore ( ( this -> db ) , ( this -> key ) , ( this -> data ) ) ; } /* _13dictionary_store */ 


char * _14dictionary_fetch ( this , item_key ) char * item_key ; register struct dictionary * this ; { int * _that ; char * _result ; 
int * n ; 
datum dbfetch ( ) ; 

 ( this -> key ) . dptr = item_key ; 
 ( this -> key ) . dsize = strlen ( item_key ) + 1 ; 
 ( this -> data ) = dbfetch ( ( this -> db ) , ( this -> key ) ) ; 
if ( ( this -> data ) . dptr == 0 ) { _result = 
 ( 0 ) ; goto _return ; } 
bmove ( & n , ( this -> data ) . dptr , ( this -> data ) . dsize ) ; { _result = 
 ( char * ) n ; goto _return ; } _return : return _result ; } /* _14dictionary_fetch */ 


int _15dictionary_print ( this ) register struct dictionary * this ; { int * _that ; 
datum dbfetch ( ) ; 
int * n ; 

for ( ( this -> key ) = firstkey ( ( this -> db ) ) ; ( this -> key ) . dptr != 0 ; ( this -> key ) = nextkey ( ( this -> db ) , ( this -> key ) ) ) 
{ 
 ( this -> data ) = dbfetch ( ( this -> db ) , ( this -> key ) ) ; 
bmove ( & n , ( this -> data ) . dptr , ( this -> data ) . dsize ) ; 
fprintf ( stderr , "key: %s, data: %x\n" , ( this -> key ) . dptr , n ) ; } 
#line 41 "class.cls"

#line 1 "./ntwdefs.cls"
} /* _15dictionary_print */ 
#line 28 "./ntwdefs.cls"
extern char mc_type ; 
extern int cirflag ; 

int _1ntwdef_new ( this , name ) char * name ; register struct ntwdef * this ; { int * _that ; 
 ( this -> ntw_name ) = ( char * ) strsav ( name ) ; 
 ( this -> inst_gen_cnt ) = 0 ; 
 ( this -> net_gen_cnt ) = 0 ; 
#line 39 "./ntwdefs.cls"
} /* _1ntwdef_new */ 


int _2ntwdef_delete ( this ) register struct ntwdef * this ; { int * _that ; 
#line 45 "./ntwdefs.cls"
} /* _2ntwdef_delete */ 


char * _12ntwdef_genname ( this , tname ) char tname ; register struct ntwdef * this ; { int * _that ; char * _result ; 
char name [ 20 ] ; 

switch ( tname ) 
{ 
case 0x07 : sprintf ( name , "_I%x" , ( this -> inst_gen_cnt ) ) ; 
 ( this -> inst_gen_cnt ) ++ ; 
break ; 

case 0x05 : sprintf ( name , "_N%x" , ( this -> net_gen_cnt ) ) ; 
 ( this -> net_gen_cnt ) ++ ; 
break ; } { _result = 

 ( ( char * ) strsav ( name ) ) ; goto _return ; } _return : return _result ; } /* _12ntwdef_genname */ 


int _1ntwinst_new ( this , pntw , attr ) struct ntwdef * pntw ; struct stack * attr ; register struct ntwinst * this ; { int * _that ; 
 ( ( ( struct link * ) this ) -> type ) = 0x07 ; 
 ( this -> ntw ) = ( struct ntwdef * ) ( pntw ) ; 
 ( this -> ntw_attr ) = ( struct stack * ) ( attr ) ; 
#line 72 "./ntwdefs.cls"
} /* _1ntwinst_new */ 


int _2ntwinst_delete ( this ) register struct ntwinst * this ; { int * _that ; 
 stackfree ( ( this -> ntw_attr ) , 1 ) ; 
if ( ( this -> ntw_attr ) ) { _that = ( int * ) 
 ( this -> ntw_attr ) ; _2stack_delete ( ( struct stack * ) _that ) ; free ( _that ) ; } { _that = ( int * ) 
 ( this -> inst_struct ) ; _2instancestruct_delete ( ( struct instancestruct * ) _that ) ; free ( _that ) ; } 
#line 82 "./ntwdefs.cls"
} /* _2ntwinst_delete */ 


int _13ntwinst_to_db ( this ) register struct ntwinst * this ; { int * _that ; 
Stack * pattr_s = ( this -> ntw_attr ) ; 
Stack * pinst_s = ( this -> inst_struct ) -> inst_construct ; 
char * * pxs ; 
char * * pattr ; 
char attr_buf [ BUFSIZ ] ; 
char * ps = attr_buf ; 
int i ; 
int size = pinst_s ? _21stack_limit ( ( struct stack * ) pinst_s ) - _20stack_base ( ( struct stack * ) pinst_s ) : 0 ; 
char * new_name ; 

strcpy ( cmc . cell_name , ( this -> ntw ) -> ntw_name ) ; 
strcpy ( cmc . inst_name , ( this -> inst_struct ) -> inst_name ) ; 
if ( ( this -> ntw ) -> local ) 
cmc . imported = LOCAL ; 
else 
cmc . imported = IMPORTED ; 

if ( pattr_s ) 
{ 
for ( i = 0 , pattr = _20stack_base ( ( struct stack * ) pattr_s ) ; pattr < _21stack_limit ( ( struct stack * ) pattr_s ) ; i ++ , pattr ++ ) 
{ 
strcpy ( ps , * pattr ) ; 
ps += strlen ( * pattr ) ; 
* ps ++ = ';' ; } 


* -- ps = 0 ; 

cmc . inst_attribute = attr_buf ; } 

else 
cmc . inst_attribute = 0 ; 

cmc . inst_dim = size ; 

if ( pinst_s ) 
{ 


cmc . inst_lower = ( long * ) calloc ( ( unsigned ) ( size ) , sizeof ( long ) ) ; 
#line 129 "./ntwdefs.cls"

for ( i = 0 , pxs = _20stack_base ( ( struct stack * ) pinst_s ) ; pxs < _21stack_limit ( ( struct stack * ) pinst_s ) ; i ++ , pxs ++ ) 
 cmc . inst_lower [ i ] = ( ( struct xelem * ) * pxs ) -> left_bound ; 


cmc . inst_upper = ( long * ) calloc ( ( unsigned ) ( size ) , sizeof ( long ) ) ; 
#line 138 "./ntwdefs.cls"

for ( i = 0 , pxs = _20stack_base ( ( struct stack * ) pinst_s ) ; pxs < _21stack_limit ( ( struct stack * ) pinst_s ) ; i ++ , pxs ++ ) 
 cmc . inst_upper [ i ] = ( ( struct xelem * ) * pxs ) -> right_bound ; } 


dmPutDesignData ( dsp_mc , CIR_MC ) ; 
#line 153 "./ntwdefs.cls"


if ( cmc . inst_dim ) 
{ 
#line 159 "./ntwdefs.cls"
{ _that = ( int * ) 
 cmc . inst_lower ; free ( _that ) ; } { _that = ( int * ) 
 cmc . inst_upper ; free ( _that ) ; } } } /* _13ntwinst_to_db */ 



int _1instancestruct_new ( this , name , construct ) char * name ; struct stack * construct ; register struct instancestruct * this ; { int * _that ; 
 ( this -> inst_name ) = name ; 
 ( this -> inst_construct ) = ( struct stack * ) ( construct ) ; 
#line 172 "./ntwdefs.cls"
} /* _1instancestruct_new */ 


int _2instancestruct_delete ( this ) register struct instancestruct * this ; { int * _that ; { _that = ( int * ) 
 ( this -> inst_name ) ; free ( _that ) ; } 
 stackfree ( ( this -> inst_construct ) , 0 ) ; 
if ( ( this -> inst_construct ) ) { _that = ( int * ) 
 ( this -> inst_construct ) ; _2stack_delete ( ( struct stack * ) _that ) ; free ( _that ) ; } 
#line 182 "./ntwdefs.cls"

#line 42 "class.cls"

#line 1 "./xelem.cls"
} /* _2instancestruct_delete */ 
#line 27 "./xelem.cls"
int _1xelem_new ( this , lb , rb ) short lb ; short rb ; register struct xelem * this ; 


{ int * _that ; 
 ( this -> left_bound ) = lb ; 
 ( this -> right_bound ) = rb ; 
#line 36 "./xelem.cls"
} /* _1xelem_new */ 


int _2xelem_delete ( this ) register struct xelem * this ; { int * _that ; 
#line 42 "./xelem.cls"
} /* _2xelem_delete */ 


int _12xelem_print ( this ) register struct xelem * this ; { int * _that ; 
printf ( "[ Xelem ] ptr: %x, lb: %d\trb: %d\n" , 
 this , ( this -> left_bound ) , ( this -> right_bound ) ) ; 
#line 43 "class.cls"

#line 1 "./netelem.cls"
} /* _12xelem_print */ 
#line 28 "./netelem.cls"
int _1netelem_new ( this , s , stack , ntype ) char * s ; struct stack * stack ; char ntype ; register struct netelem * this ; { int * _that ; 
 ( ( ( struct link * ) this ) -> type ) = ntype ; 
 ( this -> name ) = ( char * ) strsav ( s ) ; 
 strcpy ( ( this -> name ) , s ) ; 
 ( this -> xs ) = ( struct stack * ) ( stack ) ; 
 ( this -> nmem ) = ( struct netMember * ) ( 0 ) ; 
if ( ntype == 0x04 ) 
 ( this -> type ) = 1 ; 
else 
 ( this -> type ) = 0 ; 

#line 42 "./netelem.cls"
} /* _1netelem_new */ 


int _2netelem_delete ( this ) register struct netelem * this ; { int * _that ; { _that = ( int * ) 
 ( this -> name ) ; free ( _that ) ; } 
#line 49 "./netelem.cls"

if ( ( ( ( struct link * ) this ) -> type ) == 0x05 ) 
{ 
if ( ( this -> xs ) ) 
{ 
 stackfree ( ( this -> xs ) , 0 ) ; { _that = ( int * ) 
 ( this -> xs ) ; _2stack_delete ( ( struct stack * ) _that ) ; free ( _that ) ; } } 
#line 60 "./netelem.cls"
} } /* _2netelem_delete */ 


int _15netelem_print ( this ) register struct netelem * this ; { int * _that ; 
fprintf ( stderr , "[ Netelem ] ptr = %x {\n" , this ) ; 
fprintf ( stderr , "\tname =\t%s\n" , ( this -> name ) ) ; 
fprintf ( stderr , "\txs   =\t%x\n" , ( this -> xs ) ) ; 
fprintf ( stderr , "}\n" ) ; } /* _15netelem_print */ 


int _16netelem_to_db ( this ) register struct netelem * this ; { int * _that ; 
char * * pxs ; 
int i ; 
int size = ( this -> xs ) ? _21stack_limit ( ( struct stack * ) ( this -> xs ) ) - _20stack_base ( ( struct stack * ) ( this -> xs ) ) : 0 ; 

strcpy ( cterm . term_name , ( this -> name ) ) ; 
cterm . term_dim = size ; 
#line 81 "./netelem.cls"

cterm . term_lower = ( long * ) calloc ( ( unsigned ) ( size ) , sizeof ( long ) ) ; 
#line 87 "./netelem.cls"

cterm . term_upper = ( long * ) calloc ( ( unsigned ) ( size ) , sizeof ( long ) ) ; 

if ( ( this -> xs ) ) 
{ 

for ( i = 0 , pxs = _20stack_base ( ( struct stack * ) ( this -> xs ) ) ; pxs < _21stack_limit ( ( struct stack * ) ( this -> xs ) ) ; i ++ , pxs ++ ) 
 cterm . term_lower [ i ] = ( ( struct xelem * ) * pxs ) -> left_bound ; 


for ( i = 0 , pxs = _20stack_base ( ( struct stack * ) ( this -> xs ) ) ; pxs < _21stack_limit ( ( struct stack * ) ( this -> xs ) ) ; i ++ , pxs ++ ) 
 cterm . term_upper [ i ] = ( ( struct xelem * ) * pxs ) -> right_bound ; } 


dmPutDesignData ( dsp_term , CIR_TERM ) ; 
if ( cterm . term_dim ) 
{ 
#line 106 "./netelem.cls"
{ _that = ( int * ) 
 cterm . term_lower ; free ( _that ) ; } 
#line 110 "./netelem.cls"
{ _that = ( int * ) 
 cterm . term_upper ; free ( _that ) ; } } } /* _16netelem_to_db */ 



int _1net_ref_new ( this , pnet , xs ) struct netelem * pnet ; struct stack * xs ; register struct net_ref * this ; 


{ int * _that ; 
 ( ( ( struct link * ) this ) -> type ) = 0x06 ; 
 ( this -> net ) = ( struct netelem * ) ( pnet ) ; 
 ( this -> net_xs ) = ( struct stack * ) ( xs ) ; 
#line 126 "./netelem.cls"
} /* _1net_ref_new */ 


int _2net_ref_delete ( this ) register struct net_ref * this ; { int * _that ; 
#line 132 "./netelem.cls"

if ( ( this -> net_xs ) ) 
{ } 
#line 142 "./netelem.cls"
if ( ( this -> ref_xs ) ) 
{ { _that = ( int * ) 
 ( this -> ref_xs ) ; _2stack_delete ( ( struct stack * ) _that ) ; free ( _that ) ; } } 
#line 44 "class.cls"
} /* _2net_ref_delete */ 
