static char *SccsId = "@(#)cpldm.c 3.1 (TU-Delft) 04/16/87";
/**********************************************************

Name/Version      : cpldm/3.1

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : P. Bingley, J. Venema
Creation date     : 02-Nov-1984
Modified by       : S. de Graaf
Modification date : 07-Mar-1985


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1985 , All rights reserved
**********************************************************/
#include "stdio.h"

FILE * fpi, *fpo;

struct box {
    int     xs;
    int     xe;
    int     yb;
    int     yt;
    struct box *nxt;
};

char   *calloc ();
char   *argv0 = "cpldm";

main (argc, argv)
int     argc;
char   *argv[];
{

    struct box *head[3],
               *last[3];
    struct box *sp,
               *hlp,
               *hv;

    char   *mask[3];
    char    buf[512];
    char    str[40],
            lc[40];

    int     i,
            ch,
            ca,
            cint,
            xts,
            xte,
            ytb,
            ytt;

    mask[0] = "nd";
    mask[1] = "nm";
    mask[2] = "np";

    if (argc != 3 || strcmp (argv[1], argv[2]) == 0) {
	fprintf (stderr, "Usage: %s infile outfile\n", argv0);
	exit (1);
    }

    if (!(fpi = fopen (argv[1], "r"))) {
	fprintf (stderr, "%s: Can't open file: %s\n", argv0, argv[1]);
	exit (1);
    }
    if ((fpo = fopen (argv[2], "r"))) {
	fprintf (stderr, "%s: Existing file: %s\n", argv0, argv[2]);
	exit (1);
    }
    if (!(fpo = fopen (argv[2], "w"))) {
	fprintf (stderr, "%s: Can't open file: %s\n", argv0, argv[2]);
	exit (1);
    }

    while (1) {			/* while not end of input */

	head[0] = head[1] = head[2] = 0;

	while (1) {		/* while not end of model */
	    i = 0;
	    while ((cint = fgetc (fpi)) != '\n') {
		if (cint == EOF) {
		    fclose (fpi);/* input */
		    fclose (fpo);/* output */

		    if (head[0] || head[1] || head[2]) {
			fprintf (stderr, "%s: Error, unexpected eof\n", argv0);
			exit (1);
		    }
		    exit (0);
		}
		buf[i++] = cint;
	    }
	    buf[i] = '\0';

	    if (sscanf (buf, "%s", str) == 0)
		continue;	/* empty line */
	    if (*str == ':')
		continue;	/* comment line */
	    if (strcmp (str, "me") == 0)
		break;		/* end of model */

	    if (strcmp (str, "box") == 0) {/* box statement */
		if (sscanf (buf, "%s%s%d%d%d%d", str, lc, &xts, &xte, &ytb, &ytt) <= 0) {
		    fprintf (stderr, "%s: Error, illegal box statement:\n", argv0);
		    fprintf (stderr, "--> %s\n", buf);
		    exit (1);
		}

		switch (lc[1]) {
		    case 'd': 
			i = 0;
			break;
		    case 'm': 
			i = 1;
			break;
		    case 'p': 
			i = 2;
			break;
		    default: 
			goto printit;
		}

		if (!(hlp = (struct box *) calloc (1, sizeof (struct box)))) {
		    fprintf (stderr, "%s: Can't alloc enough core\n", argv0);
		    exit (1);
		}

		if (head[i])
		    last[i] -> nxt = hlp;
		else
		    head[i] = hlp;

		last[i] = hlp;
		last[i] -> xs = xts;
		last[i] -> xe = xte;
		last[i] -> yb = ytb;
		last[i] -> yt = ytt;
	    }
	    else {		/* other statement */
	printit: 
		fprintf (fpo, "%s\n", buf);
	    }
	}

	for (i = 0; i <= 2; i++) {
	    sp = head[i];
	    while (sp) {
		do {
		    ca = 0;
		    hv = sp;
		    hlp = sp -> nxt;
		    while (hlp) {
			ch = 0;
			if (sp -> xs == hlp -> xs && sp -> xe == hlp -> xe) {
			    if (sp -> yt >= hlp -> yb && sp -> yt < hlp -> yt) {
				sp -> yt = hlp -> yt;
				ch = 1;
			    }
			    if (sp -> yb <= hlp -> yt && sp -> yb > hlp -> yb) {
				sp -> yb = hlp -> yb;
				ch = 1;
			    }
			    if (sp -> yb <= hlp -> yb && sp -> yt >= hlp -> yt)
				ch = 1;
			}
			else {
			    if (sp -> yb == hlp -> yb && sp -> yt == hlp -> yt) {
				if (sp -> xe >= hlp -> xs && sp -> xe < hlp -> xe) {
				    sp -> xe = hlp -> xe;
				    ch = 1;
				}
				if (sp -> xs <= hlp -> xe && sp -> xs > hlp -> xs) {
				    sp -> xs = hlp -> xs;
				    ch = 1;
				}
				if (sp -> xs <= hlp -> xs && sp -> xe >= hlp -> xe)
				    ch = 1;
			    }
			}
			if (ch == 1) {
			    hv -> nxt = hlp -> nxt;
			    cfree (hlp);
			    hlp = hv;
			    ca = 1;
			}
			hv = hlp;
			hlp = hlp -> nxt;
		    }
		} while (ca == 1);

		fprintf (fpo, "box %s %d %d %d %d\n",
			mask[i], sp -> xs, sp -> xe, sp -> yb, sp -> yt);

		hlp = sp;
		sp = sp -> nxt;
		cfree (hlp);
	    }
	}
	fprintf (fpo, "me\n");
    }
}
