/*
 * toolwait-0.9 - Sun-compatible clone of toolwait
 *
 * This utility prevents multiple client startup from wasting the CPU.  :-)
 * The basic idea is to establish an X connection, then fork a client and
 * wait for three kinds of events:
 *
 * (1) child death (client failed to start)
 * (2) new top-level window mapped (client started)
 * (3) timeout
 *
 * In case 1 the child's exit starus is returned; in case 2, toolwait exits
 * with status 0; in case 3, a message is printed and toolwait exits with
 * status 1.
 *
 * Normally, if you start clients in the background, they all compete with
 * each other for CPU and for access to the X server.  toolwait makes sure
 * each client finishes (most of) its setup before the next client starts,
 * assuming you toolwait each client.
 *
 * This uses XView, since it's easier to program for this.  (Besides, so does
 * Sun's version...)  However, I note that a static version is some 1.2MB and
 * a shared libc+X static XView link is 980k, so the next version will probably
 * be pure Xlib.
 *
 * I am releasing this into the public domain.  It's hardly worth any form of
 * copyright...
 */

#include <stdio.h>
#include <xview/xview.h>
#include <xview/server.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <signal.h>

#define DEFAULT_TIMEOUT 15	/* default timeout for command startup */

static int status;
static char *prog;

static void
ding_timeout(client, type)
    Notify_client client;
    int type;
{
    status = 1;
    notify_stop();
}

static Notify_value
ding_failed(client, pid, pstat, rusage)
    Notify_client client;
    int pid;
    union wait *pstat;
    struct rusage *rusage;
{
    if (WIFEXITED(*pstat))
	status = WEXITSTATUS(*pstat);
    else
    {
	psignal(WTERMSIG(*pstat), prog);
	status = -1;
    }
    notify_stop();
    return NOTIFY_DONE;
}

static void
ding_succeeded(server, dpy, xev, ob)
    Xv_server *server;
    Display *dpy;
    XEvent *xev;
    Xv_opaque ob;
{
    /* by rights, I should check for a CreateNotify first */
    if (xev->type != MapNotify || xev->xany.send_event)
	return;
    status = 0;
    notify_stop();
}

int
main(argc, argv)
    int argc;
    char **argv;
{
    struct itimerval itv;
    Xv_Server server;
    int pid, arg, u;
    char buf[1024];
    Display *dpy;
    char *disp;

    if ((prog = strrchr(argv[0], '/')))
	prog++;
    else
	prog = argv[0];
    itv.it_interval.tv_sec = itv.it_interval.tv_usec =
	itv.it_value.tv_usec = 0;
    itv.it_value.tv_sec = DEFAULT_TIMEOUT;
    u = 0;
    disp = 0;
    for (arg = 1; arg < argc && argv[arg][0] == '-'; arg++)
    {
	pid = strlen(argv[arg]);
	if (argv[arg][1] == 'd' && strncmp(argv[arg], "-display", pid) == 0)
	    disp = argv[++arg];
	else if (argv[arg][1] == 't' &&
		 strncmp(argv[arg], "-timeout", pid) == 0)
	    itv.it_value.tv_sec = atoi(argv[++arg]);
	else if (argv[arg][1] == 'h' && strncmp(argv[arg], "-help", pid) == 0)
	    u = 1;
	else if (argv[arg][1] == '-' && argv[arg][2] == '\0')
	{
	    arg++;
	    break;
	}
	else
	    u = 2;
    }
    if (u || arg == argc)
    {
	fprintf(stderr,
		"usage: %s [-display dpy] [-timeout sec] [-help] command\n",
		prog);
	return u != 1;
    }
    if (itv.it_value.tv_sec <= 0)
    {
	fprintf(stderr, "%s: invalid timeout, using default of %d\n",
		prog, DEFAULT_TIMEOUT);
	itv.it_value.tv_sec = DEFAULT_TIMEOUT;
    }
    if (disp)
    {
	sprintf(buf, "DISPLAY=%s", disp);
	putenv(buf);
    }
    server = xv_init(0);	/* don't re-parse arguments! */
    /* remaining args are the command */
    prog = argv[arg];
    /* set the timer trap */
    notify_set_itimer_func((int) main, (Notify_func) ding_timeout,
			   ITIMER_REAL, &itv, 0);
    /* set the window trap; this is the fun part... */
    dpy = (Display *) xv_get(server, XV_DISPLAY);
    xv_set(server,
	   SERVER_EXTERNAL_XEVENT_MASK,
		DefaultRootWindow(dpy),
		SubstructureNotifyMask,
		server,		/* I bet it dislikes this... */
	   SERVER_EXTERNAL_XEVENT_PROC, (Notify_func) ding_succeeded, server,
	   0);
    /* create the child process */
    switch (pid = fork())
    {
    case -1:
	/* whoops! */
	perror(prog);
	return 1;
    case 0:
	/* display is already in the environment, per the above */
	execvp(prog, argv + arg);
	/* whoa, sh*t! */
	perror(prog);
	fflush(stderr);
	_exit(-1);
    default:
	/* set the child trap */
	notify_set_wait3_func((int) main, (Notify_func) ding_failed, pid);
    }
    /* do it to it! */
    notify_start();
    /* we have, one way or another, a status to return */
    return status;
}
