
/* Sept, 17. 92                                   */
/* $Id: xhtalk.h,v 2.9 92/12/13 15:17:18 kdh Exp $
 * $Log:	xhtalk.h,v $
 * Revision 2.9  92/12/13  15:17:18  kdh
 *  new options: idle-colors
 *              bell in xhchat
 *              automatic toplevel width (font width)
 *              dynamic column number
 *              activity light
 * 
 * Revision 2.8  92/11/16  10:21:34  kdh
 *  file hierarchy changed, new x-based talk, bug-fixes
 * 
 * Revision 2.7  92/10/23  14:08:14  kdh
 * display idle time in buttons
 * 
 * Revision 2.6  92/10/19  16:27:45  kdh
 * New function AddLabel (closes memory leak)
 * 
 * Revision 2.5  92/10/14  08:59:13  kdh
 * memory leak closed
 * 
 * Revision 2.4  92/10/07  12:02:49  kdh
 *  replaced strdup->calloc/strcpy
 * wrong index in read_input_from_stdin() corrected
 * 
 * Revision 2.3  92/10/07  11:58:42  kdh
 * bug fixed for sun3
 * 
 * Revision 2.2  92/09/30  09:02:21  kdh
 * fork error fixed
 * 
 * Revision 2.1  92/09/25  00:29:55  kdh
 * initial new version with selfmade finger
 * 
 */

/*

Copyright (C) 1992 Klaus Hartenstein

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted, provided
that the above copyright notice appear in all copies and that both that
copyright notice and this permission notice appear in supporting
documentation.  This software is provided "as is" without express or
implied warranty.

*/



#define VERSION $Header: /home/i31s23s/kdh/pub/xhtalk/Xhtalk-2.9/RCS/xhtalk.h,v 2.9 92/12/13 15:17:18 kdh Exp $

#ifdef  sgi
#define _BSD_COMPAT
#endif
#include <signal.h>
#include <sys/time.h>
#include <ctype.h>
#include <stdio.h>
#include <X11/Xatom.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/MenuButton.h>
#ifdef HAS_XPM
#include <X11/xpm.h>
#endif
#include "globaldefs.h"
#include "bitmaps.h"


static char *WeekDays[]= {
  "Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"};

#include "list.h"

typedef struct UserInfo{               /* for array of user Info               */
  char    *TalkCmd;
  char    *Display;
  char    *FingerLine;
  Boolean onConsole;
  int     Idle;
}UserInfo;

typedef struct _colors{
  Pixel idleOne;
  Pixel idleTwo;
  Pixel idleThree;
}colors;

/********************************************************************************/
/* global variables                                                             */
/********************************************************************************/

List *HostList;                         /* list of all hosts to be asked        */
List *NamesList;                        /* list of all usernames ro be searched */
List *TmpList;                          /*                                      */

char *HomeDir;                          /* users home directory                 */
char *ConfigFile;                       /* user defined config-file             */
char *ProgName;                         /* argv[0]                              */
char *UserDefinedProg;                  /* user defined prog instead of talk    */

Boolean Bell;                           /* flag for bell if changes             */
Boolean ShowTty;                        /* false, if only consoles displayed    */
Boolean AddInfo;                        /* tty or console ??                    */
Boolean Debug;                          /* debug mode: print errors in finger   */
Boolean ChildIsRunning;                 /* true, if child process runs          */
Boolean WaitForChild;                   /* provides xhtalk from running more
				 	 * than ONE child process               */
Boolean DisplayIdle;                    /* display idle time in cmd-widget      */
Boolean HideWhenIdle;                   /* hide user which exceeds idle time    */
Boolean ActivityLight;                  /* if true, display activity light      */
Boolean AllConsoles;                    /* list all consoles, not only the
					 * smallest idle time                   */
Boolean UseColor;                       /* if true use idle colors              */
int  AskTime;                           /* user defined ask time                */
int  FontHeight;                        /* of label widget in pixels            */
int  FontWidth;                         /* width of font                        */
int  HeightOfLabel;                     /* height of xhtalk label               */
int  NumChars;                          /* number of chars used in cmd-widget   */
int TimeOut;                            /* timeout for finger in secs           */
int Idle;                               /* idle time  in minutes                */
int ChildID;                            /* process id of child process          */ 

int aargc;                              /* to make argc, argv global            */
char **aargv;

char str[256];

Pixmap LabelPM ,IconPM,l_cons_PM,l_tty_PM, IconPM, activityPM;

Widget                                   /* several widgets...                  */
  list,  
  box,
  quit,
  lbl,
  toplevel,
  dlg,
  dlgshell,
  form,
  infosh,
  FiLiW,
  selectsh,
  chatW,
  talkW,
  userW,
  pnd;

Widget w_arr[NUM_WID];                       /* widgets for 'command'-buttons      */
int NumW;                                    /* number of created Widgets          */
static int MaxWidgets=0;                     /* number of actually created widgets */

UserInfo UI[NUM_WID];                        /* array of user Infos                */

colors IdleColors;                           /* three colors for idle values       */


XEvent  
  event;

XtAppContext
  app_con;

/********************************************************************************/
/* data structured and defines for application resources                        */
/********************************************************************************/

typedef struct{                            /* Application resources             */
  int Ask_Interval;                        /* ask-interval                      */
  Boolean tty;                             /* display only users on concole     */
  Boolean Help;                            /* print help message, if true       */
  Boolean Info;                            /*                                   */
  Boolean Debug;                           /* debug mode on/off                 */
  Boolean dIdle;                           /* display idle time                 */
  Boolean listall;                         /* list all consoles                 */
  Boolean light;                           /* activity light                    */
  Boolean useColor;                        /* if true use idle colors           */
  char *Config_File_Name;                  /* ..                                */
  char *prog;                              /* user defined prog instead of talk */
  int Timeout;                             /* timeout for finger in secs        */
  int Idle;
  Pixel idleOneC;
  Pixel idleTwoC;
  Pixel idleThreeC;
  XFontStruct  *cmdFont;
}AppData, *AppDataPtr;                     /* xhtalk                            */

AppData app_data;

#define XtNupdateVal   "update"
#define XtCUpdateVal   "Update"
#define XtNtty         "tty"
#define XtCTty         "Tty"
#define XtNconfig      "config"
#define XtCConfig      "Config"
#define XtNtout        "timeout"
#define XtCTout        "Timeout"
#define XtNhelp        "help"
#define XtCHelp        "Help"
#define XtCInfo        "Info"
#define XtNinfo        "info"
#define XtNidle        "idle"
#define XtCIdle        "Idle"
#define XtNdebug       "debug"
#define XtCDebug       "Debug"
#define XtNdIdle       "dIdle"
#define XtCDIdle       "DIdle"
#define XtNprog        "prog"
#define XtCProg        "Prog"
#define XtNlistall     "listall"
#define XtCListall     "Listall"
#define XtNlight       "light"
#define XtCLight       "Light"
#define XtNidleTwoC    "idleTwoColor"
#define XtCIdleTwoC    "IdleTwoColor"
#define XtNidleThreeC  "idleThreeColor"
#define XtCIdleThreeC  "IdleThreeColor"
#define XtNidleOneC    "idleOneColor"
#define XtCIdleOneC    "IdleOneColor"
#define XtNuseColor    "useColor"
#define XtCUseColor    "UseColor"
#define XtNbuttonFont  "buttonFont"
#define XtCButtonFont  "ButtonFont"


static XrmOptionDescRec options[]={                         /* cmdline opts */
  {"-update",      "*update",        XrmoptionSepArg, NULL   },
  {"-tty",         "*tty",           XrmoptionNoArg,  "False"},
  {"+info",        "*info",          XrmoptionNoArg,  "True" },
  {"-info",        "*info",          XrmoptionNoArg,  "False"},
  {"+tty",         "*tty",           XrmoptionNoArg,  "True" },
  {"-f",           "*config",        XrmoptionSepArg, NULL   },
  {"-timeout",     "*timeout",       XrmoptionSepArg, NULL   },
  {"-idle",        "*idle",          XrmoptionSepArg, NULL   },
  {"-debug",       "*debug",         XrmoptionNoArg,  "True" },
  {"-h",           "*help",          XrmoptionNoArg,  "True" },
  {"-dIdle",       "*dIdle",         XrmoptionNoArg,  "False"},
  {"+dIdle",       "*dIdle",         XrmoptionNoArg,  "True" },
  {"-didle",       "*dIdle",         XrmoptionNoArg,  "False"},
  {"+didle",       "*dIdle",         XrmoptionNoArg,  "True" },
  {"-help",        "*help",          XrmoptionNoArg,  "True" },
  {"-prog",        "*prog",          XrmoptionSepArg, NULL   },
  {"-all",         "*listall",       XrmoptionNoArg,  "True" },
  {"-dlight",      "*light",         XrmoptionNoArg,  "False"},
  {"+dlight",      "*light",         XrmoptionNoArg,  "True" },
  {"-dLight",      "*light",         XrmoptionNoArg,  "False"},
  {"+dLight",      "*light",         XrmoptionNoArg,  "True" },
  {"-color",       "*useColor",      XrmoptionNoArg,  "False"},
  {"+color",       "*useColor",      XrmoptionNoArg,  "True" },
  {"-idleOneCol",  "*idleOneColor",  XrmoptionSepArg, NULL   },  
  {"-idleTwoCol",  "*idleTwoColor",  XrmoptionSepArg, NULL   },  
  {"-idleThreeCol","*idleThreeColor",XrmoptionSepArg, NULL   },
  {"-buttonFont",  "*buttonFont",    XrmoptionSepArg, NULL   },
  {"-buttonfont",  "*buttonFont",    XrmoptionSepArg, NULL   },
  {"-bfn",         "*buttonFont",    XrmoptionSepArg, NULL   }
};

static XtResource resources[]={                             /* app resources */
  {
    XtNupdateVal,
    XtCUpdateVal,
    XtRInt,
    sizeof(int),
    XtOffset(AppDataPtr, Ask_Interval),
    XtRImmediate,
    (XtPointer)6
    },{
      XtNtty,
      XtCTty,
      XtRBoolean,
      sizeof(Boolean),
      XtOffset(AppDataPtr, tty),
      XtRImmediate,
      (XtPointer) True
      },{
	XtNconfig,
	XtCConfig,
	XtRString,
	sizeof(char*),
	XtOffset(AppDataPtr,Config_File_Name),
	XtRString,
	NULL
	},{
	  XtNtout,
	  XtCTout,
	  XtRInt,
	  sizeof(int),
	  XtOffset(AppDataPtr,Timeout),
	  XtRImmediate,
	  (XtPointer)20
	  },{
	    XtNidle,
	    XtCIdle,
	    XtRInt,
	    sizeof(int),
	    XtOffset(AppDataPtr,Idle),
	    XtRImmediate,
	    (XtPointer)60
	    },{
	      XtNhelp,
	      XtCHelp,
	      XtRBoolean,
	      sizeof(Boolean),
	      XtOffset(AppDataPtr, Help),
	      XtRImmediate,
	      (XtPointer) False
	      },{
		XtNinfo,
		XtCInfo,
		XtRBoolean,
		sizeof(Boolean),
		XtOffset(AppDataPtr, Info),
		XtRImmediate,
		(XtPointer) True
		},{
		  XtNdebug,
		  XtCDebug,
		  XtRBoolean,
		  sizeof(Boolean),
		  XtOffset(AppDataPtr, Debug),
		  XtRImmediate,
		  (XtPointer) False
		  },{
		    XtNdIdle,
		    XtCDIdle,
		    XtRBoolean,
		    sizeof(Boolean),
		    XtOffset(AppDataPtr, dIdle),
		    XtRImmediate,
		    (XtPointer) True
		    },{
		      XtNprog,
		      XtCProg,
		      XtRString,
		      sizeof(char*),
		      XtOffset(AppDataPtr, prog),
		      XtRString,
		      NULL
		      },{
			XtNlistall,
			XtCListall,
			XtRBoolean,
			sizeof(Boolean),
			XtOffset(AppDataPtr, listall),
			XtRImmediate,
			(XtPointer) False
			},{
			  XtNlight,
			  XtCLight,
			  XtRBoolean,
			  sizeof(Boolean),
			  XtOffset(AppDataPtr, light),
			  XtRImmediate,
			  (XtPointer) True
			  },{
			    XtNuseColor,
			    XtCUseColor,
			    XtRBoolean,
			    sizeof(Boolean),
			    XtOffset(AppDataPtr, useColor),
			    XtRImmediate,
			    (XtPointer) True
			    },{
			      XtNidleTwoC,
			      XtCIdleTwoC,
			      XtRPixel,
			      sizeof(Pixel),
			      XtOffset(AppDataPtr, idleTwoC),
			      XtRString,
			      XtDefaultBackground
			      },{
				XtNidleOneC,
				XtCIdleOneC,
				XtRPixel,
				sizeof(Pixel),
				XtOffset(AppDataPtr, idleOneC),
				XtRString,
				XtDefaultBackground
				},{
				  XtNidleThreeC,
				  XtCIdleThreeC,
				  XtRPixel,
				  sizeof(Pixel),
				  XtOffset(AppDataPtr, idleThreeC),
				  XtRString,
				  XtDefaultBackground
				  },{
				    XtNbuttonFont,
				    XtCButtonFont,
				    XtRFontStruct,
				    sizeof(XFontStruct *),
				    XtOffset(AppDataPtr, cmdFont),
				    XtRString,
				    XtDefaultFont
				  }
};

static String fallback_resources[] = {
  "*resize:           True",
  "*showGrip:         False",
  "*allowShellResize: True",
  "*buttonFont:       -schumacher-*-medium-r-*-*-10-*-*-*-*-50-*-*",     /* default font */
  "*font:             -schumacher-*-medium-r-*-*-10-*-*-*-*-50-*-*",     
  "*idleTwoColor:     grey90",
  "*idleThreeColor:   grey80",
  "*idleOneColor:     white",
  NULL
  };


/********************************************************************************/
/* translation tables and actions                                               */
/********************************************************************************/

extern void PlaceShell();
extern void PopupShell();
extern void PopdownShell();
extern void SetGlobalWidgetNum();
                                        /* actions for shell handling       */
static XtActionsRec menu_actions[]={
  {"place-shell",PlaceShell},
  {"popup-shell",PopupShell},
  {"popdown-shell",PopdownShell},
  {"set-num",SetGlobalWidgetNum},
  NULL
  };
  
                                       /* translation table for userbuttons */
static String mb_trans=
  "<LeaveWindow>: reset()\n\
   <EnterWindow>: set()\n\
   <Btn1Down>   : set() set-num() place-shell(SELECT) XtMenuPopup(selectsh)\n\
   <Btn1Up>     : XtMenuPopdown(selectsh)\n\
   <Btn3Down>   : set() place-shell(INFO) popup-shell(INFO)\n\
   <Btn2Up>     : popdown-shell(INFO)\n\
   <Btn2Down>   : set() place-shell(INFO) popup-shell(INFO)\n\
   <Btn3Up>     : popdown-shell(INFO)";

                                       /* translation table for menubuttons */
static String cmd_trans=
  "<EnterWindow>: set()\n\
   <LeaveWindow>: reset()\n\
   <Btn1Up>:      set() notify() unset()";

                                       /* translation table for infoshell   */
static String msh_trans=
  "<Btn1Up>     : XtMenuPopdown(selectsh)";

#define TRANS(t) XtParseTranslationTable(t)


GC lineGC;
