/* > xfft.c */
/* Daniel F. Smith, 1994 */
/* Real-time FFT in a window from stdin */

#include <stdio.h>
#include <stdlib.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>

#include "Chart.h"

#ifndef FLOATINGPOINT
/* use integer routines */
#include "ffti.h"
#define FFT ffti_real
#define POWER ffti_power
typedef complexi complex;
typedef cint ctype;
#else
/* use floating-point routines */
#include "fft.h"
#define FFT fft_real
#define POWER fft_power
/* typedef complex complex; */
typedef cfloat ctype;
#endif

#define FFTSIZE 256
#define TIMEOUT 10 /* ms */
#define XTWTAC(a) XtWidgetToApplicationContext(a)

extern void exit(int);
static unsigned char buffer[FFTSIZE],chartbuf[1+FFTSIZE/2];
static ctype fftbuf[FFTSIZE];
static String resources[]={
	"*quit.label: Quit",
	"*charts.fromVert: buttonbox",
	"*Chart.scaleY: 3",
	NULL};
	
static void TimeOut(Widget w,XtIntervalId *id) {
	static int l,i;
	static ctype max;
	
	l=fread((void *)buffer,sizeof(unsigned char),FFTSIZE,stdin);
	for(i=0;i<FFTSIZE;i++) fftbuf[i]=((int)(buffer[i])-128);
	FFT(fftbuf,FFTSIZE,1);
	fftbuf[0]=0; /* clobber DC */
	max=POWER((complex *)fftbuf,FFTSIZE/2);
	max=1+max/256;
	for(i=0;i<=FFTSIZE/2;i++) chartbuf[i]=(fftbuf[i]/max);
	XtVaSetValues(w,XtNredraw,True,NULL);
	if (l!=FFTSIZE*sizeof(unsigned char))
		return;
	XtAppAddTimeOut(XTWTAC(w),TIMEOUT,(XtTimerCallbackProc)TimeOut,w);
	}

int main(int argc,char *argv[]) {
	XtAppContext app_context;
	Widget topLevel,form,bbox,quit,fft;
	
	topLevel=XtVaAppInitialize(&app_context,
				   "XFft",
				   NULL,0,
				   &argc,argv,
				   resources,NULL);
	/* There should be some filenames left in argc/argv */
	if (argc>1) {
		fprintf(stderr,"Syntax: %s [standard toolkit options]\n"
			"Takes input from stdin.\n",
			argv[0]);
		exit(1);
		}

	form=XtCreateManagedWidget("form",formWidgetClass,topLevel,NULL,0);
	bbox=XtCreateManagedWidget("buttonbox",boxWidgetClass,form,NULL,0);

	/* Create command button, add callbacks below */
	quit=XtCreateManagedWidget("quit",commandWidgetClass,bbox,NULL,0);

	fft=XtVaCreateManagedWidget("charts",chartWidgetClass,form,
				      XtNdatap,chartbuf,
				      XtNndata,1+FFTSIZE/2,
				      XtNscaleX,1,
				      NULL);

	/* command callbacks */
	XtAddCallback(quit,XtNcallback,(XtCallbackProc)exit,NULL);
	XtAppAddTimeOut(XTWTAC(fft),TIMEOUT,(XtTimerCallbackProc)TimeOut,fft);

	XtRealizeWidget(topLevel);
	XtAppMainLoop(app_context);
	return 0;
	}
