{ These formulae apply Newton's method to various functions. For each
  function we use an approximation to find the root within limit 1/p1.

  Newton's method:  x(n+1) = x(n) - f(x(n))/f'(x(n))
}

newtsin  (XYAXIS) {z=pixel: z=z-sin(z)/cos(z), |sin(z)|>=1/p1}
newtcos  (XYAXIS) {z=pixel: z=z+cos(z)/sin(z), |cos(z)|>=1/p1}
newtrt   (XAXIS)  {z=pixel: z=z+(1-z^p2)/z^(p2-1)/p2, |1-z^p2|>=1/p1}
newtcub           {z=pixel: z=z-(z^3+(p2-1)*z-p2)/(3*z^2+p2-1), |z^3+(p2-1)*z-p2|>=1/p1}
newtsinh (XYAXIS) {z=pixel: z=z-sinh(z)/cosh(z), |sinh(z)|>=1/p1}
newtcosh (XYAXIS) {z=pixel: z=z-cosh(z)/sinh(z), |cosh(z)|>=1/p1}

test {z=0, k=0.5-pixel^2: z=z-(z*z*z+z*k-z-k)/(3*z*z+k-1), |z*z*z+z*k-z-k|>=1/p1}
