/*
 * File:      wb_gdi.cc
 * Purpose:     GDI (Graphics Device Interface) objects and functions
 * Author:      Julian Smart
 * Created:     1993
 * Updated:     August 1994
 * RCS_ID:      $Id: wb_gdi.cc,v 1.4 1994/08/14 22:59:35 edz Exp $
 * Copyright:   (c) 1993, AIAI, University of Edinburgh
 */

static const char sccsid[] = "%W% %G%";

#ifdef __GNUG__
#pragma implementation
#endif

#include "common.h"
#include "wx_setup.h"
#include "wx_list.h"
#include "wx_utils.h"
#include "wx_main.h"
#include "wx_gdi.h"

// If not MS C++, don't include wx.h: we'll just include
// the minimum set of files.
// If MS C++, we'll use a precompiled header instead.
#if !defined(_MSC_VER) && !defined(wx_wxh)
#define wx_wxh
#endif

#include "wx.h"

#ifdef wx_x
extern Colormap wxMainColormap;
#endif
#ifdef wx_xview
extern Xv_Server xview_server;
#endif

wxbFont::wxbFont (void)
{
  __type = wxTYPE_FONT;
}

/* Constructor for a font. Note that the real construction is done
 * in wxDC::SetFont, when information is available about scaling etc.
 */
wxbFont::wxbFont (int PointSize, int Family, int Style, int Weight, Bool Underline)
{
  __type = wxTYPE_FONT;
}

wxbFont::~wxbFont ()
{
}

// Colour

wxColour::wxColour (void)
{
  __type = wxTYPE_COLOUR;
  isInit = FALSE;
#ifdef wx_x
  pixel = -1;
#endif
#ifdef wx_msw
  pixel = 0;
#endif
//  wxTheColourList->Append (this);
}

wxColour::wxColour (unsigned char r, unsigned char g, unsigned char b)
{
  __type = wxTYPE_COLOUR;
  red = r;
  green = g;
  blue = b;
  isInit = TRUE;
#ifdef wx_x
  pixel = -1;
#endif
#ifdef wx_msw
  pixel = RGB (red, green, blue);
#endif
//  wxTheColourList->Append (this);
}

wxColour::wxColour (const char *col)
{
  __type = wxTYPE_COLOUR;
  wxColour *the_colour = wxTheColourDatabase->FindColour (col);
  if (the_colour)
    {
      red = the_colour->Red ();
      green = the_colour->Green ();
      blue = the_colour->Blue ();
      isInit = TRUE;
    }
  else
    {
      red = 0;
      green = 0;
      blue = 0;
      isInit = FALSE;
    }
#ifdef wx_x
  pixel = -1;
#endif
#ifdef wx_msw
  pixel = RGB (red, green, blue);
#endif
//  wxTheColourList->Append (this);
}

wxColour::~wxColour (void)
{
//  wxTheColourList->DeleteObject (this);
}

wxColour& wxColour::operator =(wxColour& src)
{
  red = src.red;
  green = src.green;
  blue = src.blue;
  pixel = src.pixel;
  isInit = src.isInit;
  return (*this);
}

wxColour& wxColour::operator = (const char *col)
{
  wxColour *the_colour = wxTheColourDatabase->FindColour (col);
  if (the_colour)
    {
      red = the_colour->Red ();
      green = the_colour->Green ();
      blue = the_colour->Blue ();
      isInit = TRUE;
    }
  else
    {
      red = 0;
      green = 0;
      blue = 0;
      isInit = FALSE;
    }
#ifdef wx_x
  pixel = -1;
#endif
#ifdef wx_msw
  pixel = RGB (red, green, blue);
#endif
  return (*this);
}

void wxColour::Set (unsigned char r, unsigned char g, unsigned char b)
{
  red = r;
  green = g;
  blue = b;
  isInit = TRUE;
#ifdef wx_x
  pixel = -1;
#endif
#ifdef wx_msw
  pixel = RGB (red, green, blue);
#endif

}

void wxColour::Get (unsigned char *r, unsigned char *g, unsigned char *b)
{
  *r = red;
  *g = green;
  *b = blue;
}

/*
 * Colour map
 *
 */

wxbColourMap::wxbColourMap (void)
{
}

wxbColourMap::~wxbColourMap (void)
{
}

wxColourDatabase::wxColourDatabase (int type):
wxList (type)
{
}

wxColourDatabase::~wxColourDatabase (void)
{
  // Cleanup Colour allocated in Initialize()
  wxNode *node = First ();
  while (node)
    {
      wxColour *col = (wxColour *) node->Data ();
      wxNode *next = node->Next ();
      delete col;
      node = next;
    }
}

// Colour database stuff
void wxColourDatabase::Initialize (void)
{
  // Don't initialize for X: colours are found
  // in FindColour below.
#ifdef wx_msw
  Append ("AQUAMARINE", new wxColour (112, 219, 147));
  Append ("BLACK", new wxColour (0, 0, 0));
  Append ("BLUE", new wxColour (0, 0, 255));
  Append ("BLUE VIOLET", new wxColour (159, 95, 159));
  Append ("BROWN", new wxColour (165, 42, 42));
  Append ("CADET BLUE", new wxColour (95, 159, 159));
  Append ("CORAL", new wxColour (255, 127, 0));
  Append ("CORNFLOWER BLUE", new wxColour (66, 66, 111));
  Append ("CYAN", new wxColour (0, 255, 255));
  Append ("DARK GREY", new wxColour (47, 47, 47));	// ?

  Append ("DARK GREEN", new wxColour (47, 79, 47));
  Append ("DARK OLIVE GREEN", new wxColour (79, 79, 47));
  Append ("DARK ORCHID", new wxColour (153, 50, 204));
  Append ("DARK SLATE BLUE", new wxColour (107, 35, 142));
  Append ("DARK SLATE GREY", new wxColour (47, 79, 79));
  Append ("DARK TURQUOISE", new wxColour (112, 147, 219));
  Append ("DIM GREY", new wxColour (84, 84, 84));
  Append ("FIREBRICK", new wxColour (142, 35, 35));
  Append ("FOREST GREEN", new wxColour (35, 142, 35));
  Append ("GOLD", new wxColour (204, 127, 50));
  Append ("GOLDENROD", new wxColour (219, 219, 112));
#ifdef wx_msw
  Append ("GREY", new wxColour (128, 128, 128));
#else
  Append ("GREY", new wxColour (192, 192, 192));
#endif
  Append ("GREEN", new wxColour (0, 255, 0));
  Append ("GREEN YELLOW", new wxColour (147, 219, 112));
  Append ("INDIAN RED", new wxColour (79, 47, 47));
  Append ("KHAKI", new wxColour (159, 159, 95));
  Append ("LIGHT BLUE", new wxColour (191, 216, 216));
#ifdef wx_msw
  Append ("LIGHT GREY", new wxColour (192, 192, 192));
#else
  Append ("LIGHT GREY", new wxColour (168, 168, 168));
#endif
  Append ("LIGHT STEEL BLUE", new wxColour (143, 143, 188));
  Append ("LIME GREEN", new wxColour (50, 204, 50));
  Append ("LIGHT MAGENTA", new wxColour (255, 0, 255));
  Append ("MAGENTA", new wxColour (255, 0, 255));
  Append ("MAROON", new wxColour (142, 35, 107));
  Append ("MEDIUM AQUAMARINE", new wxColour (50, 204, 153));
  Append ("MEDIUM GREY", new wxColour (100, 100, 100));
  Append ("MEDIUM BLUE", new wxColour (50, 50, 204));
  Append ("MEDIUM FOREST GREEN", new wxColour (107, 142, 35));
  Append ("MEDIUM GOLDENROD", new wxColour (234, 234, 173));
  Append ("MEDIUM ORCHID", new wxColour (147, 112, 219));
  Append ("MEDIUM SEA GREEN", new wxColour (66, 111, 66));
  Append ("MEDIUM SLATE BLUE", new wxColour (127, 0, 255));
  Append ("MEDIUM SPRING GREEN", new wxColour (127, 255, 0));
  Append ("MEDIUM TURQUOISE", new wxColour (112, 219, 219));
  Append ("MEDIUM VIOLET RED", new wxColour (219, 112, 147));
  Append ("MIDNIGHT BLUE", new wxColour (47, 47, 79));
  Append ("NAVY", new wxColour (35, 35, 142));
  Append ("ORANGE", new wxColour (204, 50, 50));
  Append ("ORANGE RED", new wxColour (255, 0, 127));
  Append ("ORCHID", new wxColour (219, 112, 219));
  Append ("PALE GREEN", new wxColour (143, 188, 143));
  Append ("PINK", new wxColour (188, 143, 234));
  Append ("PLUM", new wxColour (234, 173, 234));
  Append ("PURPLE", new wxColour (176, 0, 255));
  Append ("RED", new wxColour (255, 0, 0));
  Append ("SALMON", new wxColour (111, 66, 66));
  Append ("SEA GREEN", new wxColour (35, 142, 107));
  Append ("SIENNA", new wxColour (142, 107, 35));
  Append ("SKY BLUE", new wxColour (50, 153, 204));
  Append ("SLATE BLUE", new wxColour (0, 127, 255));
  Append ("SPRING GREEN", new wxColour (0, 255, 127));
  Append ("STEEL BLUE", new wxColour (35, 107, 142));
  Append ("TAN", new wxColour (219, 147, 112));
  Append ("THISTLE", new wxColour (216, 191, 216));
  Append ("TURQUOISE", new wxColour (173, 234, 234));
  Append ("VIOLET", new wxColour (79, 47, 79));
  Append ("VIOLET RED", new wxColour (204, 50, 153));
  Append ("WHEAT", new wxColour (216, 216, 191));
  Append ("WHITE", new wxColour (255, 255, 255));
  Append ("YELLOW", new wxColour (255, 255, 0));
  Append ("YELLOW GREEN", new wxColour (153, 204, 50));
#endif
}

/*
 * Changed by Ian Brown, July 1994.
 *
 * When running under X, the Colour Database starts off empty. The X server
 * is queried for the colour first time after which it is entered into the
 * database. This allows our client to use the server colour database which
 * is hopefully gamma corrected for the display being used.
 */

wxColour *wxColourDatabase::FindColour(const char *colour)
{
  wxNode *node = Find(colour);
  if (node)
    return (wxColour *)node->Data();
#ifdef wx_msw
  else return NULL;
#else
  else {
    XColor xcolour;

#ifdef wx_motif
    Display *display = XtDisplay(wxTheApp->topLevel) ;
#endif
#ifdef wx_xview
    Xv_Screen screen = xv_get(xview_server, SERVER_NTH_SCREEN, 0);
    Xv_opaque root_window = xv_get(screen, XV_ROOT);
    Display *display = (Display *)xv_get(root_window, XV_DISPLAY);
#endif

    if (!XParseColor(display, wxMainColormap,colour,&xcolour))
      return NULL;

    unsigned char r = (unsigned char)(xcolour.red >> 8);
    unsigned char g = (unsigned char)(xcolour.green >> 8);
    unsigned char b = (unsigned char)(xcolour.blue >> 8);

    wxColour *col = new wxColour(r, g, b);
    Append(colour, col);

    return col;
  }
#endif
}

/* Old FindColour
wxColour *wxColourDatabase::FindColour (const char *colour)
{
  wxNode *node = Find (colour);
  return node ? (wxColour *) node->Data () : NULL ;
}
*/

char *wxColourDatabase::FindName (wxColour& colour)
{
  unsigned char red = colour.Red ();
  unsigned char green = colour.Green ();
  unsigned char blue = colour.Blue ();

  for (wxNode * node = First (); node; node = node->Next ())
    {
      wxColour *col = (wxColour *) node->Data ();
      if (col->Red () == red && col->Green () == green && col->Blue () == blue)
	{
	  char *found = node->key.string;
	  if (found)
	    return found;
	}
    }
  return NULL;			// Not Found

}


void 
wxInitializeStockObjects (void)
{
  wxTheBrushList = new wxBrushList;
  wxThePenList = new wxPenList;
  wxTheIconList = new wxGDIList;
  wxTheFontList = new wxFontList;
  wxTheBitmapList = new wxGDIList;
  wxTheCursorList = new wxGDIList;
  // Must be created before wxTheColourDatabase
  //wxTheColourList =  new wxGDIList;

#ifdef wx_motif
#endif
#ifdef wx_x
  wxFontPool = new XFontPool;
#endif

  wxNORMAL_FONT = new wxFont (12, wxMODERN, wxNORMAL, wxNORMAL);
  wxSMALL_FONT = new wxFont (10, wxSWISS, wxNORMAL, wxNORMAL);
  wxITALIC_FONT = new wxFont (12, wxROMAN, wxITALIC, wxNORMAL);
  wxSWISS_FONT = new wxFont (12, wxSWISS, wxNORMAL, wxNORMAL);

  wxRED_PEN = new wxPen ("RED", 1, wxSOLID);
  wxCYAN_PEN = new wxPen ("CYAN", 1, wxSOLID);
  wxGREEN_PEN = new wxPen ("GREEN", 1, wxSOLID);
  wxBLACK_PEN = new wxPen ("BLACK", 1, wxSOLID);
  wxWHITE_PEN = new wxPen ("WHITE", 1, wxSOLID);
  wxTRANSPARENT_PEN = new wxPen ("BLACK", 1, wxTRANSPARENT);
  wxBLACK_DASHED_PEN = new wxPen ("BLACK", 1, wxSHORT_DASH);
  wxGREY_PEN = new wxPen ("GREY", 1, wxSOLID);
  wxMEDIUM_GREY_PEN = new wxPen ("MEDIUM GREY", 1, wxSOLID);
  wxLIGHT_GREY_PEN = new wxPen ("LIGHT GREY", 1, wxSOLID);

  wxBLUE_BRUSH = new wxBrush ("BLUE", wxSOLID);
  wxGREEN_BRUSH = new wxBrush ("GREEN", wxSOLID);
  wxWHITE_BRUSH = new wxBrush ("WHITE", wxSOLID);
  wxBLACK_BRUSH = new wxBrush ("BLACK", wxSOLID);
  wxTRANSPARENT_BRUSH = new wxBrush ("BLACK", wxTRANSPARENT);
  wxCYAN_BRUSH = new wxBrush ("CYAN", wxSOLID);
  wxRED_BRUSH = new wxBrush ("RED", wxSOLID);
  wxGREY_BRUSH = new wxBrush ("GREY", wxSOLID);
  wxMEDIUM_GREY_BRUSH = new wxBrush ("MEDIUM GREY", wxSOLID);
  wxLIGHT_GREY_BRUSH = new wxBrush ("LIGHT GREY", wxSOLID);

  wxBLACK = new wxColour ("BLACK");
  wxWHITE = new wxColour ("WHITE");
  wxRED = new wxColour ("RED");
  wxBLUE = new wxColour ("BLUE");
  wxGREEN = new wxColour ("GREEN");
  wxCYAN = new wxColour ("CYAN");
  wxLIGHT_GREY = new wxColour ("LIGHT GREY");

  wxSTANDARD_CURSOR = new wxCursor (wxCURSOR_ARROW);
  wxHOURGLASS_CURSOR = new wxCursor (wxCURSOR_WAIT);
  wxCROSS_CURSOR = new wxCursor (wxCURSOR_CROSS);
}

void 
wxDeleteStockObjects (void)
{
  if (wxBLACK)
    delete wxBLACK;
  if (wxWHITE)
    delete wxWHITE;
  if (wxRED)
    delete wxRED;
  if (wxBLUE)
    delete wxBLUE;
  if (wxGREEN)
    delete wxGREEN;
  if (wxCYAN)
    delete wxCYAN;
  if (wxLIGHT_GREY)
    delete wxLIGHT_GREY;

  if (wxSTANDARD_CURSOR)
    delete wxSTANDARD_CURSOR;
  if (wxHOURGLASS_CURSOR)
    delete wxHOURGLASS_CURSOR;
  if (wxCROSS_CURSOR)
    delete wxCROSS_CURSOR;
}

// Pens

wxbPen::wxbPen (void)
{
  __type = wxTYPE_PEN;
}

wxbPen::~wxbPen ()
{
}

wxbPen::wxbPen (wxColour& col, int Width, int Style)
{
  __type = wxTYPE_PEN;
}

wxbPen::wxbPen (const char *col, int Width, int Style)
{
  __type = wxTYPE_PEN;
}

int wxbPen::GetWidth (void)
{
  return width;
}

int wxbPen::GetStyle (void)
{
  return style;
}

int wxbPen::GetJoin (void)
{
  return join;
}

wxBitmap *wxbPen::GetStipple (void)
{
  return stipple;
}

int wxbPen::GetCap (void)
{
  return cap;
}

int wxbPen::GetDashes (wxDash ** ptr)
{
  *ptr = dash;
  return nb_dash;
}

wxColour& wxbPen::GetColour (void)
{
  return colour;
}

void wxbPen::SetColour (wxColour& col)
{
  // Must allocate BEFORE deleting, since &col can be a ref to this->colour!
/*
  wxColour *newcol = new wxColour ();
  *newcol = col;
  if (colour)
    delete colour;
  colour = newcol;
*/
  colour = col;
}

void wxbPen::SetColour (const char *col)
{
/*
  if (colour)
    delete colour;
  colour = new wxColour (col);
*/
  colour = col;
}

void wxbPen::SetColour (char red, char green, char blue)
{
/*
  if (colour)
    delete colour;
  colour = new wxColour (red, green, blue);
*/
 colour.Set(red, green, blue);
}

void wxbPen::SetWidth (int Width)
{
  width = Width;
}

void wxbPen::SetCap (int Cap)
{
  cap = Cap;
}

void wxbPen::SetJoin (int Join)
{
  join = Join;
}

void wxbPen::SetStyle (int Style)
{
  style = Style;
}

void wxbPen::SetDashes (int nbDash, wxDash * Dash)
{
  nb_dash = nbDash;
  dash = Dash;
}

void wxbPen::SetStipple (wxBitmap * Stipple)
{
  stipple = Stipple;
}

// Brushes

wxbBrush::wxbBrush (void)
{
  __type = wxTYPE_BRUSH;
}

wxbBrush::~wxbBrush ()
{
}

wxbBrush::wxbBrush (wxColour& col, int Style)
{
  __type = wxTYPE_BRUSH;
}

wxbBrush::wxbBrush (char *col, int Style)
{
  __type = wxTYPE_BRUSH;
}

int wxbBrush::GetStyle (void)
{
  return style;
}

wxBitmap *wxbBrush::GetStipple (void)
{
  return stipple;
}

wxColour& wxbBrush::GetColour (void)
{
  return colour;
}

void wxbBrush::SetColour (wxColour& col)
{
/*
  // Must allocate BEFORE deleting, since &col can be a ref to this->colour!
  wxColour *newcol = new wxColour ();
  *newcol = col;
  if (colour)
    delete colour;
  colour = newcol;
*/
  colour = col;
}

void wxbBrush::SetColour (const char *col)
{
/*
  if (colour)
    delete colour;
  colour = new wxColour (col);
*/
  colour = col;
}

void wxbBrush::SetColour (char red, char green, char blue)
{
/*
  if (colour)
    delete colour;
  colour = new wxColour (red, green, blue);
*/
  colour.Set(red, green, blue);
}

void wxbBrush::SetStyle (int Style)
{
  style = Style;
}

void wxbBrush::SetStipple (wxBitmap * Stipple)
{
  stipple = Stipple;
}

// Icons
wxbIcon::wxbIcon (void)
{
  __type = wxTYPE_ICON;
}

wxbIcon::wxbIcon (char bits[], int width, int height)
{
  __type = wxTYPE_ICON;
}

wxbIcon::wxbIcon (const char *icon_file)
{
  __type = wxTYPE_ICON;
}

wxbIcon::~wxbIcon (void)
{
}

wxGDIList::wxGDIList (void)
{
}

wxGDIList::~wxGDIList (void)
{
// This causes a crash in Motif, when wxTheColourList
  // is deleted. Not sure why yet -- may be something to
  // do with wxColour access this object (which is
  // being deleted)
#ifndef wx_x
  wxNode *node = First ();
  while (node)
    {
      wxObject *object = (wxObject *) node->Data ();
      wxNode *next = node->Next ();
      delete object;
      node = next;
    }
#endif
}

// Cursors
// NB Should delete loaded Windows cursors with DestroyCursor!!!
wxbCursor::wxbCursor (char bits[], int width, int height)
{
  __type = wxTYPE_CURSOR;
}

wxbCursor::wxbCursor (void)
{
  __type = wxTYPE_CURSOR;
}

wxbCursor::wxbCursor (const char *cursor_file)
{
  __type = wxTYPE_CURSOR;
}

// Cursors by stock number
wxbCursor::wxbCursor (int cursor_type)
{
  __type = wxTYPE_CURSOR;
}

wxbCursor::~wxbCursor (void)
{
}

// Pen and Brush lists
wxPenList::~wxPenList (void)
{
  wxNode *node = First ();
  while (node)
    {
      wxPen *pen = (wxPen *) node->Data ();
      wxNode *next = node->Next ();
      delete pen;
      node = next;
    }
}

void wxPenList::AddPen (wxPen * pen)
{
  Append (pen);
}

void wxPenList::RemovePen (wxPen * pen)
{
  DeleteObject (pen);
}

wxPen *wxPenList::FindOrCreatePen (wxColour * colour, int width, int style)
{
  if (!colour)
    return NULL;

  for (wxNode * node = First (); node; node = node->Next ())
    {
      wxPen *each_pen = (wxPen *) node->Data ();
      if (each_pen &&
	  each_pen->GetWidth () == width &&
	  each_pen->GetStyle () == style &&
	  each_pen->GetColour ().Red () == colour->Red () &&
	  each_pen->GetColour ().Green () == colour->Green () &&
	  each_pen->GetColour ().Blue () == colour->Blue ())
	return each_pen;
    }
  return new wxPen (*colour, width, style);
}

wxPen *wxPenList::FindOrCreatePen (char *colour, int width, int style)
{
  wxColour *the_colour = wxTheColourDatabase->FindColour (colour);
  if (the_colour)
    return FindOrCreatePen (the_colour, width, style);
  else
    return NULL;
}

wxBrushList::~wxBrushList (void)
{
  wxNode *node = First ();
  while (node)
    {
      wxBrush *brush = (wxBrush *) node->Data ();
      wxNode *next = node->Next ();
      delete brush;
      node = next;
    }
}

void wxBrushList::AddBrush (wxBrush * brush)
{
  Append (brush);
}

wxBrush *wxBrushList::FindOrCreateBrush (wxColour * colour, int style)
{
  if (!colour)
    return NULL;

  for (wxNode * node = First (); node; node = node->Next ())
    {
      wxBrush *each_brush = (wxBrush *) node->Data ();
      if (each_brush &&
	  each_brush->GetStyle () == style &&
	  each_brush->GetColour ().Red () == colour->Red () &&
	  each_brush->GetColour ().Green () == colour->Green () &&
	  each_brush->GetColour ().Blue () == colour->Blue ())
	return each_brush;
    }
  return new wxBrush (*colour, style);
}

wxBrush *wxBrushList::FindOrCreateBrush (char *colour, int style)
{
  wxColour *the_colour = wxTheColourDatabase->FindColour (colour);
  if (the_colour)
    return FindOrCreateBrush (the_colour, style);
  else
    return NULL;
}


void wxBrushList::RemoveBrush (wxBrush * brush)
{
  DeleteObject (brush);
}

wxFontList::~wxFontList (void)
{
  wxNode *node = First ();
  while (node)
    {
      wxFont *font = (wxFont *) node->Data ();
      wxNode *next = node->Next ();
      delete font;
      node = next;
    }
}

void wxFontList::AddFont (wxFont * font)
{
  Append (font);
}

void wxFontList::RemoveFont (wxFont * font)
{
  DeleteObject (font);
}

wxFont *wxFontList::
FindOrCreateFont (int PointSize, int Family, int Style, int Weight, Bool underline)
{
  for (wxNode * node = First (); node; node = node->Next ())
    {
      wxFont *each_font = (wxFont *) node->Data ();
      if (each_font &&
	  each_font->GetPointSize () == PointSize &&
	  each_font->GetStyle () == Style &&
	  each_font->GetWeight () == Weight &&
	  each_font->GetFamily () == Family &&
	  each_font->GetUnderlined () == underline)
	return each_font;
    }
  return new wxFont (PointSize, Family, Style, Weight, underline);
}

#if (!USE_TYPEDEFS)
wxPoint::wxPoint (void)
{
}

wxPoint::wxPoint (float the_x, float the_y)
{
  x = the_x;
  y = the_y;
}

wxPoint::~wxPoint (void)
{
}
#endif

#if (!USE_TYPEDEFS)
wxIntPoint::wxIntPoint (void)
{
}

wxIntPoint::wxIntPoint (int the_x, int the_y)
{
  x = the_x;
  y = the_y;
}

wxIntPoint::~wxIntPoint (void)
{
}
#endif

wxbBitmap::wxbBitmap (char bits[], int the_width, int the_height, int no_bits)
{
  __type = wxTYPE_BITMAP;
}

wxbBitmap::wxbBitmap (char *bitmap_file)
{
  __type = wxTYPE_BITMAP;
}

wxbBitmap::wxbBitmap (int w, int h, int d)
{
  __type = wxTYPE_BITMAP;
}

wxbBitmap::~wxbBitmap (void)
{
}
