/* screen.h - "smart" display handling */

/* Written 1994,1995 by Werner Almesberger */


#ifndef SCREEN_H
#define SCREEN_H


typedef struct {
    char *v_chr,*v_attr;
    int rows,cols;
    int cx,cy;
    int attrib;
} SCR_CTX;


void scr_begin(void);

/* Initializes the display for full-screen operation. */

void scr_end(void);

/* Returns to non-full-screen mode. */

void scr_clear(void);

/* Clears the virtual screen. */

void scr_clrtoeol(void);

/* Clears the virtual screen from the current cursor position to the end of the
   line. */

void scr_bold(int on);

/* Enables or disables "bold" mode (actually, it's reverse), depending on
   ON. */

void scr_move(int y,int x);

/* Sets the virtual cursor to (X,Y). X and Y are zero-based. */

void scr_puts(const char *str);

/* Puts STR at the current position on the virtual screen. */

void scr_printf(const char *fmt,...);

/* Displays a printf-style string at the current cursor position on the virtual
   screen. */

void scr_sync(void);

/* Updates the real screen. */

int scr_cols(void);

/* Returns the number of columns of the display. */

int scr_rows(void);

/* Returns the number of rows of the display. */

void scr_redraw(void);

/* Redraws the physical screen. */

void scr_resize(void);

/* Resizes the display after a SIGWINCH. */

void scr_suspend(int sig);

/* Suspends the program. If SIG is non-zero, SIGSUSP is delivered to the
   program. Otherwise, a sub-shell is started. */

void scr_save(SCR_CTX *ctx);

/* Saves the entire screen context including the current screen contents. */

void scr_restore(SCR_CTX ctx);

/* Restores the screen context saved with SCR_SAVE. A context can only be
   restored once. */

#endif
