/* scend.h - common variables, functions and data structures */

/* Written 1994,1995 by Werner Almesberger */


#ifndef SCEND_H
#define SCEND_H

#include "descr.h"


typedef struct _unused {
    const char *var;
    const char *value;
    int on;
    struct _unused *next;
} UNUSED;


extern ITEM *descr;	/* configuration description tree */
extern UNUSED *unused;	/* list of variables not unsed in this session */
extern const char *subtitle; /* NULL or title of configuration */
extern int changed;	/* 1 if any variable has been changed */
extern int test;	/* 1 if running in regression test mode */
extern int seen;	/* 1 when marking all entries as seen */
extern int edit_group;	/* 1 when editing group defaults */
extern int demo;	/* 1 if running in demo mode (show everything) */


void output(const char *name);

/* Writes the translated output to file NAME. */

const char *write_cfg(const char *name);

/* Writes the current configuration to file NAME. Returns NULL on success, a
   pointer to a (static) error message on failure. */

void read_cfg(char flags,int record);

/* Reads a set of variable settings. The flags of each variable accessed by
   those settings are set to FLAGS. If unused variables are found, they are
   recorded in UNUSED if RECORD is set. Note that only one run of READ_CFG with
   RECORD is possible per session. */

void edit(const char *outfile);

/* Allows editing of the currently loaded configuration. OUTFILE is either NULL or points to the
   name of the desired variables output file. If OUTFILE is NULL, no variables
   can be saved. */

#endif
