/* parse.h - universal lexical scanner for all file formats SCEND uses */

/* Written 1994,1995 by Werner Almesberger */


#ifndef PARSE_H
#define PARSE_H

#include "descr.h"


#define MAX_TOKEN 1024


extern int ch;			/* character returned by last NEXT() */
extern int quoted_string;	/* 1 if the last token was a quoted string */
extern char token[];		/* token returned by last NEXT() */


void parse_error(const char *msg,...);

/* Issues an error message and terminates the program. */

int next(void);

/* Gets the next token. Returns the value of single-character tokens directly.
   For multi-character (i.e. string) tokens, 0 is returned and the
   corresponding string is stored in TOKEN. */

void back(void);

/* Returns the last token. */

int non_eof(void);

/* Like NEXT, but yields a parse error if the next token is EOF. */

const char *string(void);

/* Like NEXT, but yields a parse error if the next token is not a string.
   Returns a pointer to TOKEN.  */

int number(int *base);

/* Like NEXT, but yields a parse error if the next token is not a number.
   Returns the base of the number in *BASE if BASE is non-null.  */

const char *parse_help(void);

/* Parses a help text (text enclosed in angle brackets) and returns a pointer
   to it. If there is no text, NULL is returned. */

VALUE *values(ITEM *parent,int *length,void (*fn)(ITEM *this,int i));

/* Returns a pointer to a list of values. PARENT is the parent item of the
   values list. The length of the list is stored in *LENGTH. FN is invoked for
   all values that are marked as defaults. When invoking FN, THIS is set to
   PARENT and I is the (zero-based) value index. */

ITEM *section(ITEM *parent);

/* Parses a section and returns a pointer to it. PARENT is the parent item.
   Note that the opening curly brace must have been parsed before. */

void parse_open(const char *name);

/* Opens the file NAME and initializes the lexical scanner. */

void parse_close(void);

/* Closes the file currently being scanned. */

#endif
