/* common.h - common utility routines */

/* Written 1994,1995 by Werner Almesberger */


#ifndef COMMON_H
#define COMMON_H

#include <sys/types.h>


#define alloc_t(T) ((T *) alloc(sizeof(T)))

void *alloc(size_t size);

/* Allocate SIZE bytes of memory. Die if no memory is available. */

char *stralloc(const char *str);

/* Like strdup() but dies if it can't allocate memory. */

void die(const char *msg,...);

/* Leave full-screen mode, display an error message (printf-style) and
   terminate the program. */

#endif
