#include <stdio.h>
#include <unistd.h>
#include <malloc.h>
#include <sys/mman.h>
#include <linux/unistd.h>
#include <linux/mman.h>

_syscall2(int, mlock, const void *, addr, size_t, len)
_syscall2(int, munlock, const void *, addr, size_t, len)
_syscall1(int, mlockall, int, how)
_syscall0(int, munlockall)

#define PAGESIZE 4096

#define KBYTE 1024
#define MBYTE KBYTE*KBYTE
#define SIZE 1*MBYTE

#define show_vma()	mlockall( MCL_VMA )
#define show_process()	mlockall( MCL_PROCESS )
#define show_memory()	mlockall( MCL_MEMORY )

void main()
{
  int ret,i;

  ret = mlockall( MCL_CURRENT );
  if( ret == -1 ) perror("mlockall");

  show_memory();
  show_vma();

  if(fork()) {
    /* father */
    wait(0);
    show_memory();
    show_vma();
  }
  else {
    /* child */
    ret = mlockall( MCL_CURRENT );
    if( ret == -1 ) perror("mlockall");
    show_memory();
    show_vma();
    exit(0);
  }

  ret = munlockall( );
  if( ret == -1 ) perror("munlockall");

  sleep(5);

}
