#include <stdio.h>
#include <unistd.h>
#include <malloc.h>
#include <sys/mman.h>
#include <linux/unistd.h>
#include <linux/mman.h>

_syscall2(int, mlock, const void *, addr, size_t, len)
_syscall2(int, munlock, const void *, addr, size_t, len)
_syscall1(int, mlockall, int, how)
_syscall0(int, munlockall)

#define PAGESIZE 4096

#define KBYTE 1024
#define MBYTE KBYTE*KBYTE
#define SIZE 1*MBYTE

#define show_vma()	mlockall( MCL_VMA )
#define show_process()	mlockall( MCL_PROCESS )
#define show_memory()	mlockall( MCL_MEMORY )

unsigned char test[SIZE];
unsigned char *ptr;

void testfunc()
{
  unsigned char data[SIZE];
  int i;

  for( i=0 ; i<SIZE ; i+=PAGESIZE )
    data[i] = i;
}

void main()
{
  int ret,i;

  ret = mlockall( MCL_CURRENT|MCL_FUTURE );
  if( ret == -1 ) perror("mlockall");

  show_memory();
  show_vma();

  execlp("show","");

  ret = munlockall( );
  if( ret == -1 ) perror("munlockall");

  sleep(5);

}
