
/*
 * Copyright 1993, 1994, 1995 by the Regents of the University of California
 * see the file "Copyright" in the distribution for conditions of use.
 */

static int bell_rung = 0;

#include <stdio.h>
#include <time.h>

static time_t tstamp = 0;
static time_t tstamp_prev = 0;

#define INC_BAD 200

ring_bell()
{

	/* prevent infinite loops ringing the bell */
	if( bell_rung++ > 10*INC_BAD ) fatal("too many errors" );
	if( bell_rung >= INC_BAD ) {
		if( ( bell_rung % INC_BAD ) == 0 ) {
			tstamp_prev = tstamp;
			time( &tstamp );
			if( tstamp < tstamp_prev + 20 ) {
				fatal( "too many errors in time period" );
			}
		}
	}

	putchar('');
	fflush(stdout);
}
