
/*
 * Copyright 1993, 1994, 1995 by the Regents of the University of California
 * see the file "Copyright" in the distribution for conditions of use.
 */

#include <curses.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>

#include "node.h"
#include "misc.h"

extern int optind;
extern char *optarg;

int dump_flag;
int tree_flag;
int curses_active = 0;

int n_nodes;
NODE *node[MAX_NODES];

/*
 *	UCLink Menu System, main program.
 *
 *	usage:
 *		menu [-dtl] [base_dir]
 *	options:
 *		-d	dump nodes and exit
 *		-t	print tree and exit
 *		-l	line mode instead of full screen - probably
 *				no longer works
 *		base_dir
 *			path name of directory for global menu_rc,
 *				shell scripts, logs, etc.
 *	default:	just run menu
 */

main( argc, argv )
int argc;
char **argv;
{
	int c;
	char config_file_name[50];
	FILE *config_file;
	int main_num;
	int i;

	set_sigs();
	undefine_suspend();
 
	/* parse options */
	while ((c = getopt (argc, argv, "dt")) != EOF)
		switch (c) {
		case 'd':
			dump_flag++;
			break;
		case 't':
			tree_flag++;
			break;
		default:
			usage();
		}

	if( optind != argc ) {
		usage();
	}


	/* set up environment variables, base_dir var.,
			add menu program "lib" to path, ... */

	init_env();

	/* open menu description file */

	strcpy( config_file_name, base_dir );
	strcat( config_file_name, "/etc/menu.config" );
	config_file = fopen( config_file_name, "r" );
	if( config_file == NULL) {
		fprintf(stderr," file: %s\n", config_file_name );
		desc_err("can't open menu config file" );
	}

	/* read the menu desciption from the global config file */
	main_num = read_descrip( config_file );

	/*	basic initialization for short cuts.
	 *	- must follow reading menu, to define Short_Cuts menu node
	 *	- must precede reading short cuts from .menurc or config file
	 */
	init_short_cuts();

	/* abbreviated runs */
	if( dump_flag ) {
		dump_nodes();
		endit(0);
	} else if( tree_flag ) {
		print_tree( main_num, 0 );
		endit(0);
	}

	/* check and start the logging if we are logging */
	log_init();

	i = read_user_menurc();
	if( i == 0 ) {
		/* no .menurc: read defaults from end of global config. file */
		read_defaults( config_file );
	}
	fclose( config_file );

	entry_messages();

	update_short_cuts();
	run_menu( main_num );
	die();
}

static
entry_messages()
{
	char temp[100];
	struct stat stat_buf;

	strcpy( temp, "more -d " );
	strcat( temp, base_dir );
	strcat( temp, "/etc/Menu_News" );
	if( stat( temp+8, &stat_buf ) == 0  && stat_buf.st_size > 0
			&& ((stat_buf.st_mode & 1) == 1 ) ) {
		system( temp );
		printf("\nPress Return to continue: ");
		getchar();
	}

	strcpy( temp, base_dir );
	strcat( temp, "/lib/Menu_init" );
	if( stat( temp, &stat_buf ) == 0 && stat_buf.st_size > 0 ) {
		system( temp );
	}
}

exit_messages()
{
	char temp[100];
	struct stat stat_buf;

	strcpy( temp, base_dir );
	strcat( temp, "/lib/Menu_end" );
	if( stat( temp, &stat_buf ) == 0 && stat_buf.st_size > 0
			&& ((stat_buf.st_mode & 1) == 1 ) ) {
		system( temp );
	}
}

usage()
{
	printf("*** unrecognized option\n");
	printf("*** legal options are -d to dump nodes, -t to dump tree\n");
	exit(1);
}
