# jentrybasic.tcl - support for basic Entry bindings
# 
# Copyright 1992-1994 by Jay Sekora.  All rights reserved, except 
# that this file may be freely redistributed in whole or in part 
# for non-profit, noncommercial use.

######################################################################
# NOTE:
#   the "jentryemacs.tcl" and "jentryvi.tcl" libraries contain actual
#   procedures for emulation-specific actions.  "basic" bindings,
#   however, don't use anything that isn't general (and therefore
#   in jentrytext.tcl), so this file just has j:eb:basic_init in it.
######################################################################

######################################################################
# j:eb:basic_init - initialise info for basic Entry bindings
######################################################################

proc j:eb:basic_init { e } {
  global j_teb
  set j_teb(cutbuffer) {}
  set j_teb(dragscroll,txnd) 0
  set j_teb(dragscroll,delay) 50
  set j_teb(scanpaste_time) 0
  set j_teb(scanpaste_paste) 1
    
  set j_teb(keymap,$e) basic
  
  # in tk4, we need to make sure tkTextBind is called _before_
  #   j:tb:key_bind!
  j:tk4 {tkEntryBind Enter}
  
  j:eb:key_bind $e
  j:eb:mouse_bind $e
  
  j:ekb:mkmap Entry basic basic {
    {Control-slash		j:eb:select_all}
    {Control-backslash		j:eb:clear_selection}
    
    {Delete			j:ekb:delete_left}
    {BackSpace			j:ekb:delete_left}
    {Return			j:ekb:self_insert}
    
    {Left			j:ekb:left}
    {Right			j:ekb:right}
    
    {Home			j:ekb:bol}
    {End			j:ekb:eol}
    
    {Control-v			j:eb:paste_selection}
    {Control-i			j:ekb:self_insert}
    {Control-j			j:ekb:self_insert}
    {Control-h			j:ekb:delete_left}
    
    {Control-DEFAULT		j:eb:no_op}
    {DEFAULT			j:ekb:self_insert}
    {Shift-DEFAULT		j:ekb:self_insert}
  }
}

# deprecated alias for backward compatibility:

proc j:eb:basic_bind { W args } {
  j:eb:basic_init $W
}
