# jedit_prefs.tcl - preferences commands and procs for jedit
#   (jedit:prefs:menus is in jedit_menus.tcl, for convenience.)
# 
# Copyright 1992-1994 by Jay Sekora.  All rights reserved, except 
# that this file may be freely redistributed in whole or in part 
# for non-profit, noncommercial use.

# TO DO
#   MAKE ALL THIS PER-WINDOW!
#   file_modes panel
#   word-end punctuation (and heuristics) sd be mode-specific

######################################################################



######################################################################
# editor-wide preferences panel
#   { t args } lets it be used with j:tkb:mkmap
######################################################################

proc jedit:cmd:edit_prefs { t args } {
  global JEDIT_PREFS
  
  set w .edit_prefs
  toplevel $w
  wm title $w "Editor Preferences"
  
  j:colour_chooser $w.textbg -variable JEDIT_PREFS(textbg) \
    -label "Normal Background:"
  j:colour_chooser $w.textfg -variable JEDIT_PREFS(textfg) \
    -label "Normal Foreground:"
  j:colour_chooser $w.textsb -variable JEDIT_PREFS(textsb) \
    -label "Selected Background:"
  j:colour_chooser $w.textsf -variable JEDIT_PREFS(textsf) \
    -label "Selected Foreground:"
  
  label $w.textiw-label -text "Insert Width:" -anchor w
  scale $w.textiw -from 1 -to 25 -orient horizontal \
    -command {set JEDIT_PREFS(textiw)}
  $w.textiw set $JEDIT_PREFS(textiw)
  
  label $w.textsbw-label -text "Selection Border Width:" -anchor w
  scale $w.textsbw -from 0 -to 25  -orient horizontal \
    -command {set JEDIT_PREFS(textsbw)}
  $w.textsbw set $JEDIT_PREFS(textsbw)
  
  label $w.textbw-label -text "Text Border Width:" -anchor w
  scale $w.textbw -from 0 -to 50  -orient horizontal \
    -command {set JEDIT_PREFS(textbw)}
  $w.textbw set $JEDIT_PREFS(textbw)
  
  label $w.undolevels-label -text "Undo Levels:" -anchor w
  scale $w.undolevels -from 0 -to 10  -orient horizontal \
    -command {set JEDIT_PREFS(undolevels)}
  $w.undolevels set $JEDIT_PREFS(undolevels)
  
  j:buttonbar $w.b -default save -buttons [format {
    {
      save Save {
        j:write_prefs -array JEDIT_PREFS -directory $env(HOME)/.tk \
          -file jedit-defaults
        %s.b.done invoke
      }
    } {
      done Done {
        jedit:apply_all_prefs [jedit:text_to_top %s]
        destroy %s
      }
    }
  } $w $t $w]
  
  pack \
    $w.textbg \
    [j:rule $w] \
    $w.textfg \
    [j:rule $w] \
    $w.textsb \
    [j:rule $w] \
    $w.textsf \
    [j:rule $w] \
    $w.textiw-label $w.textiw \
    [j:filler $w] \
    $w.textsbw-label $w.textsbw \
    [j:filler $w] \
    $w.textbw-label $w.textbw \
    [j:rule $w] \
    $w.undolevels-label $w.undolevels \
    [j:rule $w] \
    $w.b \
    -fill x
  
  j:dialogue $w
  j:default_button $w.b.save $w
  focus $w
  tkwait window $w
}
######################################################################
# jedit:cmd:mode_prefs - mode-specific preferences panel
#   { t args } lets it be used with j:tkb:mkmap
######################################################################

proc jedit:cmd:mode_prefs { t args } {
  global JEDIT_MODEPREFS env tk_strictMotif
  
  set mode [jedit:get_mode $t]
  
  set window [jedit:text_to_top $t]

  toplevel .mode_prefs
  wm title .mode_prefs "Mode\255Specific Preferences"
  
  label .mode_prefs.mode -text "Preferences for mode \"$mode\""
  
  pack .mode_prefs.mode -expand y -fill x
  
  j:buttonbar .mode_prefs.b -default save -buttons [format {
    {
      save Save {
        set tmp_mode %s
        j:write_prefs -array JEDIT_MODEPREFS -prefix $tmp_mode \
          -directory $env(HOME)/.tk/jeditmodes \
          -file ${tmp_mode}-defaults
        .mode_prefs.b.done invoke
      }
    } {
      done Done {
        set tmp_mode %s
        if {$JEDIT_MODEPREFS($tmp_mode,textwidth) < 20} {
          set JEDIT_MODEPREFS($tmp_mode,textwidth) 20
        }
        if {$JEDIT_MODEPREFS($tmp_mode,textheight) < 4} {
          set JEDIT_MODEPREFS($tmp_mode,textheight) 4
        }
        jedit:apply_all_prefs %s
        destroy .mode_prefs
      }
    }
  } $mode $mode $window]
  
  frame .mode_prefs.ui_prefs
  lower .mode_prefs.ui_prefs
  frame .mode_prefs.other_prefs
  lower .mode_prefs.other_prefs
  pack \
    [j:rule .mode_prefs] \
    [jedit:prefs:menus .mode_prefs.menus $mode] \
    [j:rule .mode_prefs] \
    [jedit:prefs:buttonbar .mode_prefs.buttonbar $mode] \
    -in .mode_prefs.ui_prefs -fill both
  pack \
    [j:rule .mode_prefs] \
    [jedit:prefs:io .mode_prefs.io $mode] \
    [j:rule .mode_prefs] \
    [jedit:prefs:autokeys .mode_prefs.autokeys $mode] \
    [j:rule .mode_prefs] \
    [jedit:prefs:abbrevs .mode_prefs.abbrevs $mode] \
    [j:rule .mode_prefs] \
    [jedit:prefs:wrap .mode_prefs.wrap $mode] \
    [j:rule .mode_prefs] \
    [jedit:prefs:font .mode_prefs.font $mode] \
    [j:rule .mode_prefs] \
    [jedit:prefs:size .mode_prefs.size $mode] \
    -in .mode_prefs.other_prefs -fill both
  pack \
    .mode_prefs.b \
    [j:rule .mode_prefs] \
    -fill x -side bottom
  pack \
    .mode_prefs.ui_prefs \
    [j:rule .mode_prefs] \
    .mode_prefs.other_prefs \
    -side left -fill y
  
  j:dialogue .mode_prefs		;# position in centre of screen

  focus .mode_prefs
  j:default_button .mode_prefs.b.save \
    .mode_prefs.font.bot.e \
    .mode_prefs.size.we \
    .mode_prefs.size.he \
    .mode_prefs

  j:tab_ring \
    .mode_prefs.font.bot.e \
    .mode_prefs.size.we \
    .mode_prefs.size.he
  
  bind .mode_prefs <Key-Tab> {focus .mode_prefs.font.bot.e}
  tkwait window .mode_prefs
}

proc jedit:prefs:buttonbar { w mode } {
  global JEDIT_MODEPREFS
  
  frame $w
  checkbutton $w.cb -relief flat -anchor w \
    -text {Show button bar} \
    -variable JEDIT_MODEPREFS($mode,buttonbar)
  pack $w.cb -side top -expand yes -fill x
  
  return $w
}

proc jedit:prefs:io { w mode } {
  global JEDIT_MODEPREFS
  
  frame $w
  checkbutton $w.cb -relief flat -anchor w \
    -text {Save/load highlighting and position} \
    -variable JEDIT_MODEPREFS($mode,savestate)
  pack $w.cb -side top -expand yes -fill x
  
  return $w
}

proc jedit:prefs:autokeys { w mode } {
  global JEDIT_MODEPREFS
  
  frame $w
  checkbutton $w.autobreak_cb -relief flat -anchor w \
    -text {Break long lines with <Space>} \
    -variable JEDIT_MODEPREFS($mode,autobreak)
  checkbutton $w.autoindent_cb -relief flat -anchor w \
    -text {Preserve indentation with <Return>} \
    -variable JEDIT_MODEPREFS($mode,autoindent)
  checkbutton $w.parenflash_cb -relief flat -anchor w \
    -text {Flash matching braces, brackets, and parentheses} \
    -variable JEDIT_MODEPREFS($mode,parenflash)
  pack \
    $w.autobreak_cb \
    $w.autoindent_cb \
    $w.parenflash_cb \
    -side top -expand yes -fill x
  
  return $w
}

proc jedit:prefs:abbrevs { w mode } {
  global JEDIT_MODEPREFS
  
  frame $w
  checkbutton $w.sabbrev_cb -relief flat -anchor w \
    -text {Expand static abbreviations with <Space>} \
    -variable JEDIT_MODEPREFS($mode,sabbrev)
  checkbutton $w.dabbrev_cb -relief flat -anchor w \
    -text {Expand dynamic abbreviations with <Tab>} \
    -variable JEDIT_MODEPREFS($mode,dabbrev)
  pack \
    $w.sabbrev_cb \
    $w.dabbrev_cb \
    -side top -expand yes -fill x
  
  return $w
}

proc jedit:prefs:wrap { w mode } {
  global JEDIT_MODEPREFS
  
  frame $w
  radiobutton $w.none -relief flat -anchor w \
    -text {Don't wrap lines} \
    -variable JEDIT_MODEPREFS($mode,textwrap) -value none
  radiobutton $w.char -relief flat -anchor w \
    -text {Wrap lines on character boundaries} \
    -variable JEDIT_MODEPREFS($mode,textwrap) -value char
  radiobutton $w.word -relief flat -anchor w \
    -text {Wrap lines at word boundaries} \
    -variable JEDIT_MODEPREFS($mode,textwrap) -value word
  pack \
    $w.none \
    $w.char \
    $w.word \
    -side top -expand yes -fill x
  
  return $w
}

proc jedit:prefs:font { w mode } {
  global JEDIT_MODEPREFS
  
  frame $w
  
  frame $w.top
  label $w.top.l -text {Font:}
  button $w.top.default -width 8 -text {Default} -command {
    set JEDIT_MODEPREFS($mode,textfont) {default}
  }
  button $w.top.choose -text {Choose . . .} -command {
    set JEDIT_MODEPREFS($mode,textfont) [j:prompt_font]
  }
  
  frame $w.bot
  entry $w.bot.e -relief sunken -width 50 \
    -textvariable JEDIT_MODEPREFS($mode,textfont)
  
  pack $w.top.l -side left
  pack $w.top.choose -side right -padx 10 -pady 5
  pack $w.top.default -side right -pady 5
  
  pack $w.bot.e -side left -padx 10 -pady 5
  
  pack \
    $w.top \
    $w.bot \
    -side top -expand yes -fill x
  
  return $w
}

proc jedit:prefs:size { w mode } {
  global JEDIT_MODEPREFS
  
  frame $w
  label $w.wl -text {Width:}
  entry $w.we -relief sunken -width 5 \
    -textvariable JEDIT_MODEPREFS($mode,textwidth)
  label $w.hl -text {Height:}
  entry $w.he -relief sunken -width 5 \
    -textvariable JEDIT_MODEPREFS($mode,textheight)
  
  pack $w.wl -side left -fill x -pady 5
  pack $w.we -side left -pady 5
  pack $w.hl -side left -fill x -pady 5
  pack $w.he -side left -pady 5
  
  return $w
}

