######################################################################
# record debugging information
######################################################################

global env J_PREFS
if {![info exists J_PREFS(scrollbarside)]} {set J_PREFS(scrollbarside) right}

if [info exists env(JSTOOLS_DEBUGGING)] {
proc j:debug { {string {j:debug called}} } {
  global J_PREFS
  set w .debug_log
  
  if { ! [winfo exists $w] } {
    toplevel $w
    wm minsize . 10 10
    text $w.t -yscrollcommand "$w.sb set" -setgrid true
    scrollbar $w.sb -relief flat -command "$w.t yview"
    pack $w.sb $w.t -side $J_PREFS(scrollbarside) -fill y
  }
  
  set level [expr [info level] - 1]
  $w.t insert end "$string\n"
  switch -exact -- $level {
    0 {
      $w.t insert end "in top level.\n"
    }
    1 {
      $w.t insert end "in `[info level -1]'.\n"
    }
    default {
      $w.t insert end "in `[info level -1]'\n"
      $w.t insert end "  called from `[info level -2]'.\n"
    }
  }
  $w.t yview -pickplace end
}
} else {
  proc j:debug args {}
}
